/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestContext
extends TestCase {
    Symbol p1 = Symbol.create("p1");
    Symbol p2 = Symbol.create("p2");

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestContext.class);
        ts.setName("TestContext");
        return ts;
    }

    public void testCxt1() {
        Context cxt = new Context();
    }

    public void testCxt2() {
        Context cxt = new Context();
        TestContext.assertTrue((String)"Defined in empty context", (!cxt.isDefined(this.p1) ? 1 : 0) != 0);
        cxt.set(this.p1, "v");
        TestContext.assertTrue((String)"Not defined after .set", (boolean)cxt.isDefined(this.p1));
        Object v = cxt.get(this.p1);
        TestContext.assertSame((String)"Not the same", (Object)"v", (Object)v);
    }

    public void testCxt3() {
        Context cxt = new Context();
        cxt.set(this.p1, "v");
        cxt.setIfUndef(this.p1, "w");
        Object v = cxt.get(this.p1);
        TestContext.assertSame((String)"Not as first set", (Object)"v", (Object)v);
    }

    public void testCxt4() {
        Context cxt = new Context();
        cxt.set(this.p1, "true");
        TestContext.assertTrue((String)"Not true", (boolean)cxt.isTrue(this.p1));
        TestContext.assertTrue((String)"Not true or undef", (boolean)cxt.isTrueOrUndef(this.p1));
        TestContext.assertTrue((String)"Not false or undef", (boolean)cxt.isFalseOrUndef(this.p2));
        TestContext.assertTrue((String)"False when undef", (!cxt.isFalse(this.p2) ? 1 : 0) != 0);
    }

    public void testCxt5() {
        Context cxt = new Context();
        cxt.set(this.p1, "false");
        TestContext.assertTrue((String)"Not false", (boolean)cxt.isFalse(this.p1));
        TestContext.assertTrue((String)"Not false or undef", (boolean)cxt.isFalseOrUndef(this.p1));
    }

    public void testCxt6() {
        Context cxt = new Context();
        cxt.setTrue(this.p1);
        TestContext.assertTrue((String)"Not true", (boolean)cxt.isTrue(this.p1));
        String x = cxt.getAsString(this.p1);
        TestContext.assertEquals((String)"Not string 'true'", (String)"true", (String)x);
    }
}

