/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.utilint.DbLsn;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CheckpointFileReader
extends FileReader {
    private boolean isRoot;
    private boolean isCheckpoint;
    private LogEntry rootLogEntryReader = LogEntryType.LOG_ROOT.getNewLogEntry();
    private LogEntry checkpointLogEntryReader = LogEntryType.LOG_CKPT_END.getNewLogEntry();
    private LogEntry useLogEntryReader;

    public CheckpointFileReader(EnvironmentImpl env, int readBufferSize, boolean forward, DbLsn startLsn, DbLsn finishLsn, DbLsn endOfFileLsn) throws IOException, DatabaseException {
        super(env, readBufferSize, forward, startLsn, null, endOfFileLsn, finishLsn);
    }

    protected boolean isTargetEntry(byte logEntryTypeNumber, byte logEntryTypeVersion) {
        boolean isTarget = false;
        this.isRoot = false;
        this.isCheckpoint = false;
        if (LogEntryType.LOG_CKPT_END.equalsType(logEntryTypeNumber, logEntryTypeVersion)) {
            isTarget = true;
            this.isCheckpoint = true;
            this.useLogEntryReader = this.checkpointLogEntryReader;
        } else if (LogEntryType.LOG_ROOT.equalsType(logEntryTypeNumber, logEntryTypeVersion)) {
            isTarget = true;
            this.isRoot = true;
            this.useLogEntryReader = this.rootLogEntryReader;
        }
        return isTarget;
    }

    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        this.useLogEntryReader.readEntry(entryBuffer);
        return true;
    }

    public Object getLastObject() {
        return this.useLogEntryReader.getMainItem();
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isCheckpoint() {
        return this.isCheckpoint;
    }
}

