/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.serial;

import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.ForeignKeyNullifier;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryKeyCreator;

public abstract class SerialSerialKeyCreator
implements SecondaryKeyCreator,
ForeignKeyNullifier {
    protected SerialBinding primaryKeyBinding;
    protected SerialBinding dataBinding;
    protected SerialBinding indexKeyBinding;

    public SerialSerialKeyCreator(ClassCatalog classCatalog, Class primaryKeyClass, Class dataClass, Class indexKeyClass) {
        this(new SerialBinding(classCatalog, primaryKeyClass), new SerialBinding(classCatalog, dataClass), new SerialBinding(classCatalog, indexKeyClass));
    }

    public SerialSerialKeyCreator(SerialBinding primaryKeyBinding, SerialBinding dataBinding, SerialBinding indexKeyBinding) {
        this.primaryKeyBinding = primaryKeyBinding;
        this.dataBinding = dataBinding;
        this.indexKeyBinding = indexKeyBinding;
    }

    public boolean createSecondaryKey(SecondaryDatabase db, DatabaseEntry primaryKeyEntry, DatabaseEntry dataEntry, DatabaseEntry indexKeyEntry) throws DatabaseException {
        Object dataInput;
        Object primaryKeyInput = this.primaryKeyBinding.entryToObject(primaryKeyEntry);
        Object indexKey = this.createSecondaryKey(primaryKeyInput, dataInput = this.dataBinding.entryToObject(dataEntry));
        if (indexKey != null) {
            this.indexKeyBinding.objectToEntry(indexKey, indexKeyEntry);
            return true;
        }
        return false;
    }

    public boolean nullifyForeignKey(SecondaryDatabase db, DatabaseEntry dataEntry) throws DatabaseException {
        Object data = this.dataBinding.entryToObject(dataEntry);
        if ((data = this.nullifyForeignKey(data)) != null) {
            this.dataBinding.objectToEntry(data, dataEntry);
            return true;
        }
        return false;
    }

    public abstract Object createSecondaryKey(Object var1, Object var2);

    public Object nullifyForeignKey(Object data) {
        return null;
    }
}

