/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.DatabaseTrigger;
import com.sleepycat.je.DatabaseUtil;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.JoinConfig;
import com.sleepycat.je.JoinCursor;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryTrigger;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TriggerTransaction;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.dbi.TruncateResult;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.Tracer;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Database {
    static DbState OPEN = new DbState("OPEN");
    static DbState CLOSED = new DbState("CLOSED");
    static DbState INVALID = new DbState("INVALID");
    private DbState state;
    Environment envHandle;
    private DatabaseImpl databaseImpl;
    DatabaseConfig configuration;
    private boolean isWritable;
    Locker handleLocker;
    private Set cursors = new HashSet();
    private List triggerList;

    protected Database(Environment env) {
        this.envHandle = env;
        this.handleLocker = null;
    }

    void initNew(Environment env, Locker locker, String databaseName, DatabaseConfig dbConfig) throws DatabaseException {
        if (dbConfig.getReadOnly()) {
            throw new DatabaseException("DatabaseConfig.setReadOnly() must be set to false when creating a Database");
        }
        this.init(env, dbConfig);
        EnvironmentImpl environmentImpl = DbInternal.envGetEnvironmentImpl(this.envHandle);
        this.databaseImpl = environmentImpl.createDb(locker, databaseName, dbConfig, this);
        this.databaseImpl.addReferringHandle(this);
    }

    void initExisting(Environment env, Locker locker, DatabaseImpl databaseImpl, DatabaseConfig dbConfig) throws DatabaseException {
        this.validateConfigAgainstExistingDb(dbConfig, databaseImpl);
        this.init(env, dbConfig);
        this.databaseImpl = databaseImpl;
        databaseImpl.addReferringHandle(this);
        this.configuration.setSortedDuplicates(databaseImpl.getSortedDuplicates());
        this.configuration.setTransactional(databaseImpl.isTransactional());
    }

    private void init(Environment env, DatabaseConfig config) throws DatabaseException {
        this.handleLocker = null;
        this.envHandle = env;
        this.configuration = config.cloneConfig();
        this.isWritable = !this.configuration.getReadOnly();
        this.state = OPEN;
    }

    private void validateConfigAgainstExistingDb(DatabaseConfig config, DatabaseImpl databaseImpl) throws DatabaseException {
        if (!config.getUseExistingConfig() && databaseImpl.getSortedDuplicates() != config.getSortedDuplicates()) {
            throw new DatabaseException("You can't open a Database with a duplicatesAllowed configuration of " + config.getSortedDuplicates() + " if the underlying database was created with a " + "duplicatesAllowedSetting of " + databaseImpl.getSortedDuplicates() + ".");
        }
        if (databaseImpl.hasOpenHandles()) {
            if (!config.getUseExistingConfig() && config.getTransactional() != databaseImpl.isTransactional()) {
                throw new DatabaseException("You can't open a Database with a transactional configuration of " + config.getTransactional() + " if the underlying database was created with a " + "transactional configuration of " + databaseImpl.isTransactional() + ".");
            }
        } else {
            databaseImpl.setTransactional(config.getTransactional());
        }
        if (config.getOverrideBtreeComparator()) {
            databaseImpl.setBtreeComparator(config.getBtreeComparator());
        }
        if (config.getOverrideDuplicateComparator()) {
            databaseImpl.setDuplicateComparator(config.getDuplicateComparator());
        }
    }

    public synchronized void close() throws DatabaseException {
        StringBuffer errors = null;
        this.checkEnv();
        this.checkProhibitedDbState(CLOSED, "Can't close Database:");
        Tracer.trace(Level.FINEST, this.envHandle.getEnvironmentImpl(), "Database.close: " + this);
        this.removeAllTriggers();
        this.envHandle.removeReferringHandle(this);
        if (this.cursors.size() > 0) {
            errors = new StringBuffer("There are open cursors against the database.\n");
            errors.append("They will be closed.\n");
            Iterator iter = new HashSet(this.cursors).iterator();
            while (iter.hasNext()) {
                Cursor dbc = (Cursor)iter.next();
                try {
                    dbc.close();
                }
                catch (DatabaseException DBE) {
                    errors.append("Exception while closing cursors:\n");
                    errors.append(DBE.toString());
                }
            }
        }
        if (this.databaseImpl != null) {
            this.databaseImpl.removeReferringHandle(this);
            this.databaseImpl = null;
            this.handleLocker.setHandleLockOwner(true, this, true);
            this.handleLocker.operationEnd(true);
            this.state = CLOSED;
        }
        if (errors != null) {
            throw new DatabaseException(errors.toString());
        }
    }

    public synchronized Cursor openCursor(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        this.checkEnv();
        this.checkRequiredDbState(OPEN, "Can't open a cursor");
        CursorConfig useConfig = cursorConfig == null ? CursorConfig.DEFAULT : cursorConfig;
        Tracer.trace(Level.FINEST, this.envHandle.getEnvironmentImpl(), "Database.cursor: name=" + this.getDatabaseName() + " txn=" + (txn == null ? "null" : Long.toString(txn.getId())) + " config=" + useConfig);
        Cursor ret = this.newDbcInstance(txn, useConfig);
        return ret;
    }

    Cursor newDbcInstance(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        return new Cursor(this, txn, cursorConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus delete(Transaction txn, DatabaseEntry key) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        this.checkRequiredDbState(OPEN, "Can't call Database.delete:");
        this.checkWritable("delete");
        this.trace(Level.FINEST, "Database.delete", txn, key, null, null);
        OperationStatus commitStatus = OperationStatus.NOTFOUND;
        Locker locker = null;
        try {
            locker = DatabaseUtil.getWritableLocker(this.envHandle, txn, this.isTransactional());
            OperationStatus operationStatus = commitStatus = this.deleteInternal(locker, key);
            return operationStatus;
        }
        finally {
            if (locker != null) {
                locker.operationEnd(commitStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus deleteInternal(Locker locker, DatabaseEntry key) throws DatabaseException {
        Cursor cursor = null;
        try {
            cursor = new Cursor(this, locker, null);
            OperationStatus commitStatus = OperationStatus.NOTFOUND;
            DatabaseEntry oldData = new DatabaseEntry();
            OperationStatus searchStatus = cursor.search(key, oldData, LockMode.RMW, CursorImpl.SearchMode.SET);
            if (searchStatus == OperationStatus.SUCCESS) {
                do {
                    if (this.hasTriggers()) {
                        this.notifyTriggers(locker, key, oldData, null);
                    }
                    if ((commitStatus = cursor.deleteNoNotify()) == OperationStatus.SUCCESS) continue;
                    OperationStatus operationStatus = commitStatus;
                    return operationStatus;
                } while ((searchStatus = cursor.retrieveNext(key, oldData, LockMode.RMW, GetMode.NEXT_DUP)) == OperationStatus.SUCCESS);
                commitStatus = OperationStatus.SUCCESS;
            }
            OperationStatus operationStatus = commitStatus;
            return operationStatus;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus get(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.checkRequiredDbState(OPEN, "Can't call Database.get:");
        this.trace(Level.FINEST, "Database.get", txn, key, null, lockMode);
        Cursor cursor = null;
        try {
            cursor = new Cursor(this, txn, null);
            OperationStatus operationStatus = cursor.search(key, data, lockMode, CursorImpl.SearchMode.SET);
            return operationStatus;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getSearchBoth(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        this.checkRequiredDbState(OPEN, "Can't call Database.getSearchBoth:");
        this.trace(Level.FINEST, "Database.getSearchBoth", txn, key, data, lockMode);
        Cursor cursor = null;
        try {
            cursor = new Cursor(this, txn, null);
            OperationStatus operationStatus = cursor.search(key, data, lockMode, CursorImpl.SearchMode.BOTH);
            return operationStatus;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public OperationStatus put(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkRequiredDbState(OPEN, "Can't call Database.put");
        this.checkWritable("put");
        this.trace(Level.FINEST, "Database.put", txn, key, data, null);
        return this.putInternal(txn, key, data, PutMode.OVERWRITE);
    }

    public OperationStatus putNoOverwrite(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkRequiredDbState(OPEN, "Can't call Database.putNoOverWrite");
        this.checkWritable("putNoOverwrite");
        this.trace(Level.FINEST, "Database.putNoOverwrite", txn, key, data, null);
        return this.putInternal(txn, key, data, PutMode.NOOVERWRITE);
    }

    public OperationStatus putNoDupData(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkRequiredDbState(OPEN, "Can't call Database.putNoDupData");
        this.checkWritable("putNoDupData");
        this.trace(Level.FINEST, "Database.putNoDupData", txn, key, data, null);
        return this.putInternal(txn, key, data, PutMode.NODUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus putInternal(Transaction txn, DatabaseEntry key, DatabaseEntry data, PutMode putMode) throws DatabaseException {
        OperationStatus operationStatus;
        OperationStatus commitStatus;
        Locker locker;
        block4: {
            locker = null;
            Cursor cursor = null;
            commitStatus = OperationStatus.KEYEXIST;
            try {
                locker = DatabaseUtil.getWritableLocker(this.envHandle, txn, this.isTransactional());
                cursor = new Cursor(this, locker, null);
                operationStatus = commitStatus = cursor.putInternal(key, data, putMode);
                Object var10_9 = null;
                if (cursor == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var10_10 = null;
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (locker == null) break block5;
                    locker.operationEnd(commitStatus);
                }
                throw throwable;
            }
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd(commitStatus);
        }
        return operationStatus;
    }

    public JoinCursor join(Cursor[] cursors, JoinConfig config) throws DatabaseException {
        this.checkEnv();
        this.checkRequiredDbState(OPEN, "Can't call Database.join");
        DatabaseUtil.checkForNullParam(cursors, "cursors");
        if (cursors.length == 0) {
            throw new IllegalArgumentException("At least one cursor is required.");
        }
        Locker locker = cursors[0].getCursorImpl().getLocker();
        if (!locker.isTransactional()) {
            EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
            for (int i = 1; i < cursors.length; ++i) {
                Locker locker2 = cursors[i].getCursorImpl().getLocker();
                if (locker2.isTransactional()) {
                    throw new IllegalArgumentException("All cursors must use the same transaction.");
                }
                EnvironmentImpl env2 = cursors[i].getDatabaseImpl().getDbEnvironment();
                if (env == env2) continue;
                throw new IllegalArgumentException("All cursors must use the same environment.");
            }
            locker = null;
        } else {
            for (int i = 1; i < cursors.length; ++i) {
                Locker locker2 = cursors[i].getCursorImpl().getLocker();
                if (locker == locker2) continue;
                throw new IllegalArgumentException("All cursors must use the same transaction.");
            }
        }
        return new JoinCursor(locker, this, cursors, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int truncate(Transaction txn, boolean countRecords) throws DatabaseException {
        int n;
        boolean triggerLock;
        block5: {
            this.checkEnv();
            this.checkRequiredDbState(OPEN, "Can't call Database.truncate");
            this.checkWritable("truncate");
            Tracer.trace(Level.FINEST, this.envHandle.getEnvironmentImpl(), "Database.truncate: txnId=" + (txn == null ? "null" : Long.toString(txn.getId())));
            Locker locker = null;
            triggerLock = false;
            boolean operationOk = false;
            try {
                locker = DatabaseUtil.getWritableLocker(this.envHandle, txn, this.isTransactional(), true);
                this.acquireTriggerListReadLock();
                triggerLock = true;
                int count = this.truncateInternal(locker, countRecords);
                for (int i = 0; i < this.triggerList.size(); ++i) {
                    Object obj = this.triggerList.get(i);
                    if (!(obj instanceof SecondaryTrigger)) continue;
                    SecondaryDatabase secDb = ((SecondaryTrigger)obj).getDb();
                    secDb.truncateInternal(locker, false);
                }
                operationOk = true;
                n = count;
                Object var11_10 = null;
                if (locker == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var11_11 = null;
                    if (locker != null) {
                        locker.operationEnd(operationOk);
                    }
                    if (!triggerLock) break block6;
                    this.releaseTriggerListReadLock();
                }
                throw throwable;
            }
            locker.operationEnd(operationOk);
        }
        if (triggerLock) {
            this.releaseTriggerListReadLock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int truncateInternal(Locker locker, boolean countRecords) throws DatabaseException {
        if (this.databaseImpl == null) {
            throw new DatabaseException("couldn't find database - truncate");
        }
        this.databaseImpl.checkIsDeleted("truncate");
        if (this.handleLocker.isHandleLockTransferrable()) {
            this.handleLocker.transferHandleLock(this, locker, false);
        }
        boolean operationOk = false;
        try {
            int[] nTruncated = countRecords ? new int[1] : null;
            TruncateResult result = this.envHandle.getEnvironmentImpl().truncate(locker, this.databaseImpl);
            this.databaseImpl = result.getDatabase();
            operationOk = true;
            int n = countRecords ? result.getRecordCount() : -1;
            return n;
        }
        finally {
            locker.setHandleLockOwner(operationOk, this, false);
        }
    }

    public DatabaseStats getStats(StatsConfig config) throws DatabaseException {
        StatsConfig useConfig;
        this.checkEnv();
        this.checkRequiredDbState(OPEN, "Can't call Database.stat");
        StatsConfig statsConfig = useConfig = config == null ? StatsConfig.DEFAULT : config;
        if (this.databaseImpl != null) {
            this.databaseImpl.checkIsDeleted("stat");
            return this.databaseImpl.stat(useConfig);
        }
        return null;
    }

    public void preload(long maxBytes) throws DatabaseException {
        this.checkEnv();
        this.checkRequiredDbState(OPEN, "Can't call Database.preload");
        this.databaseImpl.checkIsDeleted("preload");
        this.databaseImpl.preload(maxBytes);
    }

    public boolean verify(VerifyConfig config, PrintStream out) throws DatabaseException {
        this.checkEnv();
        this.checkRequiredDbState(OPEN, "Can't call Database.validate");
        this.databaseImpl.checkIsDeleted("validate");
        VerifyConfig useConfig = config == null ? VerifyConfig.DEFAULT : config;
        return this.databaseImpl.verify(useConfig, out);
    }

    public String getDatabaseName() throws DatabaseException {
        this.checkEnv();
        if (this.databaseImpl != null) {
            return this.databaseImpl.getName();
        }
        return null;
    }

    public DatabaseConfig getConfig() throws DatabaseException {
        DatabaseConfig showConfig = this.configuration.cloneConfig();
        Comparator btComp = this.databaseImpl.getBtreeComparator();
        Comparator dupComp = this.databaseImpl.getDuplicateComparator();
        showConfig.setBtreeComparator(btComp == null ? null : btComp.getClass());
        showConfig.setDuplicateComparator(dupComp == null ? null : dupComp.getClass());
        return showConfig;
    }

    boolean isTransactional() throws DatabaseException {
        return this.databaseImpl.isTransactional();
    }

    public Environment getEnvironment() throws DatabaseException {
        return this.envHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSecondaryDatabases() throws DatabaseException {
        ArrayList<SecondaryDatabase> list = new ArrayList<SecondaryDatabase>();
        if (this.hasTriggers()) {
            this.acquireTriggerListReadLock();
            try {
                for (int i = 0; i < this.triggerList.size(); ++i) {
                    Object obj = this.triggerList.get(i);
                    if (!(obj instanceof SecondaryTrigger)) continue;
                    list.add(((SecondaryTrigger)obj).getDb());
                }
            }
            finally {
                this.releaseTriggerListReadLock();
            }
        }
        return list;
    }

    boolean isWritable() {
        return this.isWritable;
    }

    DatabaseImpl getDatabaseImpl() {
        return this.databaseImpl;
    }

    void setHandleLocker(Locker locker) {
        this.handleLocker = locker;
    }

    synchronized void removeCursor(Cursor dbc) {
        this.cursors.remove(dbc);
    }

    synchronized void addCursor(Cursor dbc) {
        this.cursors.add(dbc);
    }

    void checkRequiredDbState(DbState required, String msg) throws DatabaseException {
        if (this.state != required) {
            throw new DatabaseException(msg + " Database state can't be " + this.state + " must be " + required);
        }
    }

    void checkProhibitedDbState(DbState prohibited, String msg) throws DatabaseException {
        if (this.state == prohibited) {
            throw new DatabaseException(msg + " Database state must not be " + prohibited);
        }
    }

    void checkEnv() throws RunRecoveryException {
        EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
        if (env != null) {
            env.checkIfInvalid();
        }
    }

    synchronized void invalidate() {
        this.state = INVALID;
        this.envHandle.removeReferringHandle(this);
        if (this.databaseImpl != null) {
            this.databaseImpl.removeReferringHandle(this);
        }
    }

    private void checkWritable(String operation) throws DatabaseException {
        if (!this.isWritable) {
            throw new DatabaseException("Database is Read Only: " + operation);
        }
    }

    void trace(Level level, String methodName, Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        Logger logger = this.envHandle.getEnvironmentImpl().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(methodName);
            if (txn != null) {
                sb.append(" txnId=").append(txn.getId());
            }
            sb.append(" key=").append(key.dumpData());
            if (data != null) {
                sb.append(" data=").append(data.dumpData());
            }
            if (lockMode != null) {
                sb.append(" lockMode=").append(lockMode);
            }
            logger.log(level, sb.toString());
        }
    }

    boolean hasTriggers() {
        return this.triggerList != null;
    }

    private void acquireTriggerListReadLock() throws DatabaseException {
        EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
        env.getTriggerLatch().acquireShared();
        if (this.triggerList == null) {
            this.triggerList = new ArrayList();
        }
    }

    private void releaseTriggerListReadLock() throws DatabaseException {
        EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
        env.getTriggerLatch().release();
    }

    private void acquireTriggerListWriteLock() throws DatabaseException {
        EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
        env.getTriggerLatch().acquireExclusive();
        if (this.triggerList == null) {
            this.triggerList = new ArrayList();
        }
    }

    private void releaseTriggerListWriteLock() throws DatabaseException {
        if (this.triggerList.size() == 0) {
            this.triggerList = null;
        }
        EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
        env.getTriggerLatch().release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTrigger(DatabaseTrigger trigger, boolean insertAtFront) throws DatabaseException {
        this.acquireTriggerListWriteLock();
        try {
            if (insertAtFront) {
                this.triggerList.add(0, trigger);
            } else {
                this.triggerList.add(trigger);
            }
            trigger.triggerAdded(this);
        }
        finally {
            this.releaseTriggerListWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTrigger(DatabaseTrigger trigger) throws DatabaseException {
        this.acquireTriggerListWriteLock();
        try {
            this.triggerList.remove(trigger);
            trigger.triggerRemoved(this);
        }
        finally {
            this.releaseTriggerListWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllTriggers() throws DatabaseException {
        this.acquireTriggerListWriteLock();
        try {
            for (int i = 0; i < this.triggerList.size(); ++i) {
                DatabaseTrigger trigger = (DatabaseTrigger)this.triggerList.get(i);
                trigger.triggerRemoved(this);
            }
            this.triggerList.clear();
        }
        finally {
            this.releaseTriggerListWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyTriggers(Locker locker, DatabaseEntry priKey, DatabaseEntry oldData, DatabaseEntry newData) throws DatabaseException {
        this.acquireTriggerListReadLock();
        try {
            TriggerTransaction txn = locker instanceof Txn ? new TriggerTransaction(this.envHandle, (Txn)locker) : null;
            for (int i = 0; i < this.triggerList.size(); ++i) {
                DatabaseTrigger trigger = (DatabaseTrigger)this.triggerList.get(i);
                trigger.databaseUpdated(this, txn, priKey, oldData, newData);
            }
        }
        finally {
            this.releaseTriggerListReadLock();
        }
    }

    static class DbState {
        private String stateName;

        DbState(String stateName) {
            this.stateName = stateName;
        }

        public String toString() {
            return "DbState." + this.stateName;
        }
    }
}

