/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseUtil;
import com.sleepycat.je.JoinConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.txn.Locker;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;

public class JoinCursor {
    private JoinConfig config;
    private Database priDb;
    private Cursor priCursor;
    private Cursor[] secCursors;
    private DatabaseEntry[] secData;
    private DatabaseEntry secKey;
    static final /* synthetic */ boolean $assertionsDisabled;

    JoinCursor(Locker locker, Database primaryDb, final Cursor[] cursors, JoinConfig configParam) throws DatabaseException {
        this.priDb = primaryDb;
        this.config = configParam != null ? configParam.cloneConfig() : JoinConfig.DEFAULT;
        this.secKey = new DatabaseEntry();
        this.secData = new DatabaseEntry[cursors.length];
        Cursor[] sortedCursors = new Cursor[cursors.length];
        System.arraycopy(cursors, 0, sortedCursors, 0, cursors.length);
        if (!this.config.getNoSort()) {
            final int[] counts = new int[cursors.length];
            for (int i = 0; i < cursors.length; ++i) {
                counts[i] = cursors[i].countInternal();
                if (!$assertionsDisabled && counts[i] < 0) {
                    throw new AssertionError();
                }
            }
            Arrays.sort(sortedCursors, new Comparator(){
                static final /* synthetic */ boolean $assertionsDisabled;

                public int compare(Object o1, Object o2) {
                    int count1 = -1;
                    int count2 = -1;
                    for (int i = 0; i < cursors.length && (count1 < 0 || count2 < 0); ++i) {
                        if (cursors[i] == o1) {
                            count1 = counts[i];
                            continue;
                        }
                        if (cursors[i] != o2) continue;
                        count2 = counts[i];
                    }
                    if (!($assertionsDisabled || count1 >= 0 && count2 >= 0)) {
                        throw new AssertionError();
                    }
                    return count1 - count2;
                }

                static {
                    $assertionsDisabled = !(class$com$sleepycat$je$JoinCursor == null ? (class$com$sleepycat$je$JoinCursor = JoinCursor.class$("com.sleepycat.je.JoinCursor")) : class$com$sleepycat$je$JoinCursor).desiredAssertionStatus();
                }
            });
        }
        try {
            this.priCursor = new Cursor(this.priDb, locker, null);
            this.secCursors = new Cursor[cursors.length];
            for (int i = 0; i < cursors.length; ++i) {
                this.secCursors[i] = new Cursor(sortedCursors[i], true);
            }
        }
        catch (DatabaseException e) {
            this.close(e);
        }
    }

    public void close() throws DatabaseException {
        if (this.priCursor == null) {
            throw new DatabaseException("Already closed");
        }
        this.close(null);
    }

    private void close(DatabaseException firstException) throws DatabaseException {
        if (this.priCursor != null) {
            block7: {
                try {
                    this.priCursor.close();
                }
                catch (DatabaseException e) {
                    if (firstException != null) break block7;
                    firstException = e;
                }
            }
            this.priCursor = null;
        }
        for (int i = 0; i < this.secCursors.length; ++i) {
            block8: {
                if (this.secCursors[i] == null) continue;
                try {
                    this.secCursors[i].close();
                }
                catch (DatabaseException e) {
                    if (firstException != null) break block8;
                    firstException = e;
                }
            }
            this.secCursors[i] = null;
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    Cursor[] getSortedCursors() {
        return this.secCursors;
    }

    public Database getDatabase() {
        return this.priDb;
    }

    public JoinConfig getConfig() {
        return this.config.cloneConfig();
    }

    public OperationStatus getNext(DatabaseEntry key, LockMode lockMode) throws DatabaseException {
        this.priCursor.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", false);
        this.priCursor.trace(Level.FINEST, "JoinCursor.getNext(key): ", lockMode);
        return this.retrieveNext(key, null, lockMode);
    }

    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.priCursor.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.priCursor.trace(Level.FINEST, "JoinCursor.getNext(key,data): ", lockMode);
        return this.retrieveNext(key, data, lockMode);
    }

    private OperationStatus retrieveNext(DatabaseEntry keyParam, DatabaseEntry dataParam, LockMode lockMode) throws DatabaseException {
        OperationStatus status;
        DatabaseEntry candidateKey;
        block0: while (true) {
            Cursor secCursor = this.secCursors[0];
            candidateKey = this.secData[0];
            if (candidateKey == null) {
                this.secData[0] = candidateKey = new DatabaseEntry();
                status = secCursor.getCurrentInternal(this.secKey, candidateKey, lockMode);
            } else {
                status = secCursor.retrieveNext(this.secKey, candidateKey, lockMode, GetMode.NEXT_DUP);
            }
            if (status != OperationStatus.SUCCESS) {
                return status;
            }
            for (int i = 1; i < this.secCursors.length; ++i) {
                secCursor = this.secCursors[i];
                Comparator userCmp = secCursor.getDatabaseImpl().getDuplicateComparator();
                DatabaseEntry testKey = this.secData[i];
                if (testKey == null) {
                    this.secData[i] = testKey = new DatabaseEntry();
                    status = secCursor.getCurrentInternal(this.secKey, testKey, lockMode);
                } else {
                    status = OperationStatus.SUCCESS;
                }
                while (status == OperationStatus.SUCCESS) {
                    int cmp;
                    int n = cmp = userCmp != null ? userCmp.compare(testKey.getData(), candidateKey.getData()) : Key.compareByteArray(testKey.getData(), candidateKey.getData());
                    if (cmp == 0) break;
                    if (cmp > 0) {
                        status = OperationStatus.NOTFOUND;
                        continue;
                    }
                    if (cmp >= 0) continue;
                    status = secCursor.retrieveNext(this.secKey, testKey, lockMode, GetMode.NEXT_DUP);
                }
                if (status != OperationStatus.SUCCESS) continue block0;
            }
            break;
        }
        if (dataParam != null && (status = this.priCursor.search(candidateKey, dataParam, lockMode, CursorImpl.SearchMode.SET)) != OperationStatus.SUCCESS) {
            throw new DatabaseException("Secondary corrupt");
        }
        keyParam.setData(candidateKey.getData(), candidateKey.getOffset(), candidateKey.getSize());
        return OperationStatus.SUCCESS;
    }

    static {
        $assertionsDisabled = !JoinCursor.class.desiredAssertionStatus();
    }
}

