/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseUtil;
import com.sleepycat.je.Environment;
import com.sleepycat.je.ForeignKeyDeleteAction;
import com.sleepycat.je.ForeignKeyNullifier;
import com.sleepycat.je.ForeignKeyTrigger;
import com.sleepycat.je.JoinConfig;
import com.sleepycat.je.JoinCursor;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.je.SecondaryKeyCreator;
import com.sleepycat.je.SecondaryTrigger;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.Tracer;
import java.util.logging.Level;

public class SecondaryDatabase
extends Database {
    private Database primaryDb;
    private SecondaryConfig secondaryConfig;
    private SecondaryTrigger secondaryTrigger;
    private ForeignKeyTrigger foreignKeyTrigger;

    SecondaryDatabase(Environment env, SecondaryConfig secConfig, Database primaryDatabase) throws DatabaseException {
        super(env);
        DatabaseUtil.checkForNullParam(primaryDatabase, "primaryDatabase");
        primaryDatabase.checkRequiredDbState(OPEN, "Can't use as primary:");
        if (primaryDatabase.configuration.getSortedDuplicates()) {
            throw new IllegalArgumentException("Duplicates must not be allowed for a primary database: " + primaryDatabase.getDatabaseName());
        }
        if (env.getEnvironmentImpl() != primaryDatabase.getEnvironment().getEnvironmentImpl()) {
            throw new IllegalArgumentException("Primary and secondary databases must be in the same environment.");
        }
        if (!primaryDatabase.configuration.getReadOnly() && secConfig.getKeyCreator() == null) {
            throw new NullPointerException("secConfig and secConfig.getKeyCreator() may be null only if the primary database is read-only");
        }
        if (secConfig.getForeignKeyDatabase() != null && secConfig.getForeignKeyDeleteAction() == ForeignKeyDeleteAction.NULLIFY && secConfig.getForeignKeyNullifier() == null) {
            throw new IllegalArgumentException("ForeignKeyNullifier must be non-null when  ForeignKeyDeleteAction is NULLIFY.");
        }
        this.primaryDb = primaryDatabase;
        this.secondaryTrigger = new SecondaryTrigger(this);
        if (secConfig.getForeignKeyDatabase() != null) {
            this.foreignKeyTrigger = new ForeignKeyTrigger(this);
        }
    }

    void initNew(Environment env, Locker locker, String databaseName, DatabaseConfig dbConfig) throws DatabaseException {
        super.initNew(env, locker, databaseName, dbConfig);
        this.init(locker);
    }

    void initExisting(Environment env, Locker locker, DatabaseImpl database, DatabaseConfig dbConfig) throws DatabaseException {
        super.initExisting(env, locker, database, dbConfig);
        this.init(locker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Locker locker) throws DatabaseException {
        Tracer.trace(Level.FINEST, this.envHandle.getEnvironmentImpl(), "SecondaryDatabase open: name=" + this.getDatabaseName() + " primary=" + this.primaryDb.getDatabaseName());
        this.secondaryConfig = (SecondaryConfig)this.configuration;
        this.primaryDb.addTrigger(this.secondaryTrigger, false);
        Database foreignDb = this.secondaryConfig.getForeignKeyDatabase();
        if (foreignDb != null) {
            foreignDb.addTrigger(this.foreignKeyTrigger, true);
        }
        if (this.secondaryConfig.getAllowPopulate()) {
            Cursor priCursor;
            block9: {
                Cursor secCursor = null;
                priCursor = null;
                try {
                    secCursor = new Cursor((Database)this, locker, null);
                    DatabaseEntry key = new DatabaseEntry();
                    DatabaseEntry data = new DatabaseEntry();
                    OperationStatus status = secCursor.position(key, data, LockMode.DEFAULT, true);
                    if (status == OperationStatus.NOTFOUND) {
                        priCursor = new Cursor(this.primaryDb, locker, null);
                        status = priCursor.position(key, data, LockMode.DEFAULT, true);
                        while (status == OperationStatus.SUCCESS) {
                            this.updateSecondary(locker, secCursor, key, null, data);
                            status = priCursor.retrieveNext(key, data, LockMode.DEFAULT, GetMode.NEXT);
                        }
                    }
                    Object var9_8 = null;
                    if (secCursor == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (secCursor != null) {
                        secCursor.close();
                    }
                    if (priCursor != null) {
                        priCursor.close();
                    }
                    throw throwable;
                }
                secCursor.close();
            }
            if (priCursor != null) {
                priCursor.close();
            }
        }
    }

    public synchronized void close() throws DatabaseException {
        Database foreignDb;
        if (this.primaryDb != null && this.secondaryTrigger != null) {
            this.primaryDb.removeTrigger(this.secondaryTrigger);
        }
        if ((foreignDb = this.secondaryConfig.getForeignKeyDatabase()) != null && this.foreignKeyTrigger != null) {
            foreignDb.removeTrigger(this.foreignKeyTrigger);
        }
        super.close();
    }

    void clearPrimary() {
        this.primaryDb = null;
        this.secondaryTrigger = null;
    }

    void clearForeignKeyTrigger() {
        this.foreignKeyTrigger = null;
    }

    public Database getPrimaryDatabase() throws DatabaseException {
        return this.primaryDb;
    }

    public SecondaryConfig getSecondaryConfig() throws DatabaseException {
        return (SecondaryConfig)this.getConfig();
    }

    public SecondaryCursor openSecondaryCursor(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        return (SecondaryCursor)this.openCursor(txn, cursorConfig);
    }

    Cursor newDbcInstance(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        return new SecondaryCursor(this, txn, cursorConfig, this.secondaryConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus delete(Transaction txn, DatabaseEntry key) throws DatabaseException {
        OperationStatus operationStatus;
        OperationStatus commitStatus;
        Locker locker;
        block5: {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            this.checkRequiredDbState(OPEN, "Can't call SecondaryDatabase.delete:");
            this.trace(Level.FINEST, "SecondaryDatabase.delete", txn, key, null, null);
            locker = null;
            Cursor cursor = null;
            commitStatus = OperationStatus.NOTFOUND;
            try {
                locker = DatabaseUtil.getWritableLocker(this.envHandle, txn, this.isTransactional());
                cursor = new Cursor((Database)this, locker, null);
                DatabaseEntry pKey = new DatabaseEntry();
                OperationStatus searchStatus = cursor.search(key, pKey, LockMode.RMW, CursorImpl.SearchMode.SET);
                if (searchStatus == OperationStatus.SUCCESS) {
                    commitStatus = this.primaryDb.deleteInternal(locker, pKey);
                }
                operationStatus = commitStatus;
                Object var10_9 = null;
                if (cursor == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var10_10 = null;
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (locker == null) break block6;
                    locker.operationEnd(commitStatus);
                }
                throw throwable;
            }
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd(commitStatus);
        }
        return operationStatus;
    }

    public OperationStatus get(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.get(txn, key, new DatabaseEntry(), data, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus get(Transaction txn, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.checkRequiredDbState(OPEN, "Can't call SecondaryDatabase.get:");
        this.trace(Level.FINEST, "SecondaryDatabase.get", txn, key, null, lockMode);
        Cursor cursor = null;
        try {
            cursor = new SecondaryCursor(this, txn, CursorConfig.DEFAULT, this.secondaryConfig);
            OperationStatus operationStatus = ((SecondaryCursor)cursor).search(key, pKey, data, lockMode, CursorImpl.SearchMode.SET);
            return operationStatus;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public OperationStatus getSearchBoth(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getSearchBoth(Transaction txn, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        this.checkRequiredDbState(OPEN, "Can't call SecondaryDatabase.getSearchBoth:");
        this.trace(Level.FINEST, "SecondaryDatabase.getSearchBoth", txn, key, data, lockMode);
        Cursor cursor = null;
        try {
            cursor = new SecondaryCursor(this, txn, CursorConfig.DEFAULT, this.secondaryConfig);
            OperationStatus operationStatus = ((SecondaryCursor)cursor).search(key, pKey, data, lockMode, CursorImpl.SearchMode.BOTH);
            return operationStatus;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public OperationStatus put(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus putNoOverwrite(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus putNoDupData(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    public JoinCursor join(Cursor[] cursors, JoinConfig config) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    public int truncate(Transaction txn, boolean countRecords) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void updateSecondary(Locker locker, Cursor cursor, DatabaseEntry priKey, DatabaseEntry oldData, DatabaseEntry newData) throws DatabaseException {
        boolean localCursor;
        SecondaryKeyCreator keyCreator = this.secondaryConfig.getKeyCreator();
        DatabaseEntry oldSecKey = null;
        if (oldData != null && !keyCreator.createSecondaryKey(this, priKey, oldData, oldSecKey = new DatabaseEntry())) {
            oldSecKey = null;
        }
        DatabaseEntry newSecKey = null;
        if (newData != null && !keyCreator.createSecondaryKey(this, priKey, newData, newSecKey = new DatabaseEntry())) {
            newSecKey = null;
        }
        if ((oldSecKey == null || oldSecKey.dataEquals(newSecKey)) && (newSecKey == null || newSecKey.dataEquals(oldSecKey))) return;
        boolean bl = localCursor = cursor == null;
        if (localCursor) {
            cursor = new Cursor((Database)this, locker, null);
        }
        try {
            if (newSecKey != null) {
                OperationStatus status;
                Database foreignDb = this.secondaryConfig.getForeignKeyDatabase();
                if (foreignDb != null) {
                    Cursor foreignCursor = null;
                    try {
                        foreignCursor = new Cursor(foreignDb, locker, null);
                        DatabaseEntry tmpData = new DatabaseEntry();
                        OperationStatus status2 = foreignCursor.search(newSecKey, tmpData, LockMode.DEFAULT, CursorImpl.SearchMode.SET);
                        if (status2 != OperationStatus.SUCCESS) {
                            throw new DatabaseException("Secondary " + this.getDatabaseName() + " foreign key not allowed: it is not" + " present in the foreign database");
                        }
                    }
                    finally {
                        if (foreignCursor != null) {
                            foreignCursor.close();
                        }
                    }
                }
                if ((status = this.getConfig().getSortedDuplicates() ? cursor.putInternal(newSecKey, priKey, PutMode.NODUP) : cursor.putInternal(newSecKey, priKey, PutMode.NOOVERWRITE)) != OperationStatus.SUCCESS) {
                    throw new DatabaseException("Could not insert secondary key in " + this.getDatabaseName() + ' ' + status);
                }
            }
            if (oldSecKey != null) {
                OperationStatus status = cursor.search(oldSecKey, priKey, LockMode.RMW, CursorImpl.SearchMode.BOTH);
                if (status != OperationStatus.SUCCESS) throw new DatabaseException("Secondary " + this.getDatabaseName() + " is corrupt: the primary record contains a key" + " that is not present in the secondary");
                cursor.deleteInternal();
            }
            Object var16_15 = null;
            if (!localCursor || cursor == null) return;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            if (!localCursor || cursor == null) throw throwable;
            cursor.close();
            throw throwable;
        }
        cursor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void onForeignKeyDelete(Locker locker, DatabaseEntry secKey) throws DatabaseException {
        ForeignKeyDeleteAction deleteAction = this.secondaryConfig.getForeignKeyDeleteAction();
        LockMode lockMode = deleteAction == ForeignKeyDeleteAction.ABORT ? LockMode.DEFAULT : LockMode.RMW;
        DatabaseEntry priKey = new DatabaseEntry();
        Cursor cursor = null;
        try {
            cursor = new Cursor((Database)this, locker, null);
            OperationStatus status = cursor.search(secKey, priKey, lockMode, CursorImpl.SearchMode.SET);
            while (status == OperationStatus.SUCCESS) {
                DatabaseEntry data;
                Cursor priCursor;
                if (deleteAction == ForeignKeyDeleteAction.ABORT) {
                    throw new DatabaseException("Secondary " + this.getDatabaseName() + " refers to a foreign key that has been deleted" + " (ForeignKeyDeleteAction.ABORT)");
                }
                if (deleteAction == ForeignKeyDeleteAction.CASCADE) {
                    priCursor = null;
                    try {
                        data = new DatabaseEntry();
                        priCursor = new Cursor(this.primaryDb, locker, null);
                        status = priCursor.search(priKey, data, LockMode.RMW, CursorImpl.SearchMode.SET);
                        if (status != OperationStatus.SUCCESS) throw this.secondaryCorruptException();
                        priCursor.delete();
                    }
                    finally {
                        if (priCursor != null) {
                            priCursor.close();
                        }
                    }
                }
                if (deleteAction != ForeignKeyDeleteAction.NULLIFY) throw new IllegalStateException();
                priCursor = null;
                try {
                    data = new DatabaseEntry();
                    priCursor = new Cursor(this.primaryDb, locker, null);
                    status = priCursor.search(priKey, data, LockMode.RMW, CursorImpl.SearchMode.SET);
                    if (status != OperationStatus.SUCCESS) throw this.secondaryCorruptException();
                    ForeignKeyNullifier nullifier = this.secondaryConfig.getForeignKeyNullifier();
                    if (nullifier.nullifyForeignKey(this, data)) {
                        priCursor.putCurrent(data);
                    }
                }
                finally {
                    if (priCursor != null) {
                        priCursor.close();
                    }
                }
                status = cursor.retrieveNext(secKey, priKey, LockMode.DEFAULT, GetMode.NEXT_DUP);
            }
            return;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    DatabaseException secondaryCorruptException() throws DatabaseException {
        throw new DatabaseException("Secondary " + this.getDatabaseName() + " is corrupt: it refers" + " to a missing key in the primary database");
    }

    static UnsupportedOperationException notAllowedException() {
        throw new UnsupportedOperationException("Operation not allowed on a secondary");
    }
}

