/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.FileRetryInfo;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.DbLsn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class UtilizationSelector
implements FileSelector {
    private UtilizationProfile profile;
    private FileRetryInfo retryFile;
    private int maxRetries;
    private int maxRestartRetries;
    private int retryCycles;
    private boolean waitAfterRetry;
    static final /* synthetic */ boolean $assertionsDisabled;

    UtilizationSelector(EnvironmentImpl env, UtilizationProfile profile) throws DatabaseException {
        this.profile = profile;
        this.maxRetries = env.getConfigManager().getInt(EnvironmentParams.CLEANER_RETRIES);
        this.maxRestartRetries = env.getConfigManager().getInt(EnvironmentParams.CLEANER_RESTART_RETRIES);
    }

    public FileRetryInfo getFileToClean(Set excludeFiles, boolean aggressive) throws DatabaseException {
        Long file;
        if (this.retryFile != null && !this.waitAfterRetry && !excludeFiles.contains(this.retryFile.getFileNumber())) {
            return this.retryFile;
        }
        HashSet<Long> useExcludeFiles = excludeFiles;
        if (this.retryFile != null) {
            useExcludeFiles = new HashSet<Long>(excludeFiles);
            useExcludeFiles.add(this.retryFile.getFileNumber());
        }
        if ((file = this.profile.getBestFileForCleaning(useExcludeFiles, aggressive)) != null) {
            return new RetryInfo(file);
        }
        return null;
    }

    private void onEndFile(RetryInfo file, boolean deleted) {
        if (deleted) {
            if (file == this.retryFile) {
                if (!$assertionsDisabled && this.waitAfterRetry) {
                    throw new AssertionError();
                }
                this.resetRetryInfo();
            } else if (this.waitAfterRetry) {
                if (!$assertionsDisabled && this.retryFile == null) {
                    throw new AssertionError();
                }
                ++this.retryCycles;
                if (this.retryCycles >= this.maxRestartRetries) {
                    this.waitAfterRetry = false;
                    this.retryCycles = 0;
                }
            } else if (!$assertionsDisabled && this.retryFile != null) {
                throw new AssertionError();
            }
        } else if (this.retryFile == file) {
            ++this.retryCycles;
            if (this.retryCycles >= this.maxRetries) {
                this.waitAfterRetry = true;
                this.retryCycles = 0;
            }
        } else {
            this.resetRetryInfo();
            this.retryFile = file;
        }
    }

    private void resetRetryInfo() {
        this.retryFile = null;
        this.retryCycles = 0;
        this.waitAfterRetry = false;
    }

    static {
        $assertionsDisabled = !UtilizationSelector.class.desiredAssertionStatus();
    }

    private class RetryInfo
    implements FileRetryInfo {
        private Long fileNum;
        private DbLsn firstUnprocessedLsn;
        private List pendingLsns;
        private boolean fullyProcessed;
        static final /* synthetic */ boolean $assertionsDisabled;

        RetryInfo(Long fileNum) {
            this.fileNum = fileNum;
            this.pendingLsns = new ArrayList();
        }

        public Long getFileNumber() {
            return this.fileNum;
        }

        public void beginFileProcessing() {
        }

        public void endProcessing(boolean deleted) {
            UtilizationSelector.this.onEndFile(this, deleted);
        }

        public boolean canFileBeDeleted() {
            return this.fullyProcessed && this.pendingLsns.isEmpty();
        }

        public void setFileFullyProcessed() {
            this.fullyProcessed = true;
        }

        public boolean isFileFullyProcessed() {
            return this.fullyProcessed;
        }

        public void setFirstUnprocessedLsn(DbLsn lsn) {
            if (!$assertionsDisabled && lsn.getFileNumber() != this.fileNum.longValue()) {
                throw new AssertionError();
            }
            this.firstUnprocessedLsn = lsn;
        }

        public DbLsn getFirstUnprocessedLsn() {
            return this.firstUnprocessedLsn;
        }

        public DbLsn[] getPendingLsns() {
            if (this.pendingLsns.size() > 0) {
                DbLsn[] lsns = new DbLsn[this.pendingLsns.size()];
                this.pendingLsns.toArray(lsns);
                return lsns;
            }
            return null;
        }

        public boolean isObsoleteLN(DbLsn lsn, long nodeId) {
            if (!$assertionsDisabled && lsn.getFileNumber() != this.fileNum.longValue()) {
                throw new AssertionError();
            }
            return false;
        }

        public void setObsoleteLN(DbLsn lsn, long nodeId) {
            if (!$assertionsDisabled && lsn.getFileNumber() != this.fileNum.longValue()) {
                throw new AssertionError();
            }
            this.pendingLsns.remove(lsn);
        }

        public void setPendingLN(DbLsn lsn, long nodeId) {
            if (!$assertionsDisabled && lsn.getFileNumber() != this.fileNum.longValue()) {
                throw new AssertionError();
            }
            this.pendingLsns.add(lsn);
        }

        static {
            $assertionsDisabled = !(class$com$sleepycat$je$cleaner$UtilizationSelector == null ? (class$com$sleepycat$je$cleaner$UtilizationSelector = UtilizationSelector.class$("com.sleepycat.je.cleaner.UtilizationSelector")) : class$com$sleepycat$je$cleaner$UtilizationSelector).desiredAssertionStatus();
        }
    }
}

