/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.config;

import com.sleepycat.je.config.EnvironmentParams;

public class ConfigParam {
    public static final String CONFIG_DELIM = ";";
    String name;
    private String defaultValue;
    private String description;
    private boolean mutable;

    ConfigParam(String configName, String configDefault, boolean mutable, String description) throws IllegalArgumentException {
        this.name = configName;
        this.defaultValue = configDefault;
        this.mutable = mutable;
        this.description = description;
        this.validateName(configName);
        this.validateValue(configDefault);
        EnvironmentParams.addSupportedParam(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExtraDescription() {
        return null;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void validate() throws IllegalArgumentException {
        this.validateName(this.name);
        this.validateValue(this.defaultValue);
    }

    private void validateName(String name) throws IllegalArgumentException {
        if (name == null || name.length() < 1) {
            throw new IllegalArgumentException(" A configuration parameter name can't be null or 0 length");
        }
    }

    public void validateValue(String value) throws IllegalArgumentException {
    }
}

