/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.utilint.DbLsn;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class LNFileReader
extends FileReader {
    protected Map targetEntryMap = new HashMap();
    protected LogEntry targetLogEntry;

    public LNFileReader(EnvironmentImpl env, int readBufferSize, DbLsn startLsn, boolean redo, DbLsn endOfFileLsn, DbLsn finishLsn, Long singleFileNum) throws IOException, DatabaseException {
        super(env, readBufferSize, redo, startLsn, singleFileNum, endOfFileLsn, finishLsn);
    }

    public void addTargetType(LogEntryType entryType) throws DatabaseException {
        this.targetEntryMap.put(entryType, entryType.getNewLogEntry());
    }

    protected boolean isTargetEntry(byte entryTypeNum, byte entryTypeVersion) {
        if (LogEntryType.isProvisional(entryTypeVersion)) {
            this.targetLogEntry = null;
        } else {
            LogEntryType fromLogType = new LogEntryType(entryTypeNum, entryTypeVersion);
            this.targetLogEntry = (LogEntry)this.targetEntryMap.get(fromLogType);
        }
        return this.targetLogEntry != null;
    }

    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        this.targetLogEntry.readEntry(entryBuffer);
        return true;
    }

    public boolean isLN() {
        return this.targetLogEntry instanceof LNLogEntry;
    }

    public LN getLN() {
        return ((LNLogEntry)this.targetLogEntry).getLN();
    }

    public DatabaseId getDatabaseId() {
        return ((LNLogEntry)this.targetLogEntry).getDbId();
    }

    public Key getKey() {
        return ((LNLogEntry)this.targetLogEntry).getKey();
    }

    public Key getDupTreeKey() {
        return ((LNLogEntry)this.targetLogEntry).getDupKey();
    }

    public Long getTxnId() {
        return ((LNLogEntry)this.targetLogEntry).getTxnId();
    }

    public long getTxnCommitId() {
        return ((TxnCommit)this.targetLogEntry.getMainItem()).getId();
    }

    public long getNodeId() {
        return ((LNLogEntry)this.targetLogEntry).getLN().getNodeId();
    }

    public DbLsn getAbortLsn() {
        return ((LNLogEntry)this.targetLogEntry).getAbortLsn();
    }

    public boolean getAbortKnownDeleted() {
        return ((LNLogEntry)this.targetLogEntry).getAbortKnownDeleted();
    }
}

