/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.utilint.Tracer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;

public class DbLoad {
    private static final boolean DEBUG = false;
    protected Environment env;
    private boolean formatUsingPrintable;
    private String dbName;
    private BufferedReader reader;
    private boolean noOverwrite;
    private boolean textFileMode;
    private boolean dupSort;
    private boolean ignoreUnknownConfig;
    private boolean commandLine;
    private static String usageString = "usage: DbLoad [-f input-file] [-n] [-V] [-T] [-I]\n              [-c name=value]\n              [-s database] -h dbEnvHome\n";
    private static byte backSlashValue = (byte)(new Character('\\').charValue() & 0xFF);

    public static void main(String[] argv) throws DatabaseException, IOException {
        DbLoad loader = DbLoad.parseArgs(argv);
        try {
            loader.load();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        loader.env.close();
    }

    private static void printUsage(String msg) {
        System.err.println(msg);
        System.err.println(usageString);
        System.exit(-1);
    }

    private static DbLoad parseArgs(String[] argv) throws IOException, DatabaseException {
        boolean noOverwrite = false;
        boolean textFileMode = false;
        boolean ignoreUnknownConfig = false;
        int argc = 0;
        int nArgs = argv.length;
        String inputFileName = null;
        File envHome = null;
        String dbName = null;
        DbLoad ret = new DbLoad();
        ret.setCommandLine(true);
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++].trim()).equals("-n")) {
                noOverwrite = true;
                continue;
            }
            if (thisArg.equals("-T")) {
                textFileMode = true;
                continue;
            }
            if (thisArg.equals("-I")) {
                ignoreUnknownConfig = true;
                continue;
            }
            if (thisArg.equals("-V")) {
                System.out.println(JEVersion.CURRENT_VERSION);
                System.exit(0);
                continue;
            }
            if (thisArg.equals("-f")) {
                if (argc < nArgs) {
                    inputFileName = argv[argc++];
                    continue;
                }
                DbLoad.printUsage("-f requires an argument");
                continue;
            }
            if (thisArg.equals("-h")) {
                if (argc < nArgs) {
                    envHome = new File(argv[argc++]);
                    continue;
                }
                DbLoad.printUsage("-h requires an argument");
                continue;
            }
            if (thisArg.equals("-s")) {
                if (argc < nArgs) {
                    dbName = argv[argc++];
                    continue;
                }
                DbLoad.printUsage("-s requires an argument");
                continue;
            }
            if (!thisArg.equals("-c")) continue;
            if (argc < nArgs) {
                try {
                    ret.loadConfigLine(argv[argc++]);
                }
                catch (IllegalArgumentException e) {
                    DbLoad.printUsage("-c: " + e.getMessage());
                }
                continue;
            }
            DbLoad.printUsage("-c requires an argument");
        }
        if (envHome == null) {
            DbLoad.printUsage("-h is a required argument");
        }
        InputStream is = inputFileName == null ? System.in : new FileInputStream(inputFileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setTransactional(true);
        envConfig.setAllowCreate(true);
        Environment env = new Environment(envHome, envConfig);
        ret.setEnv(env);
        ret.setDbName(dbName);
        ret.setInputReader(reader);
        ret.setNoOverwrite(noOverwrite);
        ret.setTextFileMode(textFileMode);
        ret.setIgnoreUnknownConfig(ignoreUnknownConfig);
        return ret;
    }

    private void setCommandLine(boolean commandLine) {
        this.commandLine = commandLine;
    }

    public void setEnv(Environment env) {
        this.env = env;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setInputReader(BufferedReader reader) {
        this.reader = reader;
    }

    public void setNoOverwrite(boolean noOverwrite) {
        this.noOverwrite = noOverwrite;
    }

    public void setTextFileMode(boolean textFileMode) {
        this.textFileMode = textFileMode;
    }

    public void setIgnoreUnknownConfig(boolean ignoreUnknownConfigMode) {
        this.ignoreUnknownConfig = ignoreUnknownConfigMode;
    }

    public boolean load() throws IOException, DatabaseException {
        Tracer.trace(Level.INFO, DbInternal.envGetEnvironmentImpl(this.env), "DbLoad.load of " + this.dbName + " starting");
        if (this.textFileMode) {
            this.formatUsingPrintable = true;
        } else {
            this.loadHeader();
        }
        if (this.dbName == null) {
            throw new IllegalArgumentException("Must supply a database name if -l not supplied.");
        }
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setSortedDuplicates(this.dupSort);
        dbConfig.setAllowCreate(true);
        Database db = this.env.openDatabase(null, this.dbName, dbConfig);
        this.loadData(db);
        db.close();
        Tracer.trace(Level.INFO, DbInternal.envGetEnvironmentImpl(this.env), "DbLoad.load of " + this.dbName + " ending.");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadConfigLine(String line) throws DatabaseException {
        int equalsIdx = line.indexOf(61);
        if (equalsIdx < 0) {
            throw new IllegalArgumentException("Invalid header parameter: " + line);
        }
        String keyword = line.substring(0, equalsIdx).trim().toLowerCase();
        String value = line.substring(equalsIdx + 1).trim();
        if (keyword.equals("version")) {
            if (value.equals("3")) return;
            throw new IllegalArgumentException("Version " + value + " is not supported.");
        }
        if (keyword.equals("format")) {
            if ((value = value.toLowerCase()).equals("print")) {
                this.formatUsingPrintable = true;
                return;
            } else {
                if (!value.equals("bytevalue")) throw new IllegalArgumentException(value + " is an unknown value for the format keyword");
                this.formatUsingPrintable = false;
            }
            return;
        } else if (keyword.equals("dupsort")) {
            if ((value = value.toLowerCase()).equals("true")) {
                this.dupSort = true;
                return;
            } else {
                if (!value.equals("false")) throw new IllegalArgumentException(value + " is an unknown value for the dupsort keyword");
                this.dupSort = false;
            }
            return;
        } else {
            if (keyword.equals("type")) {
                if ((value = value.toLowerCase()).equals("btree")) return;
                throw new IllegalArgumentException(value + " is not a supported database type.");
            }
            if (keyword.equals("database")) {
                if (this.dbName != null) return;
                this.dbName = value;
                return;
            } else {
                if (this.ignoreUnknownConfig) return;
                throw new IllegalArgumentException("'" + line + "' is not understood.");
            }
        }
    }

    private void loadHeader() throws IOException, DatabaseException {
        String line = this.reader.readLine();
        while (!line.equals("HEADER=END")) {
            this.loadConfigLine(line);
            line = this.reader.readLine();
        }
    }

    private void loadData(Database db) throws DatabaseException, IOException {
        String keyLine = this.reader.readLine();
        String dataLine = null;
        while (keyLine != null && !keyLine.equals("DATA=END")) {
            dataLine = this.reader.readLine();
            if (dataLine == null) {
                throw new DatabaseException("No data to match key " + keyLine);
            }
            byte[] keyBytes = this.loadLine(keyLine.trim());
            byte[] dataBytes = this.loadLine(dataLine.trim());
            DatabaseEntry key = new DatabaseEntry(keyBytes);
            DatabaseEntry data = new DatabaseEntry(dataBytes);
            if (this.noOverwrite) {
                if (db.putNoOverwrite(null, key, data) == OperationStatus.KEYEXIST && this.commandLine) {
                    System.err.println("Key exists: " + key);
                }
            } else {
                db.put(null, key, data);
            }
            keyLine = this.reader.readLine();
        }
    }

    private byte[] loadLine(String line) throws DatabaseException {
        if (this.formatUsingPrintable) {
            return this.readPrintableLine(line);
        }
        int nBytes = line.length() / 2;
        byte[] ret = new byte[nBytes];
        int charIdx = 0;
        int i = 0;
        while (i < nBytes) {
            int b2 = Character.digit(line.charAt(charIdx), 16);
            b2 <<= 4;
            ret[i] = (byte)(b2 += Character.digit(line.charAt(charIdx + 1), 16));
            ++i;
            charIdx += 2;
        }
        return ret;
    }

    private byte[] readPrintableLine(String line) throws DatabaseException {
        int maxNBytes = line.length();
        byte[] ba = new byte[maxNBytes];
        int actualNBytes = 0;
        for (int charIdx = 0; charIdx < maxNBytes; ++charIdx) {
            char c = line.charAt(charIdx);
            if (c == '\\') {
                if (++charIdx < maxNBytes) {
                    char c1 = line.charAt(charIdx);
                    if (c1 == '\\') {
                        ba[actualNBytes++] = backSlashValue;
                        continue;
                    }
                    if (++charIdx < maxNBytes) {
                        char c2 = line.charAt(charIdx);
                        int b = Character.digit(c1, 16);
                        b <<= 4;
                        ba[actualNBytes++] = (byte)(b += Character.digit(c2, 16));
                        continue;
                    }
                    throw new DatabaseException("Corrupted file");
                }
                throw new DatabaseException("Corrupted file");
            }
            ba[actualNBytes++] = (byte)(c & 0xFF);
        }
        if (maxNBytes == actualNBytes) {
            return ba;
        }
        byte[] ret = new byte[actualNBytes];
        System.arraycopy(ba, 0, ret, 0, actualNBytes);
        return ret;
    }
}

