/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import java.io.File;

public class CmdUtil {
    public static String getArg(String[] argv, int whichArg) throws IllegalArgumentException {
        if (whichArg < argv.length) {
            return argv[whichArg];
        }
        throw new IllegalArgumentException();
    }

    public static long readLongNumber(String longVal) {
        if (longVal.startsWith("0x")) {
            return Long.parseLong(longVal.substring(2), 16);
        }
        return Long.parseLong(longVal);
    }

    public static EnvironmentImpl makeUtilityEnvironment(File envHome, boolean readOnly) throws DatabaseException {
        EnvironmentConfig config = new EnvironmentConfig();
        config.setReadOnly(readOnly);
        config.setConfigParam(EnvironmentParams.JE_LOGGING_DBLOG.getName(), "false");
        config.setConfigParam(EnvironmentParams.JE_LOGGING_CONSOLE.getName(), "true");
        config.setConfigParam(EnvironmentParams.JE_LOGGING_LEVEL.getName(), "SEVERE");
        config.setConfigParam(EnvironmentParams.ENV_RECOVERY.getName(), "false");
        return new EnvironmentImpl(envHome, config);
    }
}

