/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.utilint.DbLsn;
import java.util.ArrayList;
import java.util.List;

public class UtilizationTracker {
    private static LogEntryType[] IN_TYPES;
    private EnvironmentImpl env;
    private List files;
    private long activeFile;
    private TrackedFileSummary[] snapshot;
    private long logSizeDelta;
    private long bytesSinceActivate;
    private long cleanerBytesInterval;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UtilizationTracker(EnvironmentImpl env) throws DatabaseException {
        this.env = env;
        this.files = new ArrayList();
        this.snapshot = new TrackedFileSummary[0];
        this.activeFile = -1L;
        this.cleanerBytesInterval = env.getConfigManager().getLong(EnvironmentParams.CLEANER_BYTES_INTERVAL);
        if (this.cleanerBytesInterval == 0L) {
            this.cleanerBytesInterval = env.getConfigManager().getLong(EnvironmentParams.LOG_FILE_MAX) / 4L;
        }
    }

    public void activateCleaner() {
        if (this.env.getCleaner() != null) {
            this.env.getCleaner().wakeup();
            this.bytesSinceActivate = 0L;
        }
    }

    public TrackedFileSummary[] getTrackedFiles() {
        return this.snapshot;
    }

    public TrackedFileSummary getTrackedFile(long fileNum) {
        TrackedFileSummary[] a = this.snapshot;
        for (int i = 0; i < a.length; ++i) {
            if (a[i].getFileNumber() != fileNum) continue;
            return a[i];
        }
        return null;
    }

    long getLogSizeDelta() {
        return this.logSizeDelta;
    }

    public boolean countNewLogEntry(DbLsn lsn, LogEntryType type, int size) {
        TrackedFileSummary file = this.getFile(lsn.getFileNumber());
        ++file.totalCount;
        file.totalSize += size;
        if (type.isNodeType()) {
            if (this.inArray(type, IN_TYPES)) {
                ++file.totalINCount;
                file.totalINSize += size;
            } else {
                ++file.totalLNCount;
                file.totalLNSize += size;
            }
        }
        this.logSizeDelta += (long)size;
        this.bytesSinceActivate += (long)size;
        return this.bytesSinceActivate >= this.cleanerBytesInterval;
    }

    public void countObsoleteNode(DbLsn lsn, LogEntryType type, boolean obsolete) {
        if (!$assertionsDisabled && type != null && this.inArray(type, IN_TYPES)) {
            throw new AssertionError();
        }
        TrackedFileSummary file = this.getFile(lsn.getFileNumber());
        file.obsoleteLNCount = file.obsoleteLNCount + (obsolete ? 1 : -1);
    }

    public void addSummary(long fileNumber, FileSummary other) {
        TrackedFileSummary file = this.getFile(fileNumber);
        file.add(other);
    }

    private TrackedFileSummary getFile(long fileNum) {
        if (this.activeFile < fileNum) {
            this.activeFile = fileNum;
        }
        int size = this.files.size();
        for (int i = 0; i < size; ++i) {
            TrackedFileSummary file = (TrackedFileSummary)this.files.get(i);
            if (file.getFileNumber() != fileNum) continue;
            return file;
        }
        TrackedFileSummary file = new TrackedFileSummary(this, fileNum);
        this.files.add(file);
        this.takeSnapshot();
        return file;
    }

    void resetFile(TrackedFileSummary file) {
        if (file.getFileNumber() < this.activeFile) {
            this.files.remove(file);
            this.takeSnapshot();
        }
        this.logSizeDelta -= (long)file.totalSize;
    }

    private void takeSnapshot() {
        TrackedFileSummary[] a = new TrackedFileSummary[this.files.size()];
        this.files.toArray(a);
        this.snapshot = a;
    }

    private boolean inArray(Object o, Object[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != o) continue;
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = !UtilizationTracker.class.desiredAssertionStatus();
        IN_TYPES = new LogEntryType[]{LogEntryType.LOG_IN, LogEntryType.LOG_BIN, LogEntryType.LOG_DIN, LogEntryType.LOG_DBIN};
    }
}

