/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ChecksumValidator;
import com.sleepycat.je.log.DbChecksumException;
import com.sleepycat.je.log.FileHandle;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public abstract class FileReader {
    protected EnvironmentImpl env;
    protected FileManager fileManager;
    protected int readBufferSize;
    private ByteBuffer readBuffer;
    private ByteBuffer saveBuffer;
    private boolean singleFile;
    protected boolean eof;
    private boolean forward;
    protected long readBufferFileNum;
    protected long readBufferFileStart;
    protected long readBufferFileEnd;
    private int numRead;
    protected byte currentEntryTypeNum;
    protected byte currentEntryTypeVersion;
    protected long currentEntryPrevOffset;
    protected int currentEntrySize;
    protected long currentEntryChecksum;
    protected long currentEntryOffset;
    protected long nextEntryOffset;
    protected DbLsn startLsn;
    private DbLsn finishLsn;
    protected ChecksumValidator cksumValidator;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileReader(EnvironmentImpl env, int readBufferSize, boolean forward, DbLsn startLsn, Long singleFileNumber, DbLsn endOfFileLsn, DbLsn finishLsn) throws IOException, DatabaseException {
        this.env = env;
        this.fileManager = env.getFileManager();
        this.readBufferSize = readBufferSize;
        this.singleFile = singleFileNumber != null;
        this.forward = forward;
        this.readBuffer = ByteBuffer.allocate(readBufferSize);
        this.threadSafeBufferFlip(this.readBuffer);
        this.saveBuffer = ByteBuffer.allocate(readBufferSize);
        this.startLsn = startLsn;
        this.finishLsn = finishLsn;
        this.initStartingPosition(endOfFileLsn, singleFileNumber);
        this.numRead = 0;
        this.cksumValidator = new ChecksumValidator();
    }

    protected void initStartingPosition(DbLsn endOfFileLsn, Long ignoreSingleFileNumber) throws IOException, DatabaseException {
        this.eof = false;
        if (this.forward) {
            if (this.startLsn != null) {
                this.readBufferFileNum = this.startLsn.getFileNumber();
                this.readBufferFileEnd = this.startLsn.getFileOffset();
            } else {
                Long firstNum = this.fileManager.getFirstFileNum();
                if (firstNum == null) {
                    this.eof = true;
                } else {
                    this.readBufferFileNum = firstNum;
                    this.readBufferFileEnd = 0L;
                }
            }
            this.nextEntryOffset = this.readBufferFileEnd;
        } else {
            if (!$assertionsDisabled && this.startLsn == null) {
                throw new AssertionError();
            }
            this.readBufferFileNum = endOfFileLsn.getFileNumber();
            this.readBufferFileEnd = this.readBufferFileStart = endOfFileLsn.getFileOffset();
            this.currentEntryPrevOffset = this.startLsn.getFileNumber() == endOfFileLsn.getFileNumber() ? this.startLsn.getFileOffset() : 0L;
            this.currentEntryOffset = endOfFileLsn.getFileOffset();
        }
    }

    public int getNumRead() {
        return this.numRead;
    }

    public DbLsn getLastLsn() {
        return new DbLsn(this.readBufferFileNum, this.currentEntryOffset);
    }

    public boolean readNextEntry() throws DatabaseException, IOException {
        boolean foundEntry = false;
        try {
            while (!this.eof && !foundEntry) {
                this.getLogEntryInReadBuffer();
                ByteBuffer dataBuffer = this.readData(14, true);
                boolean isTargetEntry = false;
                isTargetEntry = this.readHeader(dataBuffer);
                dataBuffer = this.readData(this.currentEntrySize, isTargetEntry);
                if (this.forward) {
                    this.currentEntryOffset = this.nextEntryOffset;
                    this.nextEntryOffset += (long)(14 + this.currentEntrySize);
                }
                if (!isTargetEntry || !this.readLogEntry(dataBuffer)) continue;
                foundEntry = true;
                ++this.numRead;
            }
        }
        catch (EOFException e) {
            this.eof = true;
        }
        catch (DatabaseException e) {
            this.eof = true;
            LogEntryType problemType = LogEntryType.findType(this.currentEntryTypeNum, this.currentEntryTypeVersion);
            Tracer.trace(this.env, "FileReader", "readNextEntry", "Halted log file reading at file 0x" + Long.toHexString(this.readBufferFileNum) + " offset 0x" + Long.toHexString(this.nextEntryOffset) + " offset(decimal)=" + this.nextEntryOffset + ":\nentry=" + problemType + "(typeNum=" + this.currentEntryTypeNum + ",version=" + this.currentEntryTypeVersion + ")\nprev=0x" + Long.toHexString(this.currentEntryPrevOffset) + "\nsize=" + this.currentEntrySize + "\nNext entry should be at 0x" + Long.toHexString(this.nextEntryOffset + 14L + (long)this.currentEntrySize) + "\n:", e);
            throw e;
        }
        return foundEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLogEntryInReadBuffer() throws IOException, DatabaseException, EOFException {
        DbLsn nextLsn;
        if (!this.forward) {
            if (this.currentEntryPrevOffset != 0L && this.currentEntryPrevOffset >= this.readBufferFileStart) {
                DbLsn nextLsn2 = new DbLsn(this.readBufferFileNum, this.currentEntryPrevOffset);
                if (this.finishLsn != null && nextLsn2.compareTo(this.finishLsn) == -1) {
                    throw new EOFException();
                }
                this.threadSafeBufferPosition(this.readBuffer, (int)(this.currentEntryPrevOffset - this.readBufferFileStart));
            } else {
                if (this.currentEntryPrevOffset == 0L) {
                    this.currentEntryPrevOffset = this.fileManager.getFileHeaderPrevOffset(this.readBufferFileNum);
                    Long prevFileNum = this.fileManager.getFollowingFileNum(this.readBufferFileNum, false);
                    if (prevFileNum == null) {
                        throw new EOFException();
                    }
                    if (this.readBufferFileNum - prevFileNum != 1L) {
                        throw new DatabaseException("Cannot read backward over cleaned file, from " + this.readBufferFileNum + " to " + prevFileNum);
                    }
                    this.readBufferFileNum = prevFileNum;
                    this.readBufferFileStart = this.currentEntryPrevOffset;
                } else {
                    long newPosition;
                    this.readBufferFileStart = this.currentEntryOffset - this.currentEntryPrevOffset > (long)this.readBufferSize ? this.currentEntryPrevOffset : ((newPosition = this.currentEntryOffset - (long)this.readBufferSize) < 0L ? 0L : newPosition);
                }
                DbLsn nextLsn3 = new DbLsn(this.readBufferFileNum, this.currentEntryPrevOffset);
                if (this.finishLsn != null && nextLsn3.compareTo(this.finishLsn) == -1) {
                    throw new EOFException();
                }
                FileHandle fileHandle = this.fileManager.getFileHandle(this.readBufferFileNum);
                try {
                    FileChannel channel = fileHandle.getFile().getChannel();
                    this.readBuffer.clear();
                    channel.read(this.readBuffer, this.readBufferFileStart);
                    if (EnvironmentImpl.getForcedYield()) {
                        Thread.yield();
                    }
                }
                finally {
                    fileHandle.release();
                }
                this.readBufferFileEnd = this.readBufferFileStart + (long)this.threadSafeBufferPosition(this.readBuffer);
                this.threadSafeBufferFlip(this.readBuffer);
                this.threadSafeBufferPosition(this.readBuffer, (int)(this.currentEntryPrevOffset - this.readBufferFileStart));
            }
            this.currentEntryOffset = this.currentEntryPrevOffset;
        } else if (this.finishLsn != null && (nextLsn = new DbLsn(this.readBufferFileNum, this.nextEntryOffset)).compareTo(this.finishLsn) >= 0) {
            throw new EOFException();
        }
    }

    private boolean readHeader(ByteBuffer dataBuffer) throws LogException, DbChecksumException {
        this.currentEntryChecksum = LogUtils.getUnsignedInt(dataBuffer);
        dataBuffer.mark();
        this.currentEntryTypeNum = dataBuffer.get();
        this.currentEntryTypeVersion = dataBuffer.get();
        this.currentEntryPrevOffset = LogUtils.getUnsignedInt(dataBuffer);
        this.currentEntrySize = LogUtils.readInt(dataBuffer);
        boolean isTarget = this.isTargetEntry(this.currentEntryTypeNum, this.currentEntryTypeVersion);
        if (isTarget) {
            this.cksumValidator.reset();
            int entryStart = this.threadSafeBufferPosition(dataBuffer);
            dataBuffer.reset();
            this.cksumValidator.update(this.env, dataBuffer, 10);
            this.threadSafeBufferPosition(dataBuffer, entryStart);
        }
        return isTarget;
    }

    private boolean readLogEntry(ByteBuffer entryBuffer) throws DbChecksumException, DatabaseException {
        this.cksumValidator.update(this.env, entryBuffer, this.currentEntrySize);
        this.cksumValidator.validate(this.env, this.currentEntryChecksum, this.readBufferFileNum, this.currentEntryOffset);
        if (!LogEntryType.isValidType(this.currentEntryTypeNum)) {
            throw new LogException("FileReader read invalid log entry type: " + this.currentEntryTypeNum);
        }
        return this.processEntry(entryBuffer);
    }

    private ByteBuffer readData(int amountToRead, boolean collectData) throws IOException, DatabaseException, EOFException {
        int alreadyRead = 0;
        ByteBuffer completeBuffer = null;
        this.saveBuffer.clear();
        while (alreadyRead < amountToRead && !this.eof) {
            if (this.readBuffer.hasRemaining()) {
                int bytesNeeded = amountToRead - alreadyRead;
                if (collectData) {
                    if (alreadyRead > 0 || this.readBuffer.remaining() < bytesNeeded) {
                        this.copyToSaveBuffer(bytesNeeded);
                        alreadyRead = this.threadSafeBufferPosition(this.saveBuffer);
                        completeBuffer = this.saveBuffer;
                        continue;
                    }
                    completeBuffer = this.readBuffer;
                    alreadyRead = amountToRead;
                    continue;
                }
                int positionIncrement = this.readBuffer.remaining() > bytesNeeded ? bytesNeeded : this.readBuffer.remaining();
                alreadyRead += positionIncrement;
                this.threadSafeBufferPosition(this.readBuffer, this.threadSafeBufferPosition(this.readBuffer) + positionIncrement);
                completeBuffer = this.readBuffer;
                continue;
            }
            this.fillReadBuffer();
        }
        this.threadSafeBufferFlip(this.saveBuffer);
        return completeBuffer;
    }

    private void copyToSaveBuffer(int bytesNeeded) {
        ByteBuffer temp;
        int bytesFromThisBuffer = bytesNeeded <= this.readBuffer.remaining() ? bytesNeeded : this.readBuffer.remaining();
        if (this.saveBuffer.capacity() - this.threadSafeBufferPosition(this.saveBuffer) < bytesFromThisBuffer) {
            temp = ByteBuffer.allocate(this.saveBuffer.capacity() + bytesFromThisBuffer);
            this.threadSafeBufferFlip(this.saveBuffer);
            temp.put(this.saveBuffer);
            this.saveBuffer = temp;
        }
        temp = this.readBuffer.slice();
        temp.limit(bytesFromThisBuffer);
        this.saveBuffer.put(temp);
        this.threadSafeBufferPosition(this.readBuffer, this.threadSafeBufferPosition(this.readBuffer) + bytesFromThisBuffer);
    }

    private void fillReadBuffer() throws DatabaseException, EOFException {
        block11: {
            FileHandle fileHandle = null;
            try {
                Long nextFile;
                fileHandle = this.fileManager.getFileHandle(this.readBufferFileNum);
                FileChannel channel = fileHandle.getFile().getChannel();
                boolean channelOk = false;
                if (this.readBufferFileEnd < channel.size()) {
                    channelOk = true;
                } else if (!this.singleFile && (nextFile = this.fileManager.getFollowingFileNum(this.readBufferFileNum, true)) != null) {
                    this.readBufferFileNum = nextFile;
                    fileHandle.release();
                    fileHandle = this.fileManager.getFileHandle(this.readBufferFileNum);
                    channel = fileHandle.getFile().getChannel();
                    channelOk = true;
                    this.readBufferFileEnd = 0L;
                    this.nextEntryOffset = 0L;
                }
                if (channelOk) {
                    this.readBuffer.clear();
                    channel.read(this.readBuffer, this.readBufferFileEnd);
                    if (EnvironmentImpl.getForcedYield()) {
                        Thread.yield();
                    }
                    this.readBufferFileStart = this.readBufferFileEnd;
                    this.readBufferFileEnd = this.readBufferFileStart + (long)this.threadSafeBufferPosition(this.readBuffer);
                    this.threadSafeBufferFlip(this.readBuffer);
                    break block11;
                }
                throw new EOFException();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new DatabaseException("Problem in fillReadBuffer, readBufferFileNum = " + this.readBufferFileNum + ": " + e.getMessage());
            }
            finally {
                if (fileHandle != null) {
                    fileHandle.release();
                }
            }
        }
    }

    protected boolean isTargetEntry(byte logEntryTypeNumber, byte logEntryTypeVersion) {
        return true;
    }

    protected abstract boolean processEntry(ByteBuffer var1) throws DatabaseException;

    private Buffer threadSafeBufferFlip(ByteBuffer buffer) {
        while (true) {
            try {
                return buffer.flip();
            }
            catch (IllegalArgumentException IAE) {
                continue;
            }
            break;
        }
    }

    private int threadSafeBufferPosition(ByteBuffer buffer) {
        while (true) {
            try {
                return buffer.position();
            }
            catch (IllegalArgumentException IAE) {
                continue;
            }
            break;
        }
    }

    private Buffer threadSafeBufferPosition(ByteBuffer buffer, int newPosition) {
        while (true) {
            try {
                return buffer.position(newPosition);
            }
            catch (IllegalArgumentException IAE) {
                continue;
            }
            break;
        }
    }

    static {
        $assertionsDisabled = !FileReader.class.desiredAssertionStatus();
    }

    private static class EOFException
    extends Exception {
        private EOFException() {
        }
    }
}

