/*
 * Decompiled with CFR 0.152.
 */
package jena;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.RDFWriterFImpl;
import com.hp.hpl.jena.shared.NoWriterForLangException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jena.cmdline.ArgDecl;
import jena.cmdline.ArgHandler;
import jena.cmdline.CommandLine;

public class rdfcat {
    public final ArgDecl IN_N3 = new ArgDecl(true, "n", "n3", "ttl", "N3", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.m_actionQ.add(new ReadAction(val, "N3"));
        }
    });
    public final ArgDecl IN_RDF_XML = new ArgDecl(true, "x", "xml", "rdfxml", "rdf", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.m_actionQ.add(new ReadAction(val, "RDF/XML"));
        }
    });
    public final ArgDecl IN_NTRIPLE = new ArgDecl(true, "t", "ntriples", "ntriple", "n-triple", "n-triples", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.m_actionQ.add(new ReadAction(val, "N-TRIPLE"));
        }
    });
    public final ArgDecl OUT_LANG = new ArgDecl(true, "out", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.setOutput(val);
        }
    });
    public final ArgDecl IN_LANG = new ArgDecl(true, "in", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.expectInput(val);
        }
    });
    public final ArgDecl INCLUDE = new ArgDecl(false, "include", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.setInclude(true);
        }
    });
    public final ArgDecl NOINCLUDE = new ArgDecl(false, "noinclude", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.setInclude(false);
        }
    });
    public final ArgDecl NOFILTER = new ArgDecl(false, "nofilter", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.setRemoveIncludeStatements(false);
        }
    });
    public final ArgDecl HELP = new ArgDecl(false, "help", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.usage();
        }
    });
    public final ArgDecl USAGE = new ArgDecl(false, "usage", new ArgHandler(){

        public void action(String arg, String val) throws IllegalArgumentException {
            rdfcat.this.usage();
        }
    });
    protected CommandLine m_cmdLine = new RCCommandLine().add(this.IN_N3).add(this.IN_NTRIPLE).add(this.IN_RDF_XML).add(this.OUT_LANG).add(this.IN_LANG).add(this.INCLUDE).add(this.NOINCLUDE).add(this.NOFILTER).add(this.HELP).add(this.USAGE);
    protected Model m_model = ModelFactory.createDefaultModel();
    protected String m_outputFormat = "RDF/XML-ABBREV";
    protected String m_inputFormat = "RDF/XML";
    protected boolean m_include = false;
    protected Set m_seen = new HashSet();
    protected boolean m_removeIncludeStatements = true;
    protected List m_actionQ = new ArrayList();
    public static Map unabbreviate = rdfcat.makeUnabbreviateMap();

    public static void main(String[] args) {
        new rdfcat().go(args);
    }

    protected void go(String[] args) {
        this.m_cmdLine.process(args);
        for (int i = 0; i < this.m_cmdLine.numItems(); ++i) {
            this.m_actionQ.add(new ReadAction(this.m_cmdLine.getItem(i), this.getExpectedInput()));
        }
        Iterator j = this.m_actionQ.iterator();
        while (j.hasNext()) {
            ((RCAction)j.next()).run(this);
        }
        this.m_model.write(this.getOutputStream(), this.m_outputFormat);
    }

    protected void expectInput(String lang) {
        this.m_inputFormat = lang;
    }

    protected String getExpectedInput() {
        return this.m_inputFormat;
    }

    protected void setOutput(String lang) {
        this.m_outputFormat = rdfcat.getCheckedLanguage(lang);
    }

    public static String getCheckedLanguage(String shortLang) {
        String fullLang = (String)unabbreviate.get(shortLang);
        String tryLang = fullLang == null ? shortLang : fullLang;
        try {
            new RDFWriterFImpl().getWriter(tryLang);
        }
        catch (NoWriterForLangException e) {
            throw new IllegalArgumentException("'" + shortLang + "' is not recognised as a legal output format");
        }
        return tryLang;
    }

    protected static Map makeUnabbreviateMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("x", "RDF/XML");
        result.put("rdf", "RDF/XML");
        result.put("rdfxml", "RDF/XML");
        result.put("xml", "RDF/XML");
        result.put("n3", "N3");
        result.put("n", "N3");
        result.put("ttl", "N3");
        result.put("ntriples", "N-TRIPLE");
        result.put("ntriple", "N-TRIPLE");
        result.put("t", "N-TRIPLE");
        result.put("owl", "RDF/XML-ABBREV");
        result.put("abbrev", "RDF/XML-ABBREV");
        return result;
    }

    protected void setInclude(boolean incl) {
        this.m_include = incl;
    }

    protected void setRemoveIncludeStatements(boolean f) {
        this.m_removeIncludeStatements = f;
    }

    protected void readInput(String inputName) {
        ArrayList<IncludeQueueEntry> queue = new ArrayList<IncludeQueueEntry>();
        queue.add(new IncludeQueueEntry(inputName, null));
        while (!queue.isEmpty()) {
            IncludeQueueEntry entry = (IncludeQueueEntry)queue.remove(0);
            String in = entry.m_includeURI;
            if (this.m_seen.contains(in)) continue;
            this.m_seen.add(in);
            Model inModel = ModelFactory.createDefaultModel();
            if (in.equals("-")) {
                inModel.read(System.in, null, this.m_inputFormat);
            } else {
                String lang = FileUtils.guessLang(in, this.m_inputFormat);
                FileManager.get().readModel(inModel, in, lang);
            }
            if (this.m_include) {
                this.addIncludes(inModel, queue);
            }
            this.m_model.add(inModel);
            this.m_model.setNsPrefixes(inModel);
            if (!this.m_removeIncludeStatements || entry.m_includeStmt == null) continue;
            this.m_model.remove(entry.m_includeStmt);
        }
    }

    protected OutputStream getOutputStream() {
        return System.out;
    }

    protected void addIncludes(Model inModel, List queue) {
        Statement s;
        StmtIterator i = inModel.listStatements(null, RDFS.seeAlso, (RDFNode)null);
        while (i.hasNext()) {
            s = i.nextStatement();
            queue.add(new IncludeQueueEntry(this.getURL(s.getObject()), s));
        }
        i = inModel.listStatements(null, OWL.imports, (RDFNode)null);
        while (i.hasNext()) {
            s = i.nextStatement();
            queue.add(new IncludeQueueEntry(this.getURL(s.getResource()), s));
        }
    }

    protected void usage() {
        System.err.println("Usage: java jena.rdfcat (option|input)*");
        System.err.println("Concatenates the contents of zero or more input RDF documents.");
        System.err.println("Options: -out N3 | N-TRIPLE | RDF/XML | RDF/XML-ABBREV");
        System.err.println("         -n  expect subsequent inputs in N3 syntax");
        System.err.println("         -x  expect subsequent inputs in RDF/XML syntax");
        System.err.println("         -t  expect subsequent inputs in N-TRIPLE syntax");
        System.err.println("         -[no]include  include rdfs:seeAlso and owl:imports");
        System.err.println("input can be filename, URL, or - for stdin");
        System.err.println("Recognised aliases for -n are: -n3 -ttl or -N3");
        System.err.println("Recognised aliases for -x are: -xml -rdf or -rdfxml");
        System.err.println("Recognised aliases for -t are: -ntriple");
        System.err.println("Output format aliases: x, xml or rdf for RDF/XML, n, n3 or ttl for N3, t or ntriple for N-TRIPLE");
        System.err.println("See the Javadoc for jena.rdfcat for additional details.");
        System.exit(0);
    }

    protected String getURL(RDFNode n) {
        return n.isLiteral() ? ((Literal)n).getLexicalForm() : ((Resource)n).getURI();
    }

    protected class ReadAction
    implements RCAction {
        private String m_lang;
        private String m_uri;

        protected ReadAction(String uri, String lang) {
            this.m_lang = lang;
            this.m_uri = uri;
        }

        public void run(rdfcat rc) {
            String l = rc.getExpectedInput();
            if (this.m_lang != null) {
                rc.expectInput(this.m_lang);
            }
            rc.readInput(this.m_uri);
            rc.expectInput(l);
        }
    }

    protected static interface RCAction {
        public void run(rdfcat var1);
    }

    protected class IncludeQueueEntry {
        protected String m_includeURI;
        protected Statement m_includeStmt;

        protected IncludeQueueEntry(String includeURI, Statement includeStmt) {
            this.m_includeURI = includeURI;
            this.m_includeStmt = includeStmt;
        }
    }

    protected class RCCommandLine
    extends CommandLine {
        protected RCCommandLine() {
        }

        public boolean xendProcessing(String argStr) {
            return false;
        }

        public void handleUnrecognizedArg(String argStr) {
            if (argStr.equals("-") || !argStr.startsWith("-")) {
                rdfcat.this.m_actionQ.add(new ReadAction(argStr, rdfcat.this.getExpectedInput()));
            } else {
                System.err.println("Unrecognised argument: " + argStr);
                rdfcat.this.usage();
            }
        }

        public boolean ignoreArgument(String argStr) {
            return !argStr.startsWith("-") || argStr.length() == 1;
        }

        public Iterator getItems() {
            return this.items.iterator();
        }
    }
}

