/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.ModelAssembler;
import com.hp.hpl.jena.assembler.assemblers.OntModelAssembler;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import java.lang.reflect.Field;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestOntModelAssembler
extends AssemblerTestBase {
    public TestOntModelAssembler(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite result = new TestSuite();
        result.addTestSuite(TestOntModelAssembler.class);
        TestOntModelAssembler.addParameterisedTests(result);
        return result;
    }

    protected Class getAssemblerClass() {
        return OntModelAssembler.class;
    }

    public void testOntModelAssemblerType() {
        this.testDemandsMinimalType((Assembler)new OntModelAssembler(), JA.OntModel);
    }

    protected static void addParameterisedTests(TestSuite result) {
        Field[] fields = OntModelSpec.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            String name = f.getName();
            if (f.getType() != (class$com$hp$hpl$jena$ontology$OntModelSpec == null ? TestOntModelAssembler.class$("com.hp.hpl.jena.ontology.OntModelSpec") : class$com$hp$hpl$jena$ontology$OntModelSpec)) continue;
            try {
                result.addTest(TestOntModelAssembler.createTest((OntModelSpec)f.get(null), name));
                continue;
            }
            catch (Exception e) {
                System.err.println("WARNING: failed to create test for OntModelSpec " + name);
            }
        }
    }

    protected static Test createTest(final OntModelSpec spec, final String name) {
        return new TestOntModelAssembler(name){

            public void runBare() {
                OntModelAssembler a = new OntModelAssembler();
                Model m = (Model)a.open((Assembler)new AssemblerTestBase.FixedObjectAssembler(spec), this.resourceInModel("x rdf:type ja:OntModel; x ja:ontModelSpec ja:" + name));
                1.assertInstanceOf(class$com$hp$hpl$jena$ontology$OntModel == null ? (class$com$hp$hpl$jena$ontology$OntModel = TestOntModelAssembler.class$("com.hp.hpl.jena.ontology.OntModel")) : class$com$hp$hpl$jena$ontology$OntModel, m);
                OntModel om = (OntModel)m;
                1.assertSame((Object)spec, (Object)om.getSpecification());
            }
        };
    }

    public void testAllDefaults() {
        OntModelAssembler a = new OntModelAssembler();
        Model m = a.openModel(this.resourceInModel("x rdf:type ja:OntModel"));
        TestOntModelAssembler.assertInstanceOf(OntModel.class, m);
        OntModel om = (OntModel)m;
        TestOntModelAssembler.assertSame((Object)OntModelSpec.OWL_MEM_RDFS_INF, (Object)om.getSpecification());
    }

    public void testBaseModel() {
        final Model baseModel = this.model("a P b");
        OntModelAssembler a = new OntModelAssembler();
        ModelAssembler aa = new ModelAssembler(){

            protected Model openEmptyModel(Assembler a, Resource root, Mode irrelevant) {
                Assert.assertEquals((Object)ModelTestBase.resource("y"), (Object)root);
                return baseModel;
            }
        };
        Object m = a.open((Assembler)aa, this.resourceInModel("x rdf:type ja:OntModel; x ja:baseModel y"));
        TestOntModelAssembler.assertInstanceOf(OntModel.class, m);
        OntModel om = (OntModel)m;
        TestOntModelAssembler.assertSame((Object)baseModel.getGraph(), (Object)om.getBaseModel().getGraph());
    }

    public void testSubModels() {
        final Model baseModel = this.model("a P b");
        OntModelAssembler a = new OntModelAssembler();
        ModelAssembler aa = new ModelAssembler(){

            protected Model openEmptyModel(Assembler a, Resource root, Mode irrelevant) {
                Assert.assertEquals((Object)ModelTestBase.resource("y"), (Object)root);
                return baseModel;
            }
        };
        Object m = a.open((Assembler)aa, this.resourceInModel("x rdf:type ja:OntModel; x ja:subModel y"));
        TestOntModelAssembler.assertInstanceOf(OntModel.class, m);
        OntModel om = (OntModel)m;
        List subModels = om.listSubModels().toList();
        TestOntModelAssembler.assertEquals((int)1, (int)subModels.size());
        TestOntModelAssembler.assertSame((Object)baseModel.getGraph(), (Object)((OntModel)subModels.get(0)).getBaseModel().getGraph());
    }

    public void testDefaultDocumentManager() {
        OntModelAssembler a = new OntModelAssembler();
        Resource root = this.resourceInModel("x rdf:type ja:OntModel");
        OntModel om = (OntModel)a.openModel(root);
        TestOntModelAssembler.assertSame((Object)OntDocumentManager.getInstance(), (Object)om.getDocumentManager());
    }

    public void testUsesOntModelSpec() {
        OntModelAssembler a = new OntModelAssembler();
        Resource root = this.resourceInModel("x rdf:type ja:OntModel; x ja:ontModelSpec y");
        OntModelSpec spec = new OntModelSpec(OntModelSpec.DAML_MEM);
        AssemblerTestBase.NamedObjectAssembler mock = new AssemblerTestBase.NamedObjectAssembler(TestOntModelAssembler.resource("y"), spec);
        OntModel om = (OntModel)a.open((Assembler)mock, root);
        TestOntModelAssembler.assertSame((Object)spec, (Object)om.getSpecification());
    }
}

