/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import java.util.Date;

public class TestLiteralsInModel
extends ModelTestBase {
    protected final Model m = this.getModel();
    static final Resource X = TestLiteralsInModel.resource("X");
    static final Property P = TestLiteralsInModel.property("P");

    public TestLiteralsInModel(String name) {
        super(name);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void testAddWithFloatObject() {
        this.m.addLiteral(X, P, 14.0f);
        TestLiteralsInModel.assertTrue((boolean)this.m.contains(X, P, (RDFNode)this.m.createTypedLiteral(14.0f)));
        TestLiteralsInModel.assertTrue((boolean)this.m.containsLiteral(X, P, 14.0f));
    }

    public void testAddWithDoubleObject() {
        this.m.addLiteral(X, P, 14.0);
        TestLiteralsInModel.assertTrue((boolean)this.m.contains(X, P, (RDFNode)this.m.createTypedLiteral(14.0)));
        TestLiteralsInModel.assertTrue((boolean)this.m.containsLiteral(X, P, 14.0));
    }

    public void testAddWithBooleanObject() {
        this.m.addLiteral(X, P, true);
        TestLiteralsInModel.assertTrue((boolean)this.m.contains(X, P, (RDFNode)this.m.createTypedLiteral(true)));
        TestLiteralsInModel.assertTrue((boolean)this.m.containsLiteral(X, P, true));
    }

    public void testAddWithCharObject() {
        this.m.addLiteral(X, P, 'x');
        TestLiteralsInModel.assertTrue((boolean)this.m.contains(X, P, (RDFNode)this.m.createTypedLiteral('x')));
        TestLiteralsInModel.assertTrue((boolean)this.m.containsLiteral(X, P, 'x'));
    }

    public void testAddWithLongObject() {
        this.m.addLiteral(X, P, 99L);
        TestLiteralsInModel.assertTrue((boolean)this.m.contains(X, P, (RDFNode)this.m.createTypedLiteral(99L)));
        TestLiteralsInModel.assertTrue((boolean)this.m.containsLiteral(X, P, 99L));
    }

    public void testAddWithIntObject() {
        this.m.addLiteral(X, P, 99);
        TestLiteralsInModel.assertTrue((boolean)this.m.contains(X, P, (RDFNode)this.m.createTypedLiteral(99)));
        TestLiteralsInModel.assertTrue((boolean)this.m.containsLiteral(X, P, 99));
    }

    public void testAddWithAnObject() {
        Date z = new Date();
        this.m.addLiteral(X, P, (Object)z);
        TestLiteralsInModel.assertTrue((boolean)this.m.contains(X, P, (RDFNode)this.m.createTypedLiteral((Object)z)));
        TestLiteralsInModel.assertTrue((boolean)this.m.containsLiteral(X, P, (Object)z));
    }
}

