/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.listeners.ChangedListener;
import com.hp.hpl.jena.rdf.listeners.NullListener;
import com.hp.hpl.jena.rdf.listeners.ObjectListener;
import com.hp.hpl.jena.rdf.listeners.StatementListener;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.StmtIteratorImpl;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.rdf.model.test.RecordingModelListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestModelEvents
extends ModelTestBase {
    protected Model model;
    protected RecordingModelListener SL;

    public TestModelEvents(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelEvents.class);
    }

    public void setUp() {
        this.model = ModelFactory.createDefaultModel();
        this.SL = new RecordingModelListener();
    }

    public void testRegistrationCompiles() {
        TestModelEvents.assertSame((Object)this.model, (Object)this.model.register((ModelChangedListener)new RecordingModelListener()));
    }

    public void testUnregistrationCompiles() {
        this.model.unregister((ModelChangedListener)new RecordingModelListener());
    }

    public void testAddSingleStatements() {
        Statement S1 = TestModelEvents.statement(this.model, "S P O");
        Statement S2 = TestModelEvents.statement(this.model, "A B C");
        TestModelEvents.assertFalse((boolean)this.SL.has(new Object[]{"add", S1}));
        this.model.register((ModelChangedListener)this.SL);
        this.model.add(S1);
        this.SL.assertHas(new Object[]{"add", S1});
        this.model.add(S2);
        this.SL.assertHas(new Object[]{"add", S1, "add", S2});
        this.model.add(S1);
        this.SL.assertHas(new Object[]{"add", S1, "add", S2, "add", S1});
    }

    public void testTwoListeners() {
        Statement S = TestModelEvents.statement(this.model, "S P O");
        RecordingModelListener SL1 = new RecordingModelListener();
        RecordingModelListener SL2 = new RecordingModelListener();
        this.model.register((ModelChangedListener)SL1).register((ModelChangedListener)SL2);
        this.model.add(S);
        SL2.assertHas(new Object[]{"add", S});
        SL1.assertHas(new Object[]{"add", S});
    }

    public void testUnregisterWorks() {
        this.model.register((ModelChangedListener)this.SL);
        this.model.unregister((ModelChangedListener)this.SL);
        this.model.add(TestModelEvents.statement(this.model, "X R Y"));
        this.SL.assertHas(new Object[0]);
    }

    public void testRemoveSingleStatements() {
        Statement S = TestModelEvents.statement(this.model, "D E F");
        this.model.register((ModelChangedListener)this.SL);
        this.model.add(S);
        this.model.remove(S);
        this.SL.assertHas(new Object[]{"add", S, "remove", S});
    }

    public void testAddInPieces() {
        this.model.register((ModelChangedListener)this.SL);
        this.model.add(TestModelEvents.resource(this.model, "S"), TestModelEvents.property(this.model, "P"), (RDFNode)TestModelEvents.resource(this.model, "O"));
        this.SL.assertHas(new Object[]{"add", TestModelEvents.statement(this.model, "S P O")});
    }

    public void testAddStatementArray() {
        this.model.register((ModelChangedListener)this.SL);
        Statement[] s = TestModelEvents.statements(this.model, "a P b; c Q d");
        this.model.add(s);
        this.SL.assertHas(new Object[]{"add[]", Arrays.asList(s)});
    }

    public void testDeleteStatementArray() {
        this.model.register((ModelChangedListener)this.SL);
        Statement[] s = TestModelEvents.statements(this.model, "a P b; c Q d");
        this.model.remove(s);
        this.SL.assertHas(new Object[]{"remove[]", Arrays.asList(s)});
    }

    public void testAddStatementList() {
        this.model.register((ModelChangedListener)this.SL);
        List<Statement> L = Arrays.asList(TestModelEvents.statements(this.model, "b I g; m U g"));
        this.model.add(L);
        this.SL.assertHas(new Object[]{"addList", L});
    }

    public void testDeleteStatementList() {
        this.model.register((ModelChangedListener)this.SL);
        List<Statement> L = Arrays.asList(TestModelEvents.statements(this.model, "b I g; m U g"));
        this.model.remove(L);
        this.SL.assertHas(new Object[]{"removeList", L});
    }

    public void testAddStatementIterator() {
        this.model.register((ModelChangedListener)this.SL);
        Statement[] sa = TestModelEvents.statements(this.model, "x R y; a P b; x R y");
        StmtIterator it = this.asIterator(sa);
        this.model.add(it);
        this.SL.assertHas(new Object[]{"addIterator", Arrays.asList(sa)});
    }

    public void testDeleteStatementIterator() {
        this.model.register((ModelChangedListener)this.SL);
        Statement[] sa = TestModelEvents.statements(this.model, "x R y; a P b; x R y");
        StmtIterator it = this.asIterator(sa);
        this.model.remove(it);
        this.SL.assertHas(new Object[]{"removeIterator", Arrays.asList(sa)});
    }

    protected StmtIterator asIterator(Statement[] statements) {
        return new StmtIteratorImpl(Arrays.asList(statements).iterator());
    }

    public void testAddModel() {
        this.model.register((ModelChangedListener)this.SL);
        Model m = TestModelEvents.modelWithStatements("NT beats S; S beats H; H beats D");
        this.model.add(m);
        this.SL.assertHas(new Object[]{"addModel", m});
    }

    public void testDeleteModel() {
        this.model.register((ModelChangedListener)this.SL);
        Model m = TestModelEvents.modelWithStatements("NT beats S; S beats H; H beats D");
        this.model.remove(m);
        this.SL.assertHas(new Object[]{"removeModel", m});
    }

    public void testNullListener() {
        NullListener NL = new NullListener();
        this.model.register((ModelChangedListener)NL);
        this.model.add(TestModelEvents.statement(this.model, "S P O "));
        this.model.remove(TestModelEvents.statement(this.model, "X Y Z"));
        this.model.add(TestModelEvents.statements(this.model, "a B c; d E f"));
        this.model.remove(TestModelEvents.statements(this.model, "g H i; j K l"));
        this.model.add(this.asIterator(TestModelEvents.statements(this.model, "m N o; p Q r")));
        this.model.remove(this.asIterator(TestModelEvents.statements(this.model, "s T u; v W x")));
        this.model.add(TestModelEvents.modelWithStatements("leaves fall softly"));
        this.model.remove(TestModelEvents.modelWithStatements("water drips endlessly"));
        this.model.add(Arrays.asList(TestModelEvents.statements(this.model, "xx RR yy")));
        this.model.remove(Arrays.asList(TestModelEvents.statements(this.model, "aa VV rr")));
    }

    public void testChangedListener() {
        ChangedListener CL = new ChangedListener();
        this.model.register((ModelChangedListener)CL);
        TestModelEvents.assertFalse((boolean)CL.hasChanged());
        this.model.add(TestModelEvents.statement(this.model, "S P O"));
        TestModelEvents.assertTrue((boolean)CL.hasChanged());
        TestModelEvents.assertFalse((boolean)CL.hasChanged());
        this.model.remove(TestModelEvents.statement(this.model, "ab CD ef"));
        TestModelEvents.assertTrue((boolean)CL.hasChanged());
        this.model.add(TestModelEvents.statements(this.model, "gh IJ kl"));
        TestModelEvents.assertTrue((boolean)CL.hasChanged());
        this.model.remove(TestModelEvents.statements(this.model, "mn OP qr"));
        TestModelEvents.assertTrue((boolean)CL.hasChanged());
        this.model.add(this.asIterator(TestModelEvents.statements(this.model, "st UV wx")));
        TestModelEvents.assertTrue((boolean)CL.hasChanged());
        TestModelEvents.assertFalse((boolean)CL.hasChanged());
        this.model.remove(this.asIterator(TestModelEvents.statements(this.model, "yz AB cd")));
        TestModelEvents.assertTrue((boolean)CL.hasChanged());
        this.model.add(TestModelEvents.modelWithStatements("ef GH ij"));
        TestModelEvents.assertTrue((boolean)CL.hasChanged());
        this.model.remove(TestModelEvents.modelWithStatements("kl MN op"));
        TestModelEvents.assertTrue((boolean)CL.hasChanged());
        this.model.add(Arrays.asList(TestModelEvents.statements(this.model, "rs TU vw")));
        TestModelEvents.assertTrue((boolean)CL.hasChanged());
        this.model.remove(Arrays.asList(TestModelEvents.statements(this.model, "xy wh q")));
        TestModelEvents.assertTrue((boolean)CL.hasChanged());
    }

    public void testGeneralEvent() {
        this.model.register((ModelChangedListener)this.SL);
        int[] e = new int[]{};
        this.model.notifyEvent((Object)e);
        this.SL.assertHas(new Object[]{"someEvent", this.model, e});
    }

    public void another(Map m, Object x) {
        Integer n = (Integer)m.get(x);
        if (n == null) {
            n = new Integer(0);
        }
        m.put(x, new Integer(n + 1));
    }

    public Map asBag(List l) {
        HashMap result = new HashMap();
        for (int i = 0; i < l.size(); ++i) {
            this.another(result, l.get(i));
        }
        return result;
    }

    public void assertSameBag(List wanted, List got) {
        TestModelEvents.assertEquals((Object)this.asBag(wanted), (Object)this.asBag(got));
    }

    public void testGot(WatchStatementListener sl, String how, String template) {
        this.assertSameBag(Arrays.asList(TestModelEvents.statements(this.model, template)), sl.contents());
        TestModelEvents.assertEquals((String)how, (String)sl.getAddOrRem());
        TestModelEvents.assertTrue((sl.contents().size() == 0 ? 1 : 0) != 0);
    }

    public void testTripleListener() {
        WatchStatementListener sl = new WatchStatementListener();
        this.model.register((ModelChangedListener)sl);
        this.model.add(TestModelEvents.statement(this.model, "b C d"));
        this.testGot(sl, "add", "b C d");
        this.model.remove(TestModelEvents.statement(this.model, "e F g"));
        this.testGot(sl, "rem", "e F g");
        this.model.add(TestModelEvents.statements(this.model, "h I j; k L m"));
        this.testGot(sl, "add", "h I j; k L m");
        this.model.remove(TestModelEvents.statements(this.model, "n O p; q R s"));
        this.testGot(sl, "rem", "n O p; q R s");
        this.model.add(Arrays.asList(TestModelEvents.statements(this.model, "t U v; w X y")));
        this.testGot(sl, "add", "t U v; w X y");
        this.model.remove(Arrays.asList(TestModelEvents.statements(this.model, "z A b; c D e")));
        this.testGot(sl, "rem", "z A b; c D e");
        this.model.add(this.asIterator(TestModelEvents.statements(this.model, "f G h; i J k")));
        this.testGot(sl, "add", "f G h; i J k");
        this.model.remove(this.asIterator(TestModelEvents.statements(this.model, "l M n; o P q")));
        this.testGot(sl, "rem", "l M n; o P q");
        this.model.add(TestModelEvents.modelWithStatements("r S t; u V w; x Y z"));
        this.testGot(sl, "add", "r S t; u V w; x Y z");
        this.model.remove(TestModelEvents.modelWithStatements("a E i; o U y"));
        this.testGot(sl, "rem", "a E i; o U y");
    }

    public void testObjectListener() {
        OL ll = new OL();
        this.model.register((ModelChangedListener)ll);
        Statement s = TestModelEvents.statement(this.model, "aa BB cc");
        Statement s2 = TestModelEvents.statement(this.model, "dd EE ff");
        this.model.add(s);
        ll.recent("add", s);
        this.model.remove(s2);
        ll.recent("rem", s2);
        List<Statement> sList = Arrays.asList(TestModelEvents.statements(this.model, "gg HH ii; jj KK ll"));
        this.model.add(sList);
        ll.recent("add", sList);
        List<Statement> sList2 = Arrays.asList(TestModelEvents.statements(this.model, "mm NN oo; pp QQ rr; ss TT uu"));
        this.model.remove(sList2);
        ll.recent("rem", sList2);
        Model m1 = TestModelEvents.modelWithStatements("vv WW xx; yy ZZ aa");
        this.model.add(m1);
        ll.recent("add", m1);
        Model m2 = TestModelEvents.modelWithStatements("a B g; d E z");
        this.model.remove(m2);
        ll.recent("rem", m2);
        Statement[] sa1 = TestModelEvents.statements(this.model, "th i k; l m n");
        this.model.add(sa1);
        ll.recent("add", sa1);
        Statement[] sa2 = TestModelEvents.statements(this.model, "x o p; r u ch");
        this.model.remove(sa2);
        ll.recent("rem", sa2);
        Statement[] si1 = TestModelEvents.statements(this.model, "u ph ch; psi om eh");
        this.model.add(this.asIterator(si1));
        ll.recent("add", this.asIterator(si1));
        Statement[] si2 = TestModelEvents.statements(this.model, "at last the; end of these; tests ok guv");
        this.model.remove(this.asIterator(si2));
        ll.recent("rem", this.asIterator(si2));
    }

    static class OL
    extends ObjectListener {
        private Object recorded;
        private String how;

        OL() {
        }

        public void added(Object x) {
            this.recorded = x;
            this.how = "add";
        }

        public void removed(Object x) {
            this.recorded = x;
            this.how = "rem";
        }

        private Object comparable(Object x) {
            if (x instanceof Statement[]) {
                return Arrays.asList((Statement[])x);
            }
            if (x instanceof Iterator) {
                return GraphTestBase.iteratorToList((Iterator)x);
            }
            return x;
        }

        public void recent(String wantHow, Object value) {
            Assert.assertEquals((Object)this.comparable(value), (Object)this.comparable(this.recorded));
            Assert.assertEquals((String)wantHow, (String)this.how);
            this.how = null;
            this.recorded = null;
        }
    }

    public static class WatchStatementListener
    extends StatementListener {
        List statements = new ArrayList();
        String addOrRem = "<unset>";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List contents() {
            try {
                List list = this.statements;
                return list;
            }
            finally {
                this.statements = new ArrayList();
            }
        }

        public String getAddOrRem() {
            return this.addOrRem;
        }

        public void addedStatement(Statement s) {
            this.statements.add(s);
            this.addOrRem = "add";
        }

        public void removedStatement(Statement s) {
            this.statements.add(s);
            this.addOrRem = "rem";
        }
    }
}

