/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import java.util.ArrayList;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.ElementBase;
import org.jibx.binding.model.ModelVisitor;
import org.jibx.binding.model.TreeContext;
import org.jibx.binding.model.ValidationProblem;
import org.jibx.util.IClass;
import org.jibx.util.IClassLocator;

public class ValidationContext
extends TreeContext {
    private int m_warningCount;
    private int m_errorCount;
    private int m_fatalCount;
    private ArrayList m_problemList = new ArrayList();

    public ValidationContext(IClassLocator iloc) {
        super(iloc);
    }

    private ElementBase safePeekElement() {
        try {
            return this.peekElement();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public void prevalidate(BindingElement root) {
        PrevalidationVisitor visitor = new PrevalidationVisitor();
        this.tourTree(root, (ModelVisitor)visitor);
    }

    public void validate(BindingElement root) {
        ValidationVisitor visitor = new ValidationVisitor();
        this.tourTree(root, (ModelVisitor)visitor);
    }

    public int getWarningCount() {
        return this.m_warningCount;
    }

    public int getErrorCount() {
        return this.m_errorCount;
    }

    public int getFatalCount() {
        return this.m_fatalCount;
    }

    public void addWarning(String msg) {
        this.addWarning(msg, this.safePeekElement());
    }

    public void addWarning(String msg, Object obj) {
        this.addProblem(new ValidationProblem(0, msg, obj));
    }

    public void addError(String msg) {
        this.addError(msg, this.safePeekElement());
    }

    public void addError(String msg, Object obj) {
        this.addProblem(new ValidationProblem(1, msg, obj));
    }

    public void addFatal(String msg) {
        this.addFatal(msg, this.safePeekElement());
    }

    public void addFatal(String msg, Object obj) {
        this.addProblem(new ValidationProblem(2, msg, obj));
    }

    public void addProblem(ValidationProblem problem) {
        this.m_problemList.add(problem);
        switch (problem.getSeverity()) {
            case 1: {
                ++this.m_errorCount;
                break;
            }
            case 2: {
                ++this.m_fatalCount;
                this.addSkip(problem.getComponent());
                break;
            }
            case 0: {
                ++this.m_warningCount;
            }
        }
    }

    public ArrayList getProblems() {
        return this.m_problemList;
    }

    public IClass getClassInfo(String name) {
        try {
            return super.getClassInfo(name);
        }
        catch (Exception e) {
            this.addFatal(e.getMessage());
            return null;
        }
    }

    protected class ValidationVisitor
    extends ModelVisitor {
        protected ValidationVisitor() {
        }

        public void exit(ElementBase node) {
            try {
                node.validate(ValidationContext.this);
            }
            catch (Throwable t) {
                ValidationContext.this.addFatal("Error during validation: " + t.getMessage());
                t.printStackTrace();
            }
        }
    }

    protected class PrevalidationVisitor
    extends ModelVisitor {
        protected PrevalidationVisitor() {
        }

        public boolean visit(ElementBase node) {
            try {
                node.prevalidate(ValidationContext.this);
            }
            catch (Throwable t) {
                ValidationContext.this.addFatal("Error during validation: " + t.getMessage());
                t.printStackTrace();
                return false;
            }
            return true;
        }
    }
}

