/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.support;

import java.util.HashMap;
import org.jibx.runtime.QName;
import org.jibx.schema.INamed;
import org.jibx.schema.elements.CommonTypeDefinition;

public abstract class SchemaTypes {
    private static final HashMap s_schemaTypesMap = new HashMap();
    public static final SchemaSimpleType ANY_TYPE = SchemaTypes.addType("anyType", false);
    public static final SchemaSimpleType ANY_SIMPLE_TYPE = SchemaTypes.addType("anySimpleType", false);
    public static final SchemaSimpleType ANY_URI = SchemaTypes.addType("anyURI", false);
    public static final SchemaSimpleType BASE64_BINARY = SchemaTypes.addType("base64Binary", false);
    public static final SchemaSimpleType BOOLEAN_TYPE = SchemaTypes.addType("boolean", false);
    public static final SchemaSimpleType BYTE = SchemaTypes.addType("byte", false);
    public static final SchemaSimpleType DATE = SchemaTypes.addType("date", false);
    public static final SchemaSimpleType DATETIME = SchemaTypes.addType("dateTime", false);
    public static final SchemaSimpleType DECIMAL = SchemaTypes.addType("decimal", false);
    public static final SchemaSimpleType DOUBLE = SchemaTypes.addType("double", false);
    public static final SchemaSimpleType DURATION = SchemaTypes.addType("duration", false);
    public static final SchemaSimpleType ENTITY = SchemaTypes.addType("ENTITY", true);
    public static final SchemaSimpleType ENTITIES = SchemaTypes.addType("ENTITIES", false);
    public static final SchemaSimpleType FLOAT = SchemaTypes.addType("float", false);
    public static final SchemaSimpleType GDAY = SchemaTypes.addType("gDay", false);
    public static final SchemaSimpleType GMONTH = SchemaTypes.addType("gMonth", false);
    public static final SchemaSimpleType GMONTHDAY = SchemaTypes.addType("gMonthDay", false);
    public static final SchemaSimpleType GYEAR = SchemaTypes.addType("gYear", false);
    public static final SchemaSimpleType GYEARMONTH = SchemaTypes.addType("gYearMonth", false);
    public static final SchemaSimpleType HEX_BINARY = SchemaTypes.addType("hexBinary", false);
    public static final SchemaSimpleType ID = SchemaTypes.addType("ID", true);
    public static final SchemaSimpleType IDREF = SchemaTypes.addType("IDREF", true);
    public static final SchemaSimpleType IDREFS = SchemaTypes.addType("IDREFS", false);
    public static final SchemaSimpleType INT = SchemaTypes.addType("int", false);
    public static final SchemaSimpleType INTEGER = SchemaTypes.addType("integer", false);
    public static final SchemaSimpleType LANGUAGE = SchemaTypes.addType("language", true);
    public static final SchemaSimpleType LONG = SchemaTypes.addType("long", false);
    public static final SchemaSimpleType NAME = SchemaTypes.addType("Name", true);
    public static final SchemaSimpleType NEGATIVE_INTEGER = SchemaTypes.addType("negativeInteger", false);
    public static final SchemaSimpleType NON_NEGATIVE_INTEGER = SchemaTypes.addType("nonNegativeInteger", false);
    public static final SchemaSimpleType NON_POSITIVE_INTEGER = SchemaTypes.addType("nonPositiveInteger", false);
    public static final SchemaSimpleType NORMALIZED_STRING = SchemaTypes.addType("normalizedString", true);
    public static final SchemaSimpleType NCNAME = SchemaTypes.addType("NCName", true);
    public static final SchemaSimpleType NMTOKEN = SchemaTypes.addType("NMTOKEN", true);
    public static final SchemaSimpleType NMTOKENS = SchemaTypes.addType("NMTOKENS", false);
    public static final SchemaSimpleType NOTATION = SchemaTypes.addType("NOTATION", false);
    public static final SchemaSimpleType POSITIVE_INTEGER = SchemaTypes.addType("positiveInteger", false);
    public static final SchemaSimpleType QNAME = SchemaTypes.addType("QName", false);
    public static final SchemaSimpleType SHORT = SchemaTypes.addType("short", false);
    public static final SchemaSimpleType STRING = SchemaTypes.addType("string", true);
    public static final SchemaSimpleType TIME = SchemaTypes.addType("time", false);
    public static final SchemaSimpleType TOKEN = SchemaTypes.addType("token", true);
    public static final SchemaSimpleType UNSIGNED_BYTE = SchemaTypes.addType("unsignedByte", false);
    public static final SchemaSimpleType UNSIGNED_INT = SchemaTypes.addType("unsignedInt", false);
    public static final SchemaSimpleType UNSIGNED_LONG = SchemaTypes.addType("unsignedLong", false);
    public static final SchemaSimpleType UNSIGNED_SHORT = SchemaTypes.addType("unsignedShort", false);

    private static SchemaSimpleType addType(String name, boolean isstring) {
        SchemaSimpleType type = new SchemaSimpleType(name, isstring);
        s_schemaTypesMap.put(name, type);
        return type;
    }

    public static CommonTypeDefinition getSchemaType(String name) {
        return (CommonTypeDefinition)s_schemaTypesMap.get(name);
    }

    public static class SchemaSimpleType
    extends CommonTypeDefinition
    implements INamed {
        private final QName m_qname;
        private final boolean m_string;

        protected SchemaSimpleType(String name, boolean isstring) {
            super(37);
            this.m_qname = new QName("http://www.w3.org/2001/XMLSchema", name);
            this.m_string = isstring;
        }

        public boolean isComplexType() {
            return false;
        }

        public boolean isPredefinedType() {
            return true;
        }

        public String getName() {
            return this.m_qname.getName();
        }

        public QName getQName() {
            return this.m_qname;
        }

        public boolean isString() {
            return this.m_string;
        }
    }
}

