/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.custom.classes;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Member;
import com.thoughtworks.qdox.model.Type;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.model.ClassItemWrapper;
import org.jibx.custom.classes.IClassSourceLocator;
import org.jibx.util.IClass;
import org.jibx.util.IClassLocator;

public class ClassItemSourceWrapper
extends ClassItemWrapper {
    private boolean m_checkedSource;
    private Member m_itemSource;

    ClassItemSourceWrapper(IClass clas, ClassItem item) {
        super(clas, item);
    }

    private boolean matchSignature(JavaMethod method) {
        boolean match = true;
        JavaParameter[] parms = method.getParameters();
        if (parms.length == this.getArgumentCount()) {
            for (int j = 0; j < parms.length; ++j) {
                Type ptype = parms[j].getType();
                String type = ptype.getValue();
                int ndim = ptype.getDimensions();
                while (ndim-- > 0) {
                    type = type + "[]";
                }
                String comp = this.getArgumentType(j);
                if (comp.equals(type) || type.indexOf(46) < 0 && comp.endsWith('.' + type)) continue;
                match = false;
                break;
            }
        }
        return match;
    }

    private Member getItemSource() {
        if (!this.m_checkedSource) {
            IClassSourceLocator sloc;
            JavaClass jc;
            this.m_checkedSource = true;
            IClass clas = this.getContainingClass();
            IClassLocator loc = clas.getLocator();
            if (loc instanceof IClassSourceLocator && (jc = (sloc = (IClassSourceLocator)loc).getSourceInfo(clas.getName())) != null) {
                if (this.isMethod()) {
                    String mname = this.getName();
                    JavaMethod[] methods = jc.getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        JavaMethod method = methods[i];
                        if (!mname.equals(method.getName()) || !this.matchSignature(method)) continue;
                        this.m_itemSource = method;
                        break;
                    }
                } else {
                    this.m_itemSource = jc.getFieldByName(this.getName());
                }
            }
        }
        return this.m_itemSource;
    }

    private static String docText(String text) {
        if (text != null && (text = text.trim()).length() > 0) {
            return text;
        }
        return null;
    }

    public String getJavaDoc() {
        Member src = this.getItemSource();
        if (src == null) {
            return null;
        }
        if (this.isMethod()) {
            return ClassItemSourceWrapper.docText(((JavaMethod)src).getComment());
        }
        return ClassItemSourceWrapper.docText(((JavaField)src).getComment());
    }

    public String getReturnJavaDoc() {
        if (this.isMethod()) {
            DocletTag tag;
            JavaMethod jm = (JavaMethod)this.getItemSource();
            if (jm != null && (tag = jm.getTagByName("return")) != null) {
                return ClassItemSourceWrapper.docText(tag.getValue());
            }
            return null;
        }
        throw new IllegalStateException("Internal error: not a method");
    }

    public String getParameterJavaDoc(int index) {
        if (this.isMethod()) {
            JavaMethod jm = (JavaMethod)this.getItemSource();
            if (jm != null) {
                String name = jm.getParameters()[index].getName();
                DocletTag[] tags = jm.getTagsByName("param");
                for (int i = 0; i < tags.length; ++i) {
                    DocletTag tag = tags[i];
                    String[] parms = tag.getParameters();
                    if (parms == null || parms.length <= 0 || !name.equals(parms[0])) continue;
                    String text = tag.getValue().trim();
                    if (text.startsWith(name)) {
                        text = text.substring(name.length()).trim();
                    }
                    return ClassItemSourceWrapper.docText(text);
                }
            }
            return null;
        }
        throw new IllegalStateException("Internal error: not a method");
    }

    public String getParameterName(int index) {
        String name;
        JavaMethod jm = (JavaMethod)this.getItemSource();
        if (jm != null) {
            JavaParameter[] parameters = jm.getParameters();
            name = parameters[index].getName();
        } else {
            name = super.getParameterName(index);
        }
        return name;
    }

    public String getExceptionJavaDoc(int index) {
        if (this.isMethod()) {
            JavaMethod jm = (JavaMethod)this.getItemSource();
            if (jm != null) {
                String name = this.getExceptions()[index];
                DocletTag[] tags = jm.getTagsByName("throws");
                for (int i = 0; i < tags.length; ++i) {
                    DocletTag tag = tags[i];
                    String[] parms = tag.getParameters();
                    if (parms == null || parms.length <= 0 || !name.equals(parms[0])) continue;
                    return ClassItemSourceWrapper.docText(tag.getValue());
                }
            }
            return null;
        }
        throw new IllegalStateException("Internal error: not a method");
    }
}

