/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JavaType {
    private static final Map s_schemaTypesMap;
    public static final JavaType s_anyType;
    public static final JavaType s_anyAttributeType;
    private final String m_schemaName;
    private final String m_primitiveName;
    private final String m_fqName;
    private final String m_format;
    private final String m_serializerMethod;
    private final String m_deserializerMethod;
    private final String m_checkMethod;

    public JavaType(String slname, String pname, String fqname, String format, String ser, String dser, String check) {
        if (fqname == null) {
            throw new IllegalArgumentException("Internal error - object type required for definition");
        }
        this.m_schemaName = slname;
        this.m_primitiveName = pname;
        this.m_fqName = fqname;
        this.m_format = format;
        this.m_serializerMethod = ser;
        this.m_deserializerMethod = dser;
        this.m_checkMethod = check;
    }

    private JavaType(String slname, String pname, String fqname) {
        this(slname, pname, fqname, null, null, null, null);
    }

    private static void addType(String lname, String fqname, Map map) {
        JavaType.addType(lname, null, fqname, null, map);
    }

    private static void addType(String lname, String pname, String fqname, Map map) {
        JavaType.addType(lname, null, fqname, null, map);
    }

    private static void addType(String lname, String pname, String fqname, String check, Map map) {
        map.put(lname, new JavaType(lname, pname, fqname, null, null, null, check));
    }

    public static Map getTypeMap() {
        return s_schemaTypesMap;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public String getClassName() {
        return this.m_fqName;
    }

    public String getPrimitiveName() {
        return this.m_primitiveName;
    }

    public String getFormat() {
        return this.m_format;
    }

    public String getSerializerMethod() {
        return this.m_serializerMethod;
    }

    public String getDeserializerMethod() {
        return this.m_deserializerMethod;
    }

    public String getCheckMethod() {
        return this.m_checkMethod;
    }

    static {
        HashMap map = new HashMap();
        JavaType.addType("anySimpleType", "java.lang.String", map);
        JavaType.addType("anyURI", "java.lang.String", map);
        JavaType.addType("base64Binary", "byte[]", map);
        JavaType.addType("boolean", "boolean", "java.lang.Boolean", "org.jibx.runtime.Utility.ifBoolean", map);
        JavaType.addType("byte", "byte", "java.lang.Byte", "org.jibx.runtime.Utility.ifByte", map);
        JavaType.addType("date", null, "java.sql.Date", "org.jibx.runtime.Utility.ifDate", map);
        JavaType.addType("dateTime", null, "java.util.Date", "org.jibx.runtime.Utility.ifDateTime", map);
        JavaType.addType("decimal", "java.math.BigDecimal", map);
        JavaType.addType("double", "double", "java.lang.Double", map);
        JavaType.addType("duration", "java.lang.String", map);
        JavaType.addType("ENTITY", "java.lang.String", map);
        JavaType.addType("ENTITIES", "java.lang.String", map);
        JavaType.addType("float", "float", "java.lang.Float", map);
        JavaType.addType("gDay", "java.lang.String", map);
        JavaType.addType("gMonth", "java.lang.String", map);
        JavaType.addType("gMonthDay", "java.lang.String", map);
        JavaType.addType("gYear", "java.lang.String", map);
        JavaType.addType("gYearMonth", "java.lang.String", map);
        JavaType.addType("hexBinary", "byte[]", map);
        JavaType.addType("ID", "java.lang.String", map);
        JavaType.addType("IDREF", "java.lang.String", map);
        JavaType.addType("IDREFS", "java.lang.String", map);
        JavaType.addType("int", "int", "java.lang.Integer", "org.jibx.runtime.Utility.ifInt", map);
        JavaType.addType("integer", null, "java.math.BigInteger", "org.jibx.runtime.Utility.ifInteger", map);
        JavaType.addType("language", "java.lang.String", map);
        JavaType.addType("long", "long", "java.lang.Long", "org.jibx.runtime.Utility.ifLong", map);
        JavaType.addType("Name", "java.lang.String", map);
        JavaType.addType("negativeInteger", "java.lang.String", map);
        JavaType.addType("nonNegativeInteger", "java.lang.String", map);
        JavaType.addType("nonPositiveInteger", "java.lang.String", map);
        JavaType.addType("normalizedString", "java.lang.String", map);
        JavaType.addType("NCName", "java.lang.String", map);
        JavaType.addType("NMTOKEN", "java.lang.String", map);
        JavaType.addType("NMTOKENS", "java.lang.String", map);
        JavaType.addType("NOTATION", "java.lang.String", map);
        JavaType.addType("positiveInteger", "java.lang.String", map);
        JavaType.addType("QName", "org.jibx.runtime.QName", map);
        JavaType.addType("short", "short", "java.lang.Short", "org.jibx.runtime.Utility.ifShort", map);
        JavaType.addType("string", "java.lang.String", map);
        JavaType.addType("time", null, "java.sql.Time", "org.jibx.runtime.Utility.ifTime", map);
        JavaType.addType("token", "java.lang.String", map);
        JavaType.addType("unsignedByte", "java.lang.String", map);
        JavaType.addType("unsignedInt", "java.lang.String", map);
        JavaType.addType("unsignedLong", "java.lang.String", map);
        JavaType.addType("unsignedShort", "java.lang.String", map);
        s_schemaTypesMap = Collections.unmodifiableMap(map);
        s_anyType = new JavaType(null, null, "org.w3c.dom.Element");
        s_anyAttributeType = new JavaType(null, null, "org.w3c.dom.Attribute");
    }
}

