/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.wsdl.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jibx.binding.generator.BindGen;
import org.jibx.binding.generator.BindingMappingDetail;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.BindingHolder;
import org.jibx.binding.model.CollectionElement;
import org.jibx.binding.model.ElementBase;
import org.jibx.binding.model.IncludeElement;
import org.jibx.binding.model.MappingElement;
import org.jibx.binding.model.MappingElementBase;
import org.jibx.binding.model.ValidationProblem;
import org.jibx.custom.classes.ClassCustom;
import org.jibx.custom.classes.CustomBase;
import org.jibx.custom.classes.GlobalCustom;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.QName;
import org.jibx.schema.ISchemaListener;
import org.jibx.schema.ISchemaResolver;
import org.jibx.schema.MemoryResolver;
import org.jibx.schema.SchemaContextTracker;
import org.jibx.schema.SchemaHolder;
import org.jibx.schema.SchemaVisitor;
import org.jibx.schema.TreeWalker;
import org.jibx.schema.UrlResolver;
import org.jibx.schema.elements.AnnotationElement;
import org.jibx.schema.elements.CommonCompositorBase;
import org.jibx.schema.elements.CommonTypeDefinition;
import org.jibx.schema.elements.ComplexTypeElement;
import org.jibx.schema.elements.DocumentationElement;
import org.jibx.schema.elements.ElementElement;
import org.jibx.schema.elements.SchemaBase;
import org.jibx.schema.elements.SchemaElement;
import org.jibx.schema.elements.SchemaLocationBase;
import org.jibx.schema.elements.SequenceElement;
import org.jibx.schema.generator.MappingDetail;
import org.jibx.schema.generator.SchemaGen;
import org.jibx.schema.types.Count;
import org.jibx.schema.validation.ProblemConsoleLister;
import org.jibx.schema.validation.ProblemHandler;
import org.jibx.schema.validation.ProblemLogLister;
import org.jibx.schema.validation.ProblemMultiHandler;
import org.jibx.schema.validation.ValidationContext;
import org.jibx.schema.validation.ValidationUtils;
import org.jibx.util.DummyClassLocator;
import org.jibx.util.HolderBase;
import org.jibx.util.IClass;
import org.jibx.util.IClassLocator;
import org.jibx.util.InsertionOrderedSet;
import org.jibx.util.ResourceMatcher;
import org.jibx.util.Types;
import org.jibx.ws.wsdl.model.Definitions;
import org.jibx.ws.wsdl.model.Message;
import org.jibx.ws.wsdl.model.MessagePart;
import org.jibx.ws.wsdl.model.Operation;
import org.jibx.ws.wsdl.tools.WsdlGeneratorCommandLine;
import org.jibx.ws.wsdl.tools.WsdlWriter;
import org.jibx.ws.wsdl.tools.custom.FaultCustom;
import org.jibx.ws.wsdl.tools.custom.OperationCustom;
import org.jibx.ws.wsdl.tools.custom.ServiceCustom;
import org.jibx.ws.wsdl.tools.custom.ThrowsCustom;
import org.jibx.ws.wsdl.tools.custom.ValueCustom;
import org.jibx.ws.wsdl.tools.custom.WsdlCustom;
import org.w3c.dom.Node;

public class Jibx2Wsdl {
    private static final Logger s_logger = Logger.getLogger((String)Jibx2Wsdl.class.getName());
    private final WsdlGeneratorCommandLine m_generationParameters;
    private final BindGen m_bindingGenerator;
    private final SchemaGen m_schemaGenerator;
    private final Map m_uriSchemaMap;

    private Jibx2Wsdl(WsdlGeneratorCommandLine parms) {
        this.m_generationParameters = parms;
        GlobalCustom global = parms.getGlobal();
        this.m_bindingGenerator = new BindGen(global);
        this.m_schemaGenerator = new SchemaGen(parms.getLocator(), global, parms.getUriNames());
        this.m_uriSchemaMap = new HashMap();
    }

    private QName getMappingQName(String type, MappingElement mapping) {
        MappingDetail detail = this.m_schemaGenerator.getMappingDetail(mapping);
        if (detail == null) {
            throw new IllegalStateException("No mapping found for type " + type);
        }
        if (detail.isType()) {
            return detail.getTypeName();
        }
        throw new IllegalStateException("Need abstract mapping for type " + type);
    }

    private void addSchemaReference(QName qname, Map namemap, SchemaHolder holder) {
        if (qname != null && !"http://www.w3.org/2001/XMLSchema".equals(qname.getUri())) {
            SchemaHolder target = (SchemaHolder)namemap.get(qname);
            if (target == null) {
                target = (SchemaHolder)this.m_uriSchemaMap.get(qname.getUri());
            }
            holder.addReference((HolderBase)target);
        }
    }

    private ElementElement buildValueElement(ValueCustom parm, Map typemap, Map namemap, SchemaHolder hold) {
        List nodes;
        ElementElement elem = new ElementElement();
        if (!parm.isRequired()) {
            elem.setMinOccurs(Count.COUNT_ZERO);
        }
        String type = parm.getWorkingType();
        boolean repeat = false;
        boolean isref = false;
        String ptype = parm.getBoundType();
        QName tname = (QName)typemap.get(ptype);
        if (tname == null && (tname = Types.schemaType((String)type)) == null && (tname = Types.schemaType((String)ptype)) == null) {
            repeat = parm.isCollection();
            String usetype = ptype.endsWith(">") ? type : ptype;
            BindingMappingDetail detail = this.m_bindingGenerator.getMappingDetail(usetype);
            if (detail == null) {
                throw new IllegalStateException("No mapping found for type " + usetype);
            }
            if (detail.isExtended()) {
                elem.setRef(detail.getElementQName());
                isref = true;
            } else {
                MappingElement mapping = detail.getAbstractMapping();
                tname = mapping.getTypeQName();
                if (tname == null) {
                    tname = this.getMappingQName(usetype, mapping);
                }
            }
        }
        if (isref) {
            this.addSchemaReference(elem.getRef(), namemap, hold);
        } else {
            this.m_schemaGenerator.setElementType(tname, elem, hold);
            String ename = parm.getXmlName();
            if (ename == null) {
                ename = tname.getName();
            }
            elem.setName(ename);
            this.addSchemaReference(tname, namemap, hold);
        }
        if (repeat) {
            elem.setMaxOccurs(Count.COUNT_UNBOUNDED);
        }
        if ((nodes = parm.getDocumentation()) != null) {
            AnnotationElement anno = new AnnotationElement();
            DocumentationElement doc = new DocumentationElement();
            for (Node node : nodes) {
                doc.addContent(node);
            }
            anno.getItemsList().add((Object)doc);
            elem.setAnnotation(anno);
        }
        return elem;
    }

    private Definitions buildWSDL(ServiceCustom service, Map ptypemap, Map classelems, Map elemschemas, Map classtypes, Map typeschemas) {
        String wns = service.getWsdlNamespace();
        Definitions def = new Definitions(service.getPortTypeName(), service.getBindingName(), service.getServiceName(), service.getPortName(), "tns", wns);
        def.setServiceLocation(service.getServiceAddress());
        IClassLocator locator = this.m_generationParameters.getLocator();
        IClass info = locator.getClassInfo(service.getClassName());
        if (info != null) {
            List nodes = this.m_generationParameters.getWsdlCustom().getFormatter(service).docToNodes(info.getJavaDoc());
            def.setPortTypeDocumentation(nodes);
        }
        String sns = service.getNamespace();
        SchemaHolder holder = this.m_schemaGenerator.findSchema(sns);
        SchemaElement schema = holder.getSchema();
        ArrayList ops = service.getOperations();
        HashMap<String, Message> fltmap = new HashMap<String, Message>();
        InsertionOrderedSet imports = new InsertionOrderedSet();
        HashMap<String, QName> typemap = new HashMap<String, QName>(ptypemap);
        for (int i = 0; i < ops.size(); ++i) {
            OperationCustom odef = (OperationCustom)ops.get(i);
            String oname = odef.getOperationName();
            Operation op = new Operation(oname);
            op.setDocumentation(odef.getDocumentation());
            op.setSoapAction(odef.getSoapAction());
            Message rqmsg = new Message(odef.getRequestMessageName(), wns);
            op.addInputMessage(rqmsg);
            def.addMessage(rqmsg);
            QName rqelem = null;
            if (this.m_generationParameters.isDocLit()) {
                ArrayList parms = odef.getParameters();
                if (parms.size() > 0) {
                    ValueCustom parm = (ValueCustom)parms.get(0);
                    rqelem = (QName)classelems.get(parm.getWorkingType());
                    if (rqelem == null) {
                        ElementElement pelem = this.buildValueElement(parm, ptypemap, typeschemas, holder);
                        schema.getTopLevelChildren().add((Object)pelem);
                        rqelem = pelem.getQName();
                    } else {
                        imports.add(elemschemas.get(rqelem));
                        this.addSchemaReference(rqelem, elemschemas, holder);
                    }
                }
            } else {
                SequenceElement seq = new SequenceElement();
                ArrayList parms = odef.getParameters();
                for (int j = 0; j < parms.size(); ++j) {
                    QName tname;
                    ValueCustom parm = (ValueCustom)parms.get(j);
                    String type = parm.getWorkingType();
                    if (!typemap.containsKey(type) && (tname = (QName)classtypes.get(type)) != null) {
                        typemap.put(type, tname);
                        imports.add(typeschemas.get(tname));
                    }
                    ElementElement pelem = this.buildValueElement(parm, ptypemap, typeschemas, holder);
                    seq.getParticleList().add((Object)pelem);
                }
                ComplexTypeElement tdef = new ComplexTypeElement();
                tdef.setContentDefinition((CommonCompositorBase)seq);
                ElementElement elem = new ElementElement();
                String wname = odef.getRequestWrapperName();
                elem.setName(wname);
                elem.setTypeDefinition((CommonTypeDefinition)tdef);
                schema.getTopLevelChildren().add((Object)elem);
                rqelem = new QName(sns, wname);
            }
            if (rqelem != null) {
                MessagePart part = new MessagePart("part", rqelem);
                rqmsg.getParts().add(part);
                def.addNamespace(rqelem.getUri());
            }
            Message rsmsg = new Message(odef.getResponseMessageName(), wns);
            op.addOutputMessage(rsmsg);
            def.addMessage(rsmsg);
            ValueCustom rtrn = odef.getReturn();
            QName rselem = null;
            if (this.m_generationParameters.isDocLit()) {
                if (!"void".equals(rtrn.getWorkingType())) {
                    rselem = (QName)classelems.get(rtrn.getWorkingType());
                    if (rselem == null) {
                        ElementElement relem = this.buildValueElement(rtrn, ptypemap, typeschemas, holder);
                        schema.getTopLevelChildren().add((Object)relem);
                        rselem = relem.getQName();
                    } else {
                        imports.add(elemschemas.get(rselem));
                        this.addSchemaReference(rqelem, elemschemas, holder);
                    }
                }
            } else {
                SequenceElement seq = new SequenceElement();
                if (!"void".equals(rtrn.getWorkingType())) {
                    ElementElement relem = this.buildValueElement(rtrn, ptypemap, typeschemas, holder);
                    seq.getParticleList().add((Object)relem);
                }
                ComplexTypeElement tdef = new ComplexTypeElement();
                tdef.setContentDefinition((CommonCompositorBase)seq);
                ElementElement elem = new ElementElement();
                String wname = odef.getResponseWrapperName();
                elem.setName(wname);
                elem.setTypeDefinition((CommonTypeDefinition)tdef);
                schema.getTopLevelChildren().add((Object)elem);
                rselem = new QName(sns, wname);
            }
            if (rselem != null) {
                MessagePart part = new MessagePart("part", rselem);
                rsmsg.getParts().add(part);
                def.addNamespace(rselem.getUri());
            }
            ArrayList thrws = odef.getThrows();
            WsdlCustom wsdlcustom = this.m_generationParameters.getWsdlCustom();
            for (int j = 0; j < thrws.size(); ++j) {
                ThrowsCustom thrw = (ThrowsCustom)thrws.get(j);
                String type = thrw.getType();
                Message fmsg = (Message)fltmap.get(type);
                if (fmsg == null) {
                    FaultCustom fault = wsdlcustom.forceFaultCustomization(type);
                    QName fqname = new QName(sns, fault.getElementName());
                    MessagePart part = new MessagePart("fault", fqname);
                    fmsg = new Message(fault.getFaultName(), wns);
                    fmsg.getParts().add(part);
                    def.addMessage(fmsg);
                    def.addNamespace(sns);
                    BindingMappingDetail detail = this.m_bindingGenerator.getMappingDetail(fault.getDataType());
                    if (detail == null) {
                        throw new IllegalStateException("No mapping found for type " + type);
                    }
                    fltmap.put(type, fmsg);
                }
                op.addFaultMessage(fmsg);
            }
            def.addOperation(op);
        }
        if (holder.getReferences().size() > 0 || schema.getChildCount() > 0) {
            def.getSchemas().add(schema);
        }
        return def;
    }

    private void accumulateData(ValueCustom value, Map clasmap, Set dataset) {
        String type = value.getBoundType();
        if (!(dataset.contains(type) || clasmap.containsKey(type) || Types.isSimpleValue((String)type))) {
            String itype = value.getItemType();
            if (itype == null) {
                dataset.add(type);
            } else {
                dataset.add(itype);
            }
        }
    }

    public QName addCollectionBinding(boolean doclit, ValueCustom value, Map typemap, BindingHolder bind) {
        String ptype = value.getBoundType();
        QName qname = (QName)typemap.get(ptype);
        if (qname == null) {
            String type = value.getWorkingType();
            if (doclit || !type.endsWith("[]")) {
                MappingElement mapping = new MappingElement();
                mapping.setClassName(type);
                mapping.setAbstract(true);
                mapping.setCreateType(value.getCreateType());
                mapping.setFactoryName(value.getFactoryMethod());
                GlobalCustom global = this.m_generationParameters.getGlobal();
                IClass clas = global.getClassInfo(type);
                String suffix = clas.isImplements("Ljava/util/List;") ? "List" : (clas.isImplements("Ljava/util/Set;") ? "Set" : "Collection");
                String itype = value.getItemType();
                ClassCustom cust = global.addClassCustomization(itype);
                String name = cust.getSimpleName() + suffix;
                String uri = bind.getNamespace();
                qname = new QName(uri, CustomBase.convertName(name, 0));
                mapping.setTypeQName(qname);
                bind.addTypeNameReference(uri, (Object)uri);
                typemap.put(ptype, qname);
                CollectionElement coll = new CollectionElement();
                this.m_bindingGenerator.defineCollection(itype, value.getItemName(), coll, bind);
                mapping.addChild((Object)coll);
                bind.addMapping((MappingElementBase)mapping);
            }
        }
        return qname;
    }

    private List generate(List classes, List extras, Map classelems, Map elemschemas, Map classtypes, Map typeschemas, Collection exists) throws JiBXException, IOException {
        WsdlCustom wsdlcustom = this.m_generationParameters.getWsdlCustom();
        for (int i = 0; i < classes.size(); ++i) {
            String sclas = (String)classes.get(i);
            if (wsdlcustom.getServiceCustomization(sclas) != null) continue;
            wsdlcustom.addServiceCustomization(sclas);
        }
        InsertionOrderedSet abstrs = new InsertionOrderedSet();
        InsertionOrderedSet concrs = new InsertionOrderedSet();
        ArrayList<QName> qnames = new ArrayList<QName>();
        List services = wsdlcustom.getServices();
        boolean doclit = this.m_generationParameters.isDocLit();
        for (ServiceCustom service : services) {
            ArrayList ops = service.getOperations();
            for (OperationCustom op : ops) {
                ArrayList parms = op.getParameters();
                if (doclit && parms.size() > 1) {
                    System.err.println("Multiple parmameters not allowed for doc/lit: method " + op.getMethodName());
                }
                for (ValueCustom parm : parms) {
                    if (doclit) {
                        this.accumulateData(parm, classelems, (Set)concrs);
                        continue;
                    }
                    this.accumulateData(parm, classtypes, (Set)abstrs);
                }
                if (doclit) {
                    this.accumulateData(op.getReturn(), classelems, (Set)concrs);
                } else {
                    this.accumulateData(op.getReturn(), classtypes, (Set)abstrs);
                }
                ArrayList thrws = op.getThrows();
                for (int i = 0; i < thrws.size(); ++i) {
                    ThrowsCustom thrw = (ThrowsCustom)thrws.get(i);
                    FaultCustom fault = wsdlcustom.forceFaultCustomization(thrw.getType());
                    if (concrs.contains((Object)fault.getDataType())) continue;
                    concrs.add((Object)fault.getDataType());
                    qnames.add(new QName(service.getNamespace(), fault.getElementName()));
                }
            }
        }
        GlobalCustom global = this.m_generationParameters.getGlobal();
        for (int i = 0; i < extras.size(); ++i) {
            String type = (String)extras.get(i);
            if (concrs.contains((Object)type)) continue;
            concrs.add((Object)type);
            global.addClassCustomization(type);
            qnames.add(null);
        }
        this.m_bindingGenerator.generateSpecified(qnames, concrs.asList(), abstrs.asList());
        HashMap typemap = new HashMap();
        HashSet<String> unbounduris = new HashSet<String>();
        for (ServiceCustom service : services) {
            ArrayList ops = service.getOperations();
            String uri = service.getNamespace();
            BindingHolder hold = this.m_bindingGenerator.addBinding(uri, false);
            for (OperationCustom op : ops) {
                ArrayList parms = op.getParameters();
                for (ValueCustom parm : parms) {
                    if (parm.getItemType() == null) continue;
                    this.addCollectionBinding(doclit, parm, typemap, hold);
                }
                ValueCustom ret = op.getReturn();
                if (ret.getItemType() == null) continue;
                this.addCollectionBinding(doclit, ret, typemap, hold);
            }
            if (hold.getMappingCount() != 0) continue;
            unbounduris.add(uri);
        }
        this.m_bindingGenerator.addRootUris(unbounduris);
        String name = this.m_generationParameters.getBindingName();
        File path = this.m_generationParameters.getGeneratePath();
        BindingHolder rhold = this.m_bindingGenerator.finish(name);
        if (rhold.getBinding().topChildren().size() > 0) {
            List bindings = this.m_bindingGenerator.validateFiles(path, this.m_generationParameters.getLocator(), rhold);
            if (bindings == null) {
                return null;
            }
            ArrayList schemas = this.m_schemaGenerator.buildSchemas(bindings);
            for (SchemaHolder holder : schemas) {
                this.m_uriSchemaMap.put(holder.getNamespace(), holder);
            }
        }
        ArrayList<Definitions> wsdls = new ArrayList<Definitions>();
        Iterator iter = services.iterator();
        while (iter.hasNext()) {
            wsdls.add(this.buildWSDL((ServiceCustom)iter.next(), typemap, classelems, elemschemas, classtypes, typeschemas));
        }
        this.m_schemaGenerator.finishSchemas(exists);
        return wsdls;
    }

    private static void accumulateBindingDefinitions(BindingElement binding, Map elemmap, Map typemap) {
        ArrayList childs = binding.topChildren();
        for (int i = 0; i < childs.size(); ++i) {
            QName qname;
            ElementBase element = (ElementBase)childs.get(i);
            if (element.type() == 8) {
                Jibx2Wsdl.accumulateBindingDefinitions(((IncludeElement)element).getBinding(), elemmap, typemap);
                continue;
            }
            if (element.type() != 3) continue;
            MappingElementBase mapping = (MappingElementBase)element;
            String cname = mapping.getClassName();
            if (mapping.isAbstract()) {
                qname = mapping.getTypeQName();
                if (qname == null) continue;
                typemap.put(cname, qname);
                if (!s_logger.isDebugEnabled()) continue;
                s_logger.debug((Object)("Added class " + cname + " with type " + qname));
                continue;
            }
            qname = new QName(mapping.getNamespace().getUri(), mapping.getName());
            elemmap.put(cname, qname);
            if (!s_logger.isDebugEnabled()) continue;
            s_logger.debug((Object)("Added class " + cname + " with element " + qname));
        }
    }

    public static BindingElement processPregeneratedBinding(URL url, Map elemmap, Map typemap) throws JiBXException, IOException {
        String name = "";
        String path = url.getPath();
        if (path != null) {
            name = path;
            int split = Math.max(name.lastIndexOf(47), name.lastIndexOf(92));
            if (split > 0) {
                name = name.substring(split + 1);
            }
            split = name.lastIndexOf(46);
            name = name.substring(0, split);
        }
        org.jibx.binding.model.ValidationContext vctx = new org.jibx.binding.model.ValidationContext((IClassLocator)new DummyClassLocator());
        BindingElement binding = BindingElement.readBinding((InputStream)url.openStream(), (String)name, null, (boolean)true, (org.jibx.binding.model.ValidationContext)vctx);
        binding.setBaseUrl(url);
        vctx.setBindingRoot(binding);
        binding.runValidation(vctx);
        ArrayList probs = vctx.getProblems();
        if (probs.size() > 0) {
            for (int i = 0; i < probs.size(); ++i) {
                ValidationProblem prob = (ValidationProblem)probs.get(i);
                System.out.print(prob.getSeverity() >= 2 ? "Error: " : "Warning: ");
                System.out.println(prob.getDescription());
            }
            if (vctx.getErrorCount() > 0 || vctx.getFatalCount() > 0) {
                throw new JiBXException("Errors in binding");
            }
        }
        Jibx2Wsdl.accumulateBindingDefinitions(binding, elemmap, typemap);
        return binding;
    }

    public static void main(String[] args) throws JiBXException, IOException {
        WsdlGeneratorCommandLine parms = new WsdlGeneratorCommandLine();
        if (args.length > 0 && parms.processArgs(args)) {
            final HashSet resolves = new HashSet();
            List errors = ResourceMatcher.matchPaths((File)new File("."), null, (List)parms.getUseSchemas(), (ResourceMatcher.ReportMatch)new ResourceMatcher.ReportMatch(){

                public void foundMatch(String path, URL url) {
                    resolves.add(new UrlResolver(path, url));
                }
            });
            if (errors.size() > 0) {
                Iterator iter = errors.iterator();
                while (iter.hasNext()) {
                    System.err.println(iter.next());
                }
                System.exit(1);
            }
            ValidationContext vctx = new ValidationContext();
            ValidationUtils.load(resolves, null, (ValidationContext)vctx);
            ProblemMultiHandler handler = new ProblemMultiHandler();
            handler.addHandler((ProblemHandler)new ProblemConsoleLister());
            handler.addHandler((ProblemHandler)new ProblemLogLister(s_logger));
            if (vctx.reportProblems((ProblemHandler)handler)) {
                System.exit(2);
            }
            final HashMap elemschemas = new HashMap();
            final HashMap typeschemas = new HashMap();
            final HashSet<SchemaElement> exists = new HashSet<SchemaElement>();
            TreeWalker wlkr = new TreeWalker(null, (ISchemaListener)new SchemaContextTracker());
            Iterator iter = resolves.iterator();
            while (iter.hasNext()) {
                SchemaElement schema = vctx.getSchemaById(((ISchemaResolver)iter.next()).getId());
                exists.add(schema);
                final SchemaHolder holder = new SchemaHolder(schema);
                SchemaVisitor visitor = new SchemaVisitor(){

                    public boolean visit(SchemaBase node) {
                        return false;
                    }

                    public boolean visit(ComplexTypeElement node) {
                        typeschemas.put(node.getQName(), holder);
                        return false;
                    }

                    public boolean visit(ElementElement node) {
                        elemschemas.put(node.getQName(), holder);
                        return false;
                    }
                };
                wlkr.walkChildren((SchemaBase)schema, visitor);
            }
            final HashSet bindings = new HashSet();
            errors = ResourceMatcher.matchPaths((File)new File("."), null, (List)parms.getUseBindings(), (ResourceMatcher.ReportMatch)new ResourceMatcher.ReportMatch(){

                public void foundMatch(String path, URL url) {
                    bindings.add(url);
                }
            });
            if (errors.size() > 0) {
                Iterator iter2 = errors.iterator();
                while (iter2.hasNext()) {
                    System.err.println(iter2.next());
                }
                System.exit(3);
            }
            HashMap classelems = new HashMap();
            HashMap classtypes = new HashMap();
            for (URL url : bindings) {
                Jibx2Wsdl.processPregeneratedBinding(url, classelems, classtypes);
            }
            Jibx2Wsdl inst = new Jibx2Wsdl(parms);
            ArrayList<String> extras = new ArrayList<String>(parms.getExtraTypes());
            ArrayList classes = parms.getGlobal().getUnmarshalledClasses();
            for (int i = 0; i < classes.size(); ++i) {
                ClassCustom clas = (ClassCustom)classes.get(i);
                if (!clas.isForceMapping()) continue;
                extras.add(clas.getName());
            }
            List wsdls = inst.generate(parms.getExtraArgs(), extras, classelems, elemschemas, classtypes, typeschemas, exists);
            if (wsdls != null) {
                SchemaGen.writeSchemas(parms.getGeneratePath(), inst.m_uriSchemaMap.values());
                WsdlWriter writer = new WsdlWriter();
                for (Definitions def : wsdls) {
                    File file = new File(parms.getGeneratePath(), def.getServiceName() + ".wsdl");
                    writer.writeWSDL(def, new FileOutputStream(file));
                }
                final HashSet needschemas = new HashSet();
                SchemaVisitor visitor = new SchemaVisitor(){
                    private int m_existsDepth;

                    public void exit(SchemaElement node) {
                        if (exists.contains(node)) {
                            --this.m_existsDepth;
                        }
                    }

                    public boolean visit(SchemaBase node) {
                        return false;
                    }

                    public boolean visit(SchemaElement node) {
                        if (exists.contains(node)) {
                            ++this.m_existsDepth;
                        }
                        return true;
                    }

                    public boolean visit(SchemaLocationBase node) {
                        SchemaElement schema = node.getReferencedSchema();
                        if (needschemas.contains(schema)) {
                            return false;
                        }
                        if (this.m_existsDepth > 0 || exists.contains(schema)) {
                            needschemas.add(schema);
                        }
                        return true;
                    }
                };
                for (int i = 0; i < wsdls.size(); ++i) {
                    Definitions def = (Definitions)wsdls.get(i);
                    ArrayList schemas = def.getSchemas();
                    for (int j = 0; j < schemas.size(); ++j) {
                        wlkr.walkChildren((SchemaBase)schemas.get(0), visitor);
                    }
                }
                byte[] buff = new byte[4096];
                for (SchemaElement schema : needschemas) {
                    int actual;
                    UrlResolver resolver = (UrlResolver)schema.getResolver();
                    InputStream is = resolver.getUrl().openStream();
                    File file = new File(parms.getGeneratePath(), resolver.getName());
                    FileOutputStream os = new FileOutputStream(file);
                    while ((actual = is.read(buff)) > 0) {
                        os.write(buff, 0, actual);
                    }
                    schema.setResolver((ISchemaResolver)new MemoryResolver(resolver.getName()));
                }
            }
        } else {
            if (args.length > 0) {
                System.err.println("Terminating due to command line errors");
            } else {
                parms.printUsage();
            }
            System.exit(1);
        }
    }
}

