/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.core.TomcatException;

public final class Jdk12Interceptor
extends BaseInterceptor {
    private ContextManager cm;
    private int debug = 0;
    private boolean useThreadLoader = false;

    public void engineInit(ContextManager cm) {
        ClassLoader cl;
        if (this.useThreadLoader && (cl = cm.getParentClassLoader()) == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
            cm.setParentClassLoader(cl);
        }
    }

    private final void fixJDKContextClassLoader(Context ctx) {
        final ClassLoader cl = ctx.getServletLoader().getClassLoader();
        if (cl == null) {
            System.out.println("ERROR: Jdk12Interceptor: classloader==null");
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }

    public void postServletInit(Context ctx, ServletWrapper sw) throws TomcatException {
    }

    public int preService(Request request, Response response) {
        if (request.getContext() == null) {
            return 0;
        }
        this.fixJDKContextClassLoader(request.getContext());
        return 0;
    }

    public void preServletDestroy(Context ctx, ServletWrapper sw) throws TomcatException {
        this.fixJDKContextClassLoader(ctx);
    }

    public void preServletInit(Context ctx, ServletWrapper sw) throws TomcatException {
        this.fixJDKContextClassLoader(ctx);
    }

    public void setContextManager(ContextManager cm) {
        this.cm = cm;
    }

    public void setDebug(int i) {
        this.debug = i;
    }

    public void setUseThreadLoader(boolean t) {
        this.useThreadLoader = t;
    }
}

