/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.connector;

import java.io.IOException;
import org.apache.tomcat.core.BufferedServletInputStream;
import org.apache.tomcat.core.RequestImpl;
import org.apache.tomcat.service.connector.MsgBuffer;
import org.apache.tomcat.service.connector.MsgConnector;

public class Ajp13ConnectorRequest
extends RequestImpl {
    public static final int MAX_READ_SIZE = 8186;
    public static final byte JK_AJP13_GET_BODY_CHUNK = 6;
    public static final byte SC_A_CONTEXT = 1;
    public static final byte SC_A_SERVLET_PATH = 2;
    public static final byte SC_A_REMOTE_USER = 3;
    public static final byte SC_A_AUTH_TYPE = 4;
    public static final byte SC_A_QUERY_STRING = 5;
    public static final byte SC_A_JVM_ROUTE = 6;
    public static final byte SC_A_SSL_CERT = 7;
    public static final byte SC_A_SSL_CIPHER = 8;
    public static final byte SC_A_SSL_SESSION = 9;
    public static final byte SC_A_REQ_ATTRIBUTE = 10;
    public static final byte SC_A_ARE_DONE = -1;
    public static final String[] methodTransArray = new String[]{"OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE"};
    public static final String[] headerTransArray = new String[]{"accept", "accept-charset", "accept-encoding", "accept-language", "authorization", "connection", "content-type", "content-length", "cookie", "cookie2", "host", "pragma", "referer", "user-agent"};
    MsgConnector con;
    byte[] bodyBuff = new byte[8186];
    int blen;
    int pos;

    protected int decodeRequest(MsgBuffer msg) throws IOException {
        boolean isSSL = false;
        int hCount = 0;
        byte bsc = msg.getByte();
        this.method = methodTransArray[bsc - 1];
        this.protocol = msg.getString();
        this.requestURI = msg.getString();
        this.remoteAddr = msg.getString();
        this.remoteHost = msg.getString();
        this.serverName = msg.getString();
        this.serverPort = msg.getInt();
        bsc = msg.getByte();
        if (bsc != 0) {
            isSSL = true;
        }
        hCount = msg.getInt();
        int i = 0;
        while (i < hCount) {
            String hName = null;
            int isc = msg.peekInt();
            int hId = isc & 0xFF;
            if ((isc &= 0xFF00) == 40960) {
                msg.getInt();
                hName = headerTransArray[hId - 1];
            } else {
                hName = msg.getString().toLowerCase();
            }
            String hValue = msg.getString();
            this.headers.putHeader(hName, hValue);
            ++i;
        }
        bsc = msg.getByte();
        while (bsc != -1) {
            switch (bsc) {
                case 1: {
                    this.contextPath = msg.getString();
                    break;
                }
                case 2: {
                    System.out.println("SC_A_SERVLET_PATH not in use " + msg.getString());
                    break;
                }
                case 3: {
                    this.remoteUser = msg.getString();
                    break;
                }
                case 4: {
                    this.authType = msg.getString();
                    break;
                }
                case 5: {
                    this.queryString = msg.getString();
                    break;
                }
                case 6: {
                    this.jvmRoute = msg.getString();
                    break;
                }
                case 7: {
                    isSSL = true;
                    this.attributes.put("javax.servlet.request.X509Certificate", msg.getString());
                    break;
                }
                case 8: {
                    isSSL = true;
                    this.attributes.put("javax.servlet.request.cipher_suite", msg.getString());
                    break;
                }
                case 9: {
                    isSSL = true;
                    this.attributes.put("javax.servlet.request.ssl_session", msg.getString());
                    break;
                }
                case 10: {
                    this.attributes.put(msg.getString(), msg.getString());
                    break;
                }
                default: {
                    return -1;
                }
            }
            bsc = msg.getByte();
        }
        if (isSSL) {
            this.setScheme("https");
        }
        this.contentLength = this.headers.getIntHeader("content-length");
        this.contentType = this.headers.getHeader("content-type");
        ((BufferedServletInputStream)this.in).setLimit(this.contentLength);
        if (this.contentLength > 0) {
            int err = this.con.receive(msg);
            if (err < 0) {
                return -1;
            }
            this.blen = msg.peekInt();
            msg.getBytes(this.bodyBuff);
        }
        return 0;
    }

    public int doRead() throws IOException {
        if (this.pos >= this.blen && !this.refillReadBuffer()) {
            return -1;
        }
        return this.bodyBuff[this.pos++] & 0xFF;
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        if (this.pos >= this.blen && !this.refillReadBuffer()) {
            return -1;
        }
        int toCopy = len;
        while (toCopy > 0) {
            int bytesRemaining = this.blen - this.pos;
            if (bytesRemaining < 0) {
                bytesRemaining = 0;
            }
            int c = bytesRemaining < toCopy ? bytesRemaining : toCopy;
            System.arraycopy(this.bodyBuff, this.pos, b, off, c);
            off += c;
            this.pos += c;
            if ((toCopy -= c) > 0 && !this.refillReadBuffer()) break;
        }
        return len - toCopy;
    }

    public void recycle() {
        super.recycle();
        this.pos = 0;
    }

    public boolean refillReadBuffer() throws IOException {
        MsgBuffer msg = this.con.getMsgBuffer();
        msg.appendByte((byte)6);
        msg.appendInt(8186);
        this.con.send(msg);
        int err = this.con.receive(msg);
        if (err < 0) {
            throw new IOException();
        }
        this.blen = msg.peekInt();
        this.pos = 0;
        msg.getBytes(this.bodyBuff);
        return this.blen > 0;
    }

    public void setConnector(MsgConnector con) {
        this.con = con;
        this.pos = 0;
        this.in = new BufferedServletInputStream(this);
    }
}

