/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.serializer.FmtExprSPARQL;
import com.hp.hpl.jena.sparql.serializer.FmtTemplate;
import com.hp.hpl.jena.sparql.serializer.FormatterElement;
import com.hp.hpl.jena.sparql.serializer.FormatterTemplate;
import com.hp.hpl.jena.sparql.serializer.QuerySerializer;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.NodeToLabelMap;
import com.hp.hpl.jena.sparql.util.NodeToLabelMapBNode;
import java.io.OutputStream;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.logging.Log;

public class Serializer {
    static final int BLOCK_INDENT = 2;

    public static void serialize(Query query2, OutputStream out) {
        Serializer.serialize(query2, out, null);
    }

    public static void serialize(Query query2, OutputStream out, Syntax syntax) {
        IndentedWriter writer = new IndentedWriter(out);
        Serializer.serialize(query2, writer, syntax);
        writer.flush();
        try {
            out.flush();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static void serialize(Query query2, IndentedLineBuffer buff) {
        Syntax s = query2.getSyntax();
        if (s == null) {
            s = Syntax.defaultQuerySyntax;
        }
        Serializer.serialize(query2, buff, s);
    }

    public static void serialize(Query query2, IndentedLineBuffer buff, Syntax outSyntax) {
        Serializer._serialize(query2, buff, outSyntax);
    }

    public static void serialize(Query query2, IndentedWriter writer) {
        Syntax s = query2.getSyntax();
        if (s == null) {
            s = Syntax.defaultQuerySyntax;
        }
        Serializer.serialize(query2, writer, s);
    }

    public static void serialize(Query query2, IndentedWriter writer, Syntax outSyntax) {
        Serializer._serialize(query2, writer, outSyntax);
    }

    private static void _serialize(Query query2, IndentedWriter writer, Syntax outSyntax) {
        if (outSyntax == null) {
            outSyntax = Syntax.defaultQuerySyntax;
        }
        if (outSyntax.equals(Syntax.syntaxARQ)) {
            Serializer.serializeARQ(query2, writer);
            writer.flush();
            return;
        }
        if (outSyntax.equals(Syntax.syntaxSPARQL_10)) {
            Serializer.serializeSPARQL_10(query2, writer);
            writer.flush();
            return;
        }
        if (outSyntax.equals(Syntax.syntaxSPARQL_11)) {
            Serializer.serializeSPARQL_11(query2, writer);
            writer.flush();
            return;
        }
        Log.warn(Serializer.class, "Unknown syntax: " + outSyntax);
    }

    public static void serializeARQ(Query query2, Prologue p, IndentedWriter writer) {
        SerializationContext cxt1 = new SerializationContext(p, (NodeToLabelMap)new NodeToLabelMapBNode("b", false));
        SerializationContext cxt2 = new SerializationContext(p, (NodeToLabelMap)new NodeToLabelMapBNode("c", false));
        Prologue orig = null;
        if (query2 != p) {
            orig = query2.copy();
            query2.usePrologueFrom(p);
        }
        Serializer.serializeARQ(query2, writer, new FormatterElement(writer, cxt1), new FmtExprSPARQL(writer, cxt1), new FmtTemplate(writer, cxt2));
        if (orig != null) {
            query2.usePrologueFrom(orig);
        }
    }

    public static void serializeARQ(Query query2, IndentedWriter writer) {
        Serializer.serializeARQ(query2, query2, writer);
    }

    static void serializeARQ(Query query2, IndentedWriter writer, FormatterElement eltFmt, FmtExprSPARQL exprFmt, FormatterTemplate templateFmt) {
        QuerySerializer serilizer = new QuerySerializer(writer, eltFmt, exprFmt, templateFmt);
        query2.visit(serilizer);
    }

    public static void serializeSPARQL_10(Query query2, IndentedWriter writer) {
        Serializer.serializeARQ(query2, writer);
    }

    public static void serializeSPARQL_11(Query query2, IndentedWriter writer) {
        Serializer.serializeARQ(query2, writer);
    }
}

