/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client.servlet.sample;

import edu.uiuc.ncsa.myproxy.oa4mp.client.AssetResponse;
import edu.uiuc.ncsa.myproxy.oa4mp.client.servlet.ClientServlet;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SimpleReadyServlet
extends ClientServlet {
    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        this.info("2.a. Getting token and verifier.");
        String token = request.getParameter("oauth_token");
        String verifier = request.getParameter("oauth_verifier");
        if (token == null || verifier == null) {
            this.warn("2.a. The token is " + (token == null ? "null" : token) + " and the verifier is " + (verifier == null ? "null" : verifier));
            GeneralException ge = new GeneralException("Error: This servlet requires parameters for the token and verifier. It cannot be called directly.");
            request.setAttribute("exception", (Object)ge);
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)"/pages/client-error.jsp");
            return;
        }
        this.info("2.a Token and verifier found.");
        this.info("2.a. Getting the cert(s) from the service");
        String identifier = this.clearCookie(request, response);
        AssetResponse assetResponse = null;
        if (identifier == null) {
            String msg = "Error: no cookie found. Cannot save certificates";
            this.warn(msg);
            this.debug("No cookie found");
            assetResponse = this.getOA4MPService().getCert(token, verifier);
        } else {
            assetResponse = this.getOA4MPService().getCert(token, verifier, BasicIdentifier.newID((String)identifier));
        }
        X509Certificate cert = assetResponse.getX509Certificates()[0];
        this.info("2.b. Done! Displaying success page.");
        request.setAttribute("certSubject", (Object)cert.getSubjectDN());
        request.setAttribute("cert", (Object)CertUtil.toPEM((X509Certificate[])assetResponse.getX509Certificates()));
        request.setAttribute("username", (Object)assetResponse.getUsername());
        String contextPath = request.getContextPath();
        if (!contextPath.endsWith("/")) {
            contextPath = contextPath + "/";
        }
        request.setAttribute("action", (Object)contextPath);
        JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)"/pages/client-success.jsp");
        this.info("2.a. Completely finished with delegation.");
    }
}

