/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.admin;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.admin.CacheElementInfo;
import org.apache.jcs.admin.CacheRegionInfo;
import org.apache.jcs.admin.CountingOnlyOutputStream;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.jcs.engine.memory.MemoryCache;

public class JCSAdminBean {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$admin$JCSAdminBean == null ? (class$org$apache$jcs$admin$JCSAdminBean = JCSAdminBean.class$("org.apache.jcs.admin.JCSAdminBean")) : class$org$apache$jcs$admin$JCSAdminBean));
    private CompositeCacheManager cacheHub = CompositeCacheManager.getInstance();
    static /* synthetic */ Class class$org$apache$jcs$admin$JCSAdminBean;

    public LinkedList buildElementInfo(String cacheName) throws Exception {
        CompositeCache cache = this.cacheHub.getCache(cacheName);
        Object[] keys = cache.getMemoryCache().getKeyArray();
        try {
            Arrays.sort(keys);
        }
        catch (Exception e) {
            keys = cache.getMemoryCache().getKeyArray();
        }
        LinkedList<CacheElementInfo> records = new LinkedList<CacheElementInfo>();
        DateFormat format = DateFormat.getDateTimeInstance(3, 3);
        long now = System.currentTimeMillis();
        for (int i = 0; i < keys.length; ++i) {
            ICacheElement element = cache.getMemoryCache().getQuiet((Serializable)keys[i]);
            IElementAttributes attributes = element.getElementAttributes();
            CacheElementInfo elementInfo = new CacheElementInfo();
            elementInfo.key = String.valueOf(keys[i]);
            elementInfo.eternal = attributes.getIsEternal();
            elementInfo.maxLifeSeconds = attributes.getMaxLifeSeconds();
            elementInfo.createTime = format.format(new Date(attributes.getCreateTime()));
            elementInfo.expiresInSeconds = (now - attributes.getCreateTime() - attributes.getMaxLifeSeconds() * 1000L) / -1000L;
            records.add(elementInfo);
        }
        return records;
    }

    public LinkedList buildCacheInfo() throws Exception {
        Object[] cacheNames = this.cacheHub.getCacheNames();
        Arrays.sort(cacheNames);
        LinkedList<CacheRegionInfo> cacheInfo = new LinkedList<CacheRegionInfo>();
        for (int i = 0; i < cacheNames.length; ++i) {
            CompositeCache cache = this.cacheHub.getCache((String)cacheNames[i]);
            CacheRegionInfo regionInfo = new CacheRegionInfo();
            regionInfo.cache = cache;
            regionInfo.byteCount = this.getByteCount(cache);
            cacheInfo.add(regionInfo);
        }
        return cacheInfo;
    }

    public int getByteCount(CompositeCache cache) throws Exception {
        MemoryCache memCache = cache.getMemoryCache();
        Iterator iter = memCache.getIterator();
        CountingOnlyOutputStream counter = new CountingOnlyOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(counter);
        try {
            while (iter.hasNext()) {
                ICacheElement ce = (ICacheElement)((Map.Entry)iter.next()).getValue();
                out.writeObject(ce.getVal());
            }
        }
        catch (Exception e) {
            log.info((Object)("Problem getting byte count.  Likley cause is a non serilizable object." + e.getMessage()));
        }
        return counter.getCount() - 4;
    }

    public void clearAllRegions() throws IOException {
        String[] names = this.cacheHub.getCacheNames();
        for (int i = 0; i < names.length; ++i) {
            this.cacheHub.getCache(names[i]).removeAll();
        }
    }

    public void clearRegion(String cacheName) throws IOException {
        this.cacheHub.getCache(cacheName).removeAll();
    }

    public void removeItem(String cacheName, String key) throws IOException {
        this.cacheHub.getCache(cacheName).remove((Serializable)((Object)key));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

