/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver.stats;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.solver.stats.StatsResults;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.lib.MapUtils;

abstract class StatsCollectorBase<T> {
    private long count = 0L;
    private Map<T, Integer> predicates = new HashMap<T, Integer>(10000);
    private Map<T, Integer> types = new HashMap<T, Integer>(10000);
    private T typeTrigger;

    protected StatsCollectorBase(T typeTrigger) {
        this.typeTrigger = typeTrigger;
    }

    public void record(T g, T s, T p, T o) {
        ++this.count;
        MapUtils.increment(this.predicates, p);
        if (this.typeTrigger != null && this.typeTrigger.equals(p)) {
            MapUtils.increment(this.types, o);
        }
    }

    protected abstract Map<Node, Integer> convert(Map<T, Integer> var1);

    public StatsResults results() {
        return new StatsResults(this.convert(this.predicates), this.convert(this.types), this.count);
    }
}

