/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.core.BufferedServletOutputStream;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.facade.ServletWriterFacade;
import org.apache.tomcat.util.ByteBuffer;
import org.apache.tomcat.util.CookieTools;
import org.apache.tomcat.util.LocaleToCharsetMap;
import org.apache.tomcat.util.MimeHeaders;
import org.apache.tomcat.util.RequestUtil;
import org.apache.tomcat.util.StringManager;

public class ResponseImpl
implements Response {
    protected static StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    static final Locale DEFAULT_LOCALE = new Locale("en", "");
    protected Request request;
    protected HttpServletResponse responseFacade;
    protected Vector userCookies = new Vector();
    protected String contentType = "text/plain";
    protected String contentLanguage = null;
    protected String characterEncoding = "8859_1";
    protected String sessionId;
    protected int contentLength = -1;
    protected int status = 200;
    private Locale locale = DEFAULT_LOCALE;
    protected MimeHeaders headers = new MimeHeaders();
    protected BufferedServletOutputStream out = new BufferedServletOutputStream();
    protected PrintWriter writer;
    protected ByteBuffer bBuffer;
    protected boolean usingStream = false;
    protected boolean usingWriter = false;
    protected boolean started = false;
    protected boolean commited = false;
    boolean notIncluded = true;
    Exception errorException = null;
    String errorURI = null;
    StringBuffer body = null;

    public ResponseImpl() {
        this.out.setResponse(this);
    }

    public void addCookie(Cookie cookie) {
        if (this.isIncluded()) {
            return;
        }
        this.addHeader(CookieTools.getCookieHeaderName(cookie), CookieTools.getCookieHeaderValue(cookie));
        if (cookie.getVersion() == 1) {
            Cookie c0 = (Cookie)cookie.clone();
            c0.setVersion(0);
            this.addHeader(CookieTools.getCookieHeaderName(c0), CookieTools.getCookieHeaderValue(c0));
        }
        this.userCookies.addElement(cookie);
    }

    public void addHeader(String name, String value) {
        if (this.isIncluded()) {
            return;
        }
        if (!this.checkSpecialHeader(name, value)) {
            this.headers.addHeader(name, value);
        }
    }

    private boolean checkSpecialHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            this.setContentType(value);
            return true;
        }
        if (name.equalsIgnoreCase("Content-Length")) {
            try {
                int cL = Integer.parseInt(value);
                this.setContentLength(cL);
                return true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        name.equalsIgnoreCase("Content-Language");
        return false;
    }

    private static String constructLocalizedContentType(String type, Locale loc) {
        String charset;
        int semi = type.indexOf(";");
        if (semi != -1) {
            type = type.substring(0, semi);
        }
        if ((charset = LocaleToCharsetMap.getCharset(loc)) != null) {
            type = String.valueOf(type) + "; charset=" + charset;
        }
        return type;
    }

    public boolean containsHeader(String name) {
        return this.headers.containsHeader(name);
    }

    public void doWrite(byte[] buffer, int pos, int count) throws IOException {
        if (this.body == null) {
            this.body = new StringBuffer();
        }
        this.body.append(new String(buffer, pos, count, "8859_1"));
    }

    public void endHeaders() throws IOException {
        this.notifyEndHeaders();
    }

    public void finish() throws IOException {
        if (this.usingWriter && this.writer != null) {
            this.writer.flush();
            this.writer.close();
        }
        if (this.bBuffer != null) {
            this.bBuffer.flush();
            this.request.getContextManager().doAfterBody(this.request, this);
            return;
        }
        this.out.flush();
        this.out.reallyFlush();
        this.request.getContextManager().doAfterBody(this.request, this);
        this.out.close();
    }

    public void flushBuffer() throws IOException {
        if (this.usingWriter && this.writer != null) {
            this.writer.flush();
        }
        this.out.reallyFlush();
    }

    public StringBuffer getBody() {
        return this.body;
    }

    public int getBufferSize() {
        if (this.bBuffer != null) {
            return this.bBuffer.getBufferSize();
        }
        return this.out.getBufferSize();
    }

    public BufferedServletOutputStream getBufferedOutputStream() {
        return this.out;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Writer getConverter(ServletOutputStream outs) throws IOException {
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            return new OutputStreamWriter((OutputStream)outs);
        }
        try {
            return new OutputStreamWriter((OutputStream)outs, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("Unsuported encoding: " + encoding);
            return new OutputStreamWriter((OutputStream)outs);
        }
    }

    public Enumeration getCookies() {
        return this.userCookies.elements();
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    public String getErrorURI() {
        return this.errorURI;
    }

    public HttpServletResponse getFacade() {
        if (this.responseFacade == null) {
            Context ctx = this.request.getContext();
            if (ctx == null) {
                ctx = this.request.getContextManager().getContext("");
            }
            this.responseFacade = ctx.getFacadeManager().createHttpServletResponseFacade(this);
        }
        return this.responseFacade;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static String getMessage(int status) {
        return sm.getString("sc." + status);
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public ByteBuffer getOutputBuffer() {
        return this.bBuffer;
    }

    public ServletOutputStream getOutputStream() {
        this.started = true;
        return this.out;
    }

    public Request getRequest() {
        return this.request;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getStatus() {
        return this.status;
    }

    public PrintWriter getWriter() throws IOException {
        return this.getWriter(this.out);
    }

    public PrintWriter getWriter(ServletOutputStream outs) throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        this.started = true;
        this.usingWriter = true;
        this.writer = new ServletWriterFacade(this.getConverter(outs), this);
        return this.writer;
    }

    public boolean isBufferCommitted() {
        return this.commited;
    }

    public boolean isIncluded() {
        return this.notIncluded ^ true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isUsingStream() {
        return this.usingStream;
    }

    public boolean isUsingWriter() {
        return this.usingWriter;
    }

    public void notifyEndHeaders() throws IOException {
        if (this.request.getProtocol() == null) {
            return;
        }
        if (this.request.getContext() != null) {
            this.request.getContext().getContextManager().doBeforeBody(this.request, this);
        }
    }

    public void recycle() {
        this.userCookies.removeAllElements();
        this.contentType = "text/plain";
        this.contentLanguage = null;
        this.locale = DEFAULT_LOCALE;
        this.characterEncoding = "8859_1";
        this.contentLength = -1;
        this.status = 200;
        this.usingWriter = false;
        this.usingStream = false;
        this.sessionId = null;
        this.writer = null;
        this.started = false;
        this.commited = false;
        this.notIncluded = true;
        this.errorURI = null;
        this.body = null;
        if (this.out != null) {
            this.out.recycle();
        }
        if (this.bBuffer != null) {
            this.bBuffer.recycle();
        }
        this.headers.clear();
    }

    public void reset() throws IllegalStateException {
        if (this.isIncluded()) {
            return;
        }
        this.userCookies.removeAllElements();
        this.contentType = "text/plain";
        this.locale = DEFAULT_LOCALE;
        this.characterEncoding = "8859_1";
        this.contentLength = -1;
        this.status = 200;
        if (this.usingWriter && this.writer != null) {
            this.writer.flush();
        }
        this.body = null;
        this.out.reset();
        this.headers.clear();
    }

    public void resetBuffer() throws IllegalStateException {
        if (this.usingWriter && this.writer != null) {
            this.writer.flush();
        }
        this.out.reset();
    }

    public void setBufferCommitted(boolean v) {
        this.commited = v;
    }

    public void setBufferSize(int size) throws IllegalStateException {
        if (this.usingWriter && this.writer != null) {
            this.writer.flush();
        }
        if (this.bBuffer != null) {
            if (this.bBuffer.isContentWritten()) {
                throw new IllegalStateException(sm.getString("servletOutputStreamImpl.setbuffer.ise"));
            }
            this.bBuffer.setBufferSize(size);
            return;
        }
        if (this.out.isContentWritten()) {
            throw new IllegalStateException(sm.getString("servletOutputStreamImpl.setbuffer.ise"));
        }
        this.out.setBufferSize(size);
    }

    public void setContentLength(int contentLength) {
        if (this.isIncluded()) {
            return;
        }
        this.contentLength = contentLength;
        this.headers.putHeader("Content-Length", new Integer(contentLength).toString());
    }

    public void setContentType(String contentType) {
        if (this.isIncluded()) {
            return;
        }
        this.contentType = contentType;
        String encoding = RequestUtil.getCharsetFromContentType(contentType);
        if (encoding != null) {
            this.characterEncoding = encoding;
        }
        this.headers.putHeader("Content-Type", contentType);
    }

    public void setErrorException(Exception ex) {
        this.errorException = ex;
    }

    public void setErrorURI(String uri) {
        this.errorURI = uri;
    }

    public void setHeader(String name, String value) {
        if (this.isIncluded()) {
            return;
        }
        if (!this.checkSpecialHeader(name, value)) {
            this.headers.putHeader(name, value);
        }
    }

    public void setIncluded(boolean incl) {
        this.notIncluded = incl ^ true;
    }

    public void setLocale(Locale locale) {
        if (locale == null || this.isIncluded()) {
            return;
        }
        this.locale = locale;
        this.contentLanguage = locale.getLanguage();
        String newType = ResponseImpl.constructLocalizedContentType(this.contentType, locale);
        this.setContentType(newType);
        this.headers.putHeader("Content-Language", this.contentLanguage);
    }

    public void setOutputBuffer(ByteBuffer buf) {
        this.bBuffer = buf;
        if (buf != null) {
            buf.setParent(this);
        }
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setSessionId(String id) {
        if (this.notIncluded) {
            this.sessionId = id;
        }
    }

    public void setStatus(int status) {
        if (this.isIncluded()) {
            return;
        }
        this.status = status;
    }

    public void setUsingStream(boolean stream) {
        this.usingStream = stream;
    }

    public void setUsingWriter(boolean writer) {
        this.usingWriter = writer;
        this.out.setUsingWriter(true);
    }
}

