/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.util.xml.SaxContext;
import org.apache.tomcat.util.xml.XmlAction;
import org.apache.tomcat.util.xml.XmlMapper;
import org.xml.sax.AttributeList;

class MemoryRealm {
    Hashtable passwords = new Hashtable();
    Hashtable roles = new Hashtable();
    Hashtable userRoles = new Hashtable();
    Context ctx;
    int debug = 0;

    MemoryRealm(Context ctx) {
        this.ctx = ctx;
    }

    public void addRole(String role, String user) {
        Vector<String> users = (Vector<String>)this.roles.get(role);
        if (users == null) {
            users = new Vector<String>();
            this.roles.put(role, users);
        }
        users.addElement(user);
        Vector<String> thisUserRoles = (Vector<String>)this.userRoles.get(user);
        if (thisUserRoles == null) {
            thisUserRoles = new Vector<String>();
            this.userRoles.put(user, thisUserRoles);
        }
        thisUserRoles.addElement(role);
    }

    public void addUser(String name, String pass, String groups) {
        int comma;
        if (this.ctx.getDebug() > 0) {
            this.ctx.log("Add user " + name + " " + pass + " " + groups);
        }
        this.passwords.put(name, pass);
        groups = String.valueOf(groups) + ",";
        while ((comma = groups.indexOf(",")) >= 0) {
            this.addRole(groups.substring(0, comma).trim(), name);
            groups = groups.substring(comma + 1);
        }
    }

    public boolean checkPassword(String user, String pass) {
        if (user == null) {
            return false;
        }
        if (this.debug > 0) {
            this.ctx.log("check " + user + " " + pass + " " + this.passwords.get(user));
        }
        return pass.equals((String)this.passwords.get(user));
    }

    public Hashtable getRoles() {
        return this.roles;
    }

    public String[] getUserRoles(String user) {
        Vector v = (Vector)this.userRoles.get(user);
        if (v == null) {
            return null;
        }
        String[] roles = new String[v.size()];
        int i = 0;
        while (i < roles.length) {
            roles[i] = (String)v.elementAt(i);
            ++i;
        }
        return roles;
    }

    void readMemoryRealm(Context ctx) throws Exception {
        ContextManager cm = ctx.getContextManager();
        String home = cm.getHome();
        File f = new File(String.valueOf(home) + "/conf/tomcat-users.xml");
        if (!f.exists()) {
            ctx.log("File not found  " + f);
            return;
        }
        XmlMapper xh = new XmlMapper();
        if (ctx.getDebug() > 5) {
            xh.setDebug(2);
        }
        xh.addRule("tomcat-users/user", new XmlAction(){

            public void start(SaxContext sctx) throws Exception {
                int top = sctx.getTagCount() - 1;
                MemoryRealm mr = (MemoryRealm)sctx.getRoot();
                AttributeList attributes = sctx.getAttributeList(top);
                String user = attributes.getValue("name");
                String pass = attributes.getValue("password");
                String group = attributes.getValue("roles");
                mr.addUser(user, pass, group);
            }
        });
        xh.readXml(f, (Object)this);
    }

    public boolean userInRole(String user, String role) {
        Vector users = (Vector)this.roles.get(role);
        if (this.debug > 0) {
            this.ctx.log("check role " + user + " " + role + " ");
        }
        if (users == null) {
            return false;
        }
        return users.indexOf(user) >= 0;
    }
}

