/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transfer.fetch;

import gov.loc.repository.bagit.transfer.BagTransferException;
import gov.loc.repository.bagit.transfer.FetchContext;
import gov.loc.repository.bagit.transfer.FetchProtocol;
import gov.loc.repository.bagit.transfer.FetchedFileDestination;
import gov.loc.repository.bagit.transfer.FileFetcher;
import gov.loc.repository.bagit.transfer.fetch.FetchStreamCopier;
import gov.loc.repository.bagit.utilities.LongRunningOperationBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.text.MessageFormat;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;

public class HttpFetchProtocol
implements FetchProtocol {
    private static final Log log = LogFactory.getLog(HttpFetchProtocol.class);
    private ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager();
    private final DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)this.connectionManager);

    public HttpFetchProtocol() {
        this.client.getParams().setParameter("http.useragent", (Object)"BagIt Library Parallel Fetcher");
        this.connectionManager.setDefaultMaxPerRoute(Integer.MAX_VALUE);
        this.connectionManager.setMaxTotal(Integer.MAX_VALUE);
        this.client.getParams().setIntParameter("http.socket.timeout", 20000);
        this.client.getParams().setIntParameter("http.connection.timeout", 20000);
    }

    public void setRelaxedSsl(boolean relaxedSsl) {
        SSLSocketFactory sf;
        if (relaxedSsl) {
            try {
                sf = new SSLSocketFactory((TrustStrategy)new TrustSelfSignedStrategy(), SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
            catch (UnrecoverableKeyException e) {
                throw new RuntimeException(e);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        } else {
            sf = SSLSocketFactory.getSocketFactory();
        }
        Scheme https = new Scheme("https", 443, (SchemeSocketFactory)sf);
        this.connectionManager.getSchemeRegistry().register(https);
    }

    @Override
    public FileFetcher createFetcher(URI uri, Long size) throws BagTransferException {
        return new HttpFetcher();
    }

    private class HttpFetcher
    extends LongRunningOperationBase
    implements FileFetcher {
        private String username = null;
        private String password = null;

        private HttpFetcher() {
        }

        @Override
        public void initialize() throws BagTransferException {
        }

        @Override
        public void close() {
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void fetchFile(URI uri, Long size, FetchedFileDestination destination, FetchContext context) throws BagTransferException {
            log.trace((Object)MessageFormat.format("Fetching {0} to destination {1}", uri, destination.getFilepath()));
            HttpGet method = new HttpGet(uri);
            InputStream in = null;
            OutputStream out = null;
            try {
                if (this.username != null && this.password != null) {
                    HttpFetchProtocol.this.client.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
                    HttpClientParams.setAuthenticating((HttpParams)HttpFetchProtocol.this.client.getParams(), (boolean)true);
                    log.trace((Object)"Setting credentials for HttpClient.");
                } else {
                    HttpClientParams.setAuthenticating((HttpParams)HttpFetchProtocol.this.client.getParams(), (boolean)false);
                }
                log.trace((Object)"Executing GET.");
                HttpResponse resp = HttpFetchProtocol.this.client.execute((HttpUriRequest)method);
                log.trace((Object)MessageFormat.format("Server said: {0}", resp.getStatusLine().toString()));
                if (resp.getStatusLine() == null || resp.getStatusLine().getStatusCode() != 200) {
                    throw new BagTransferException(MessageFormat.format("Server returned code {0}: {1}", resp.getStatusLine() != null ? Integer.valueOf(resp.getStatusLine().getStatusCode()) : "nothing", uri));
                }
                log.trace((Object)"Opening destination.");
                out = destination.openOutputStream(false);
                in = resp.getEntity().getContent();
                log.trace((Object)"Copying from network to destination.");
                FetchStreamCopier copier = new FetchStreamCopier("Downloading", uri, size);
                this.delegateProgress(copier);
                long bytesCopied = copier.copy(in, out);
                log.trace((Object)MessageFormat.format("Successfully copied {0} bytes.", bytesCopied));
            }
            catch (IOException e) {
                try {
                    log.warn((Object)"Caught IOException.", (Throwable)e);
                    throw new BagTransferException(MessageFormat.format("Could not transfer URI: {0}", uri), e);
                    catch (RuntimeException e2) {
                        log.warn((Object)"Caught RuntimeException.", (Throwable)e2);
                        method.abort();
                        throw new BagTransferException(MessageFormat.format("Could not transfer URI: {0}", uri), e2);
                    }
                }
                catch (Throwable throwable) {
                    log.trace((Object)"Closing input stream.");
                    IOUtils.closeQuietly(in);
                    log.trace((Object)"Closing output stream.");
                    IOUtils.closeQuietly(out);
                    log.trace((Object)"Exiting finally clause.");
                    throw throwable;
                }
            }
            log.trace((Object)"Closing input stream.");
            IOUtils.closeQuietly((InputStream)in);
            log.trace((Object)"Closing output stream.");
            IOUtils.closeQuietly((OutputStream)out);
            log.trace((Object)"Exiting finally clause.");
        }

        @Override
        public void setPassword(String password) {
            this.password = password;
        }

        @Override
        public void setUsername(String username) {
            this.username = username;
        }
    }
}

