/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify.request;

import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.modify.request.Target;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import com.hp.hpl.jena.update.Update;

public abstract class UpdateBinaryOp
extends Update {
    private Target src;
    private Target dest;
    private boolean silent;

    protected UpdateBinaryOp(Target src, Target dest, boolean silent) {
        UpdateBinaryOp.checkTarget(src);
        UpdateBinaryOp.checkTarget(dest);
        this.src = src;
        this.dest = dest;
        this.silent = silent;
    }

    private static void checkTarget(Target target) {
        if (!target.isDefault() && !target.isOneNamedGraph()) {
            throw new ARQException("Illegal target: must identify a single graph: " + target);
        }
    }

    public Target getSrc() {
        return this.src;
    }

    public Target getDest() {
        return this.dest;
    }

    public boolean getSilent() {
        return this.silent;
    }

    @Override
    public final boolean equalTo(Update obj, NodeIsomorphismMap isoMap) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateBinaryOp other = (UpdateBinaryOp)obj;
        if (this.silent != other.silent) {
            return false;
        }
        return this.dest.equalTo(other.dest, isoMap) && this.src.equalTo(other.src, isoMap);
    }
}

