/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.servlet;

import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.delegation.servlet.AbstractConfigLoader;
import edu.uiuc.ncsa.security.storage.sql.mysql.MySQLConnectionPoolProvider;
import edu.uiuc.ncsa.security.storage.sql.postgres.PGConnectionPoolProvider;
import org.apache.commons.configuration.tree.ConfigurationNode;

public abstract class StorageConfigLoader<T extends AbstractEnvironment>
extends AbstractConfigLoader<T> {
    boolean disableDefaultStore = false;

    protected StorageConfigLoader(ConfigurationNode node, MyLoggingFacade logger) {
        super(node, logger);
    }

    protected StorageConfigLoader(ConfigurationNode node) {
        super(node, null);
    }

    protected boolean isDefaultStoreDisabled(boolean ... x) {
        if (x.length != 0) {
            this.disableDefaultStore = x[0];
        }
        return this.disableDefaultStore;
    }

    public MySQLConnectionPoolProvider getMySQLConnectionPoolProvider() {
        return this.getMySQLConnectionPoolProvider("oauth", "oauth");
    }

    public PGConnectionPoolProvider getPgConnectionPoolProvider() {
        return this.getPgConnectionPoolProvider("oauth", "oauth");
    }

    public MySQLConnectionPoolProvider getMySQLConnectionPoolProvider(String databaseName, String schema) {
        return new MySQLConnectionPoolProvider(databaseName, schema);
    }

    public PGConnectionPoolProvider getPgConnectionPoolProvider(String databaseName, String schema) {
        return new PGConnectionPoolProvider(databaseName, schema);
    }
}

