/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.DatasetChanges;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.atlas.lib.Pair;

class DatasetChangesCapture
implements DatasetChanges {
    private final List<Pair<QuadAction, Quad>> actions = new ArrayList<Pair<QuadAction, Quad>>();
    private final boolean captureAdd;
    private final boolean captureDelete;
    private final boolean captureNoAdd;
    private final boolean captureNoDelete;

    public DatasetChangesCapture() {
        this(true, true, false, false);
    }

    public DatasetChangesCapture(boolean recordNoOps) {
        this(true, true, recordNoOps, recordNoOps);
    }

    public DatasetChangesCapture(boolean captureAdd, boolean captureDelete, boolean captureNoAdd, boolean captureNoDelete) {
        this.captureAdd = captureAdd;
        this.captureDelete = captureDelete;
        this.captureNoAdd = captureNoAdd;
        this.captureNoDelete = captureNoDelete;
    }

    public List<Pair<QuadAction, Quad>> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    @Override
    public void start() {
    }

    @Override
    public void change(QuadAction qaction, Node g, Node s, Node p, Node o) {
        Quad q = new Quad(g, s, p, o);
        Pair<QuadAction, Quad> pair = Pair.create(qaction, q);
        switch (qaction) {
            case ADD: {
                if (!this.captureAdd) break;
                this.actions.add(pair);
                break;
            }
            case DELETE: {
                if (!this.captureDelete) break;
                this.actions.add(pair);
                break;
            }
            case NO_ADD: {
                if (!this.captureNoAdd) break;
                this.actions.add(pair);
                break;
            }
            case NO_DELETE: {
                if (!this.captureNoDelete) break;
                this.actions.add(pair);
            }
        }
    }

    @Override
    public void finish() {
    }
}

