/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.web;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.web.HttpCaptureResponse;
import org.apache.jena.riot.web.HttpResponseHandler;

public class HttpResponseLib {
    public static HttpResponseHandler httpDumpResponse = new HttpResponseHandler(){

        @Override
        public void handle(String baseIRI, HttpResponse response) {
            try {
                int l;
                HttpEntity entity = response.getEntity();
                ContentType ct = ContentType.get((HttpEntity)entity);
                System.out.println("Content-type: " + ct);
                System.out.println();
                InputStream in = entity.getContent();
                byte[] buffer = new byte[1024];
                while ((l = in.read(buffer)) != -1) {
                    System.out.print(new String(buffer, 0, l, "UTF-8"));
                }
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    };
    public static HttpResponseHandler nullResponse = new HttpResponseHandler(){

        @Override
        public void handle(String baseIRI, HttpResponse response) {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    };
    private static final Map<String, ResultsFormat> mapContentTypeToResultSet = new HashMap<String, ResultsFormat>();

    public static HttpCaptureResponse<Graph> graphHandler() {
        return new GraphReader();
    }

    public static ResultsFormat contentTypeToResultSet(String contentType) {
        return mapContentTypeToResultSet.get(contentType);
    }

    private static String contentType(HttpResponse response) {
        HttpEntity entity = response.getEntity();
        ContentType ct = ContentType.get((HttpEntity)entity);
        return ct.getMimeType();
    }

    static {
        mapContentTypeToResultSet.put("application/sparql-results+xml", ResultsFormat.FMT_RS_XML);
        mapContentTypeToResultSet.put("application/sparql-results+json", ResultsFormat.FMT_RS_JSON);
        mapContentTypeToResultSet.put("text/tab-separated-values", ResultsFormat.FMT_RS_TSV);
    }

    public static class HttpCaptureResponseResultSet
    implements HttpCaptureResponse<ResultSet> {
        ResultSet rs = null;

        @Override
        public void handle(String baseIRI, HttpResponse response) throws IOException {
            String ct = HttpResponseLib.contentType(response);
            ResultsFormat fmt = (ResultsFormat)mapContentTypeToResultSet.get(ct);
            InputStream in = response.getEntity().getContent();
            this.rs = ResultSetFactory.load(in, fmt);
            this.rs = ResultSetFactory.copyResults(this.rs);
        }

        @Override
        public ResultSet get() {
            return this.rs;
        }
    }

    static class GraphReader
    implements HttpCaptureResponse<Graph> {
        private Graph graph = null;

        GraphReader() {
        }

        @Override
        public final void handle(String baseIRI, HttpResponse response) {
            try {
                Graph g = GraphFactory.createDefaultGraph();
                HttpEntity entity = response.getEntity();
                String ct = HttpResponseLib.contentType(response);
                Lang lang = RDFLanguages.contentTypeToLang(ct);
                StreamRDF dest = StreamRDFLib.graph(g);
                InputStream in = entity.getContent();
                RDFDataMgr.parse(dest, in, baseIRI, lang);
                in.close();
                this.graph = g;
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
        }

        @Override
        public Graph get() {
            return this.graph;
        }
    }
}

