/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy;

import edu.uiuc.ncsa.myproxy.MyProxyLogon;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class MyProxyLogonGUI
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(MyProxyLogonGUI.class.getName());
    public static final String version = "1.4.7";
    protected MyProxyLogon myproxy = new MyProxyLogon();
    protected Properties properties;
    protected static final String PROPERTIES_PATH = "/.MyProxyLogon";
    protected JTextField usernameField;
    protected JLabel usernameFieldLabel;
    protected static final String usernameFieldString = "Username";
    protected static final String usernameFieldProperty = "Username";
    protected JPasswordField passwordField;
    protected JLabel passwordFieldLabel;
    protected static final String passwordFieldString = "Passphrase";
    protected static final String passwordFieldProperty = "Passphrase";
    protected static final String passwordInfoString = "Enter passphrase to logon.\n";
    protected JTextField crednameField;
    protected JLabel crednameFieldLabel;
    protected static final String crednameFieldString = "Credential Name";
    protected static final String crednameFieldProperty = "CredentialName";
    protected JTextField lifetimeField;
    protected JLabel lifetimeFieldLabel;
    protected static final String lifetimeFieldString = "Lifetime (hours)";
    protected static final String lifetimeFieldProperty = "Lifetime";
    protected JTextField hostnameField;
    protected JLabel hostnameFieldLabel;
    protected static final String hostnameFieldString = "Hostname";
    protected static final String hostnameFieldProperty = "Hostname";
    protected JTextField portField;
    protected JLabel portFieldLabel;
    protected static final String portFieldString = "Port";
    protected static final String portFieldProperty = "Port";
    protected JTextField outputField;
    protected JLabel outputFieldLabel;
    protected static final String outputFieldString = "Output";
    protected static final String outputFieldProperty = "Output";
    protected JCheckBox trustRootsCheckBox;
    protected static final String trustRootsProperty = "TrustRoots";
    protected static final String trustRootsPropertyYes = "yes";
    protected static final String trustRootsPropertyNo = "no";
    protected JButton button;
    protected static final String buttonFieldString = "Logon";
    protected JTextArea statusTextArea;
    protected JScrollPane statusScrollPane;

    public MyProxyLogonGUI() {
        String proxyLoc;
        this.loadProperties();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.usernameField = this.createField("Username", this.properties.getProperty("Username", this.myproxy.getUsername()));
        this.usernameFieldLabel = this.createLabel("Username", this.usernameField);
        this.usernameField.setToolTipText("Enter your MyProxy username.");
        this.passwordField = new JPasswordField(10);
        this.passwordField.setActionCommand("Passphrase");
        this.passwordField.addActionListener(this);
        this.passwordFieldLabel = this.createLabel("Passphrase", this.passwordField);
        this.passwordField.setToolTipText("Enter your MyProxy passphrase.");
        this.crednameField = this.createField(crednameFieldString, this.properties.getProperty(crednameFieldProperty, this.myproxy.getCredentialName()));
        this.crednameFieldLabel = this.createLabel(crednameFieldString, this.hostnameField);
        this.crednameField.setToolTipText("Optionally enter your MyProxy credential name.  Leave blank to use your default credential.");
        this.lifetimeField = this.createField(lifetimeFieldString, this.properties.getProperty(lifetimeFieldProperty, Integer.toString(this.myproxy.getLifetime() / 3600)));
        this.lifetimeFieldLabel = this.createLabel(lifetimeFieldString, this.lifetimeField);
        this.lifetimeField.setToolTipText("Enter the number of hours for your requested credentials to be valid.");
        this.hostnameField = this.createField("Hostname", this.properties.getProperty("Hostname", this.myproxy.getHost()));
        this.hostnameFieldLabel = this.createLabel("Hostname", this.hostnameField);
        this.hostnameField.setToolTipText("Enter the hostname of your MyProxy server (for example: myproxy.ncsa.uiuc.edu).");
        this.portField = this.createField("Port", this.properties.getProperty("Port", Integer.toString(this.myproxy.getPort())));
        this.portFieldLabel = this.createLabel("Port", this.portField);
        this.portField.setToolTipText("Enter the TCP port of your MyProxy server (usually 7512).");
        String trustRootPath = MyProxyLogon.getTrustRootPath();
        String existingTrustRootPath = MyProxyLogon.getExistingTrustRootPath();
        this.trustRootsCheckBox = new JCheckBox("Write trust roots to " + trustRootPath + ".");
        String trustRootsPropVal = this.properties.getProperty(trustRootsProperty);
        if (trustRootsPropVal != null && trustRootsPropVal.equals(trustRootsPropertyYes)) {
            this.trustRootsCheckBox.setSelected(true);
        } else if (trustRootsPropVal != null && trustRootsPropVal.equals(trustRootsPropertyNo)) {
            this.trustRootsCheckBox.setSelected(false);
        } else if (existingTrustRootPath == null || trustRootPath.equals(existingTrustRootPath)) {
            this.trustRootsCheckBox.setSelected(true);
        } else {
            this.trustRootsCheckBox.setSelected(false);
        }
        this.trustRootsCheckBox.setToolTipText("Check this box to download the latest CA certificates, certificate revocation lists, and CA signing policy files from MyProxy.");
        try {
            proxyLoc = MyProxyLogon.getProxyLocation();
        }
        catch (Exception e) {
            proxyLoc = "";
        }
        this.outputField = this.createField("Output", this.properties.getProperty("Output", proxyLoc));
        this.outputFieldLabel = this.createLabel("Output", this.outputField);
        this.outputField.setToolTipText("Enter the path to store your credential from MyProxy.  Leave blank if you don't want to retrieve a credential.");
        JLabel[] labels = new JLabel[]{this.usernameFieldLabel, this.passwordFieldLabel, this.crednameFieldLabel, this.lifetimeFieldLabel, this.hostnameFieldLabel, this.portFieldLabel, this.outputFieldLabel};
        JTextField[] textFields = new JTextField[]{this.usernameField, this.passwordField, this.crednameField, this.lifetimeField, this.hostnameField, this.portField, this.outputField};
        int numLabels = labels.length;
        c.anchor = 22;
        for (int i = 0; i < numLabels; ++i) {
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            this.add((Component)labels[i], c);
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            this.add((Component)textFields[i], c);
        }
        this.button = new JButton(buttonFieldString);
        this.button.setActionCommand(buttonFieldString);
        this.button.addActionListener(this);
        this.button.setVerticalTextPosition(0);
        this.button.setHorizontalTextPosition(0);
        this.button.setToolTipText("Press this button to logon to MyProxy.");
        this.statusTextArea = new JTextArea(4, 10);
        this.statusTextArea.setEditable(false);
        this.statusTextArea.setLineWrap(true);
        this.statusTextArea.setWrapStyleWord(true);
        this.statusScrollPane = new JScrollPane(this.statusTextArea);
        this.statusTextArea.setText(passwordInfoString);
        this.statusTextArea.setToolTipText("This area contains status messages.");
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)this.trustRootsCheckBox, c);
        this.add((Component)this.button, c);
        this.add((Component)this.statusScrollPane, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.verifyInput() && ("Passphrase".equals(e.getActionCommand()) || buttonFieldString.equals(e.getActionCommand()))) {
            this.logon();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MyProxyLogonGUI.createAndShowGUI();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logon() {
        try {
            this.myproxy.setUsername(this.usernameField.getText());
            this.myproxy.setPassphrase(new String(this.passwordField.getPassword()));
            if (this.crednameField.getText().length() > 0) {
                this.myproxy.setCredentialName(this.crednameField.getText());
            }
            this.myproxy.setLifetime(Integer.parseInt(this.lifetimeField.getText()) * 3600);
            this.myproxy.setHost(this.hostnameField.getText());
            this.myproxy.setPort(Integer.parseInt(this.portField.getText()));
            this.myproxy.requestTrustRoots(this.trustRootsCheckBox.isSelected());
            this.statusTextArea.setText("Connecting to " + this.myproxy.getHost() + "...\n");
            this.myproxy.connect();
            this.statusTextArea.setText("Logging on...\n");
            this.myproxy.logon();
            if (this.outputField.getText().length() == 0) {
                this.statusTextArea.setText("Logon successful.\n");
            } else {
                this.statusTextArea.setText("Getting credentials...\n");
                this.myproxy.getCredentials();
                this.statusTextArea.setText("Writing credentials...\n");
                this.myproxy.saveCredentialsToFile(this.outputField.getText());
                this.statusTextArea.setText("Credentials written to " + this.outputField.getText() + ".\n");
            }
            if (this.trustRootsCheckBox.isSelected() && this.myproxy.writeTrustRoots()) {
                this.statusTextArea.append("Trust roots written to " + MyProxyLogon.getTrustRootPath() + ".\n");
            }
            this.saveProperties();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.statusTextArea.append("Error: " + exception.getMessage());
        }
        finally {
            try {
                this.myproxy.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    protected void saveProperties() {
        try {
            FileOutputStream out = new FileOutputStream(System.getProperty("user.home") + PROPERTIES_PATH);
            this.properties.setProperty("Username", this.usernameField.getText());
            this.properties.setProperty(crednameFieldProperty, this.crednameField.getText());
            this.properties.setProperty(lifetimeFieldProperty, this.lifetimeField.getText());
            this.properties.setProperty("Hostname", this.hostnameField.getText());
            this.properties.setProperty("Port", this.portField.getText());
            this.properties.setProperty("Output", this.outputField.getText());
            this.properties.setProperty(trustRootsProperty, this.trustRootsCheckBox.isSelected() ? trustRootsPropertyYes : trustRootsPropertyNo);
            this.properties.store(out, MyProxyLogonGUI.class.getName());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void loadProperties() {
        try {
            this.properties = new Properties();
            FileInputStream in = new FileInputStream(System.getProperty("user.home") + PROPERTIES_PATH);
            this.properties.load(in);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createAndShowGUI() {
        JFrame frame = new JFrame("MyProxyLogon 1.4.7");
        MyProxyLogonGUI gui = new MyProxyLogonGUI();
        frame.setDefaultCloseOperation(3);
        frame.add(gui);
        frame.pack();
        gui.passwordField.requestFocusInWindow();
        frame.setVisible(true);
    }

    private JTextField createField(String fieldString, String text) {
        JTextField field = new JTextField(10);
        field.setActionCommand(fieldString);
        field.addActionListener(this);
        if (text != null) {
            field.setText(text);
            field.setColumns(text.length());
        }
        return field;
    }

    private JLabel createLabel(String fieldString, Component c) {
        JLabel label = new JLabel(fieldString + ": ");
        label.setLabelFor(c);
        return label;
    }

    private boolean verifyInput() {
        File f;
        boolean valid = true;
        StringBuffer infoString = new StringBuffer();
        if (this.usernameField.getText().length() == 0) {
            valid = false;
            infoString.append("Please specify a username.\n");
        }
        if (this.passwordField.getPassword().length == 0) {
            valid = false;
            infoString.append(passwordInfoString);
        } else {
            int n = this.passwordField.getPassword().length;
            this.myproxy.getClass();
            if (n < 6) {
                valid = false;
                infoString.append("Passphrase must be at least ");
                this.myproxy.getClass();
                infoString.append(Integer.toString(6));
                infoString.append(" characters in length.\n");
            }
        }
        if (this.lifetimeField.getText().length() == 0) {
            this.lifetimeField.setText(Integer.toString(this.myproxy.getLifetime() / 3600));
        }
        try {
            Integer.parseInt(this.lifetimeField.getText());
        }
        catch (NumberFormatException e) {
            valid = false;
            infoString.append("Lifetime is not a valid integer.\n");
        }
        if (this.hostnameField.getText().length() == 0) {
            valid = false;
            infoString.append("Please specify a MyProxy server hostname.\n");
        } else {
            try {
                InetAddress.getByName(this.hostnameField.getText());
            }
            catch (UnknownHostException e) {
                valid = false;
                infoString.append("Hostname \"");
                infoString.append(this.hostnameField.getText());
                infoString.append("\" is not valid. Please specify a valid MyProxy server hostname.\n");
            }
        }
        if (this.portField.getText().length() == 0) {
            this.portField.setText(Integer.toString(this.myproxy.getPort()));
        }
        try {
            Integer.parseInt(this.portField.getText());
        }
        catch (NumberFormatException e) {
            valid = false;
            infoString.append("Port is not a valid integer. Please specify a valid MyProxy server port (default: 7512).\n");
        }
        if (this.outputField.getText().length() > 0 && (f = new File(this.outputField.getText())).exists() && !f.canWrite()) {
            valid = false;
            infoString.append(f.getPath());
            infoString.append(" exists and is not writable. Please specify a valid output file or specify no output path to only perform authentication.\n");
        }
        this.statusTextArea.setText(new String(infoString));
        return valid;
    }
}

