/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function.user;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprTransform;
import com.hp.hpl.jena.sparql.expr.ExprTransformSubstitute;
import com.hp.hpl.jena.sparql.expr.ExprTransformer;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.Function;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.function.user.UserDefinedFunctionDefinition;
import com.hp.hpl.jena.sparql.sse.builders.ExprBuildException;
import java.util.HashMap;
import java.util.List;

public class UserDefinedFunction
extends UserDefinedFunctionDefinition
implements Function {
    private Expr actualExpr;

    public UserDefinedFunction(UserDefinedFunctionDefinition def) {
        super(def.getUri(), def.getBaseExpr(), def.getArgList());
    }

    public UserDefinedFunction(String url, Expr e2, List<Var> argList) {
        super(url, e2, argList);
    }

    @Override
    public void build(String uri, ExprList args) {
        if (uri == null || !uri.equals(this.getUri())) {
            throw new ExprBuildException("Incorrect URI passed to build() call, expected <" + this.getUri() + "> but got <" + uri + ">");
        }
        if (this.getArgList().size() != args.size()) {
            throw new ExprBuildException("Incorrect number of arguments for user defined <" + this.getUri() + "> function");
        }
        HashMap<String, Expr> substitutions = new HashMap<String, Expr>();
        for (int i = 0; i < this.getArgList().size(); ++i) {
            substitutions.put(this.getArgList().get(i).getVarName(), args.get(i));
        }
        this.actualExpr = ExprTransformer.transform((ExprTransform)new ExprTransformSubstitute(substitutions), this.getBaseExpr());
    }

    @Override
    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        return this.actualExpr.eval(binding, env);
    }

    public Expr getActualExpr() {
        return this.actualExpr;
    }
}

