/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify.request;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.modify.request.QuadAccSink;
import org.apache.jena.atlas.lib.Sink;

public class QuadDataAccSink
extends QuadAccSink {
    public QuadDataAccSink(Sink<Quad> sink) {
        super(sink);
    }

    @Override
    protected void check(Triple t) {
        if (Var.isVar(this.getGraph())) {
            throw new QueryParseException("Variables not permitted in data quad", -1, -1);
        }
        if (Var.isVar(t.getSubject()) || Var.isVar(t.getPredicate()) || Var.isVar(t.getObject())) {
            throw new QueryParseException("Variables not permitted in data quad", -1, -1);
        }
        if (t.getSubject().isLiteral()) {
            throw new QueryParseException("Literals not allowed as subjects in data", -1, -1);
        }
    }

    @Override
    protected void check(Quad quad) {
        if (Var.isVar(quad.getGraph()) || Var.isVar(quad.getSubject()) || Var.isVar(quad.getPredicate()) || Var.isVar(quad.getObject())) {
            throw new QueryParseException("Variables not permitted in data quad", -1, -1);
        }
        if (quad.getSubject().isLiteral()) {
            throw new QueryParseException("Literals not allowed as subjects in quad data", -1, -1);
        }
    }
}

