/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrInputField
implements Iterable<Object>,
Serializable {
    String name;
    Object value = null;
    float boost = 1.0f;

    public SolrInputField(String n) {
        this.name = n;
    }

    public void setValue(Object v, float b) {
        this.boost = b;
        if (v instanceof Object[]) {
            Object[] arr = (Object[])v;
            ArrayList<Object> c = new ArrayList<Object>(arr.length);
            for (Object o : arr) {
                c.add(o);
            }
            this.value = c;
        } else {
            this.value = v;
        }
    }

    public void addValue(Object v, float b) {
        if (this.value == null) {
            this.setValue(v, b);
            return;
        }
        this.boost *= b;
        ArrayList<Object> vals = null;
        if (this.value instanceof Collection) {
            vals = (ArrayList<Object>)this.value;
        } else {
            vals = new ArrayList<Object>(3);
            vals.add(this.value);
            this.value = vals;
        }
        if (v instanceof Iterable) {
            for (Object o : (Iterable)v) {
                vals.add(o);
            }
        } else if (v instanceof Object[]) {
            for (Object o : (Object[])v) {
                vals.add(o);
            }
        } else {
            vals.add(v);
        }
    }

    public Object getFirstValue() {
        if (this.value instanceof Collection) {
            Collection c = (Collection)this.value;
            if (c.size() > 0) {
                return c.iterator().next();
            }
            return null;
        }
        return this.value;
    }

    public Object getValue() {
        return this.value;
    }

    public Collection<Object> getValues() {
        if (this.value instanceof Collection) {
            return (Collection)this.value;
        }
        if (this.value != null) {
            ArrayList<Object> vals = new ArrayList<Object>(1);
            vals.add(this.value);
            return vals;
        }
        return null;
    }

    public int getValueCount() {
        if (this.value instanceof Collection) {
            return ((Collection)this.value).size();
        }
        return this.value == null ? 0 : 1;
    }

    public float getBoost() {
        return this.boost;
    }

    public void setBoost(float boost) {
        this.boost = boost;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.value instanceof Collection) {
            return ((Collection)this.value).iterator();
        }
        return new Iterator<Object>(){
            boolean nxt;
            {
                this.nxt = SolrInputField.this.value != null;
            }

            @Override
            public boolean hasNext() {
                return this.nxt;
            }

            @Override
            public Object next() {
                this.nxt = false;
                return SolrInputField.this.value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return this.name + "(" + this.boost + ")={" + this.value + "}";
    }
}

