/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.quality;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.datamanager.parser.DataPackage;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.quality.QualityReport;

public class QualityCheck {
    public static Log log = LogFactory.getLog(QualityCheck.class);
    private static final QualityType defaultQualityType = QualityType.congruency;
    private static final StatusType defaultStatusType = StatusType.error;
    private static final String defaultSystem = "knb";
    private String identifier = "";
    private String name = "";
    private String description = "";
    private String emlPath = "";
    private String expected = "";
    private String explanation = "";
    private String found = "";
    private Enum<QualityType> qualityType;
    private Enum<StatusType> statusType;
    private Enum<Status> status;
    private String system;
    private String suggestion = "";
    private String reference = "";

    public QualityCheck() {
    }

    public QualityCheck(String identifier) {
        this.identifier = identifier;
        this.qualityType = defaultQualityType;
        this.statusType = defaultStatusType;
        this.system = defaultSystem;
    }

    public QualityCheck(String identifier, QualityCheck qualityCheckTemplate) {
        this(identifier);
        if (qualityCheckTemplate != null) {
            String system = qualityCheckTemplate.getSystem();
            this.setSystem(system);
            String name = qualityCheckTemplate.getName();
            this.setName(name);
            Enum<QualityType> qualityType = qualityCheckTemplate.getQualityType();
            this.setQualityType(qualityType);
            Enum<StatusType> statusType = qualityCheckTemplate.getStatusType();
            this.setStatusType(statusType);
            String description = qualityCheckTemplate.getDescription();
            this.setDescription(description);
            String expected = qualityCheckTemplate.getExpected();
            this.setExpected(expected);
            String found = qualityCheckTemplate.getFound();
            this.setFound(found);
            Enum<Status> status = qualityCheckTemplate.getStatus();
            this.setStatus(status);
            String explanation = qualityCheckTemplate.getExplanation();
            this.setExplanation(explanation);
            String suggestion = qualityCheckTemplate.getSuggestion();
            this.setSuggestion(suggestion);
            String reference = qualityCheckTemplate.getReference();
            this.setReference(reference);
        } else {
            String errorMessage = "No template found for quality check: '" + identifier + "'.";
            log.error((Object)errorMessage);
        }
    }

    public static boolean shouldRunQualityCheck(DataPackage dataPackage, QualityCheck qualityCheck) {
        boolean shouldRunCheck = QualityReport.isQualityReporting() != false && dataPackage != null && qualityCheck != null && qualityCheck.isIncluded();
        return shouldRunCheck;
    }

    public static boolean shouldRunQualityCheck(Entity entity, QualityCheck qualityCheck) {
        boolean shouldRunCheck = QualityReport.isQualityReporting() != false && entity != null && qualityCheck != null && qualityCheck.isIncluded();
        return shouldRunCheck;
    }

    public boolean equals(QualityCheck qualityCheck) {
        return this.description.equals(qualityCheck.getDescription()) && this.emlPath.equals(qualityCheck.getEmlPath()) && this.expected.equals(qualityCheck.getExpected()) && this.explanation.equals(qualityCheck.getExplanation()) && this.found.equals(qualityCheck.getFound()) && this.identifier.equals(qualityCheck.getIdentifier()) && this.name.equals(qualityCheck.getName()) && this.reference.equals(qualityCheck.getReference()) && this.status.equals(qualityCheck.getStatus()) && this.suggestion.equals(qualityCheck.getSuggestion());
    }

    public String toXML() {
        String xmlString = null;
        StringBuffer xmlStringBuffer = new StringBuffer("");
        String indent = "  ";
        String qualityTypeStr = null;
        String statusTypeStr = null;
        String statusStr = null;
        if (this.qualityType != null) {
            qualityTypeStr = this.qualityType.toString();
        }
        if (this.statusType != null) {
            statusTypeStr = this.statusType.toString();
        }
        if (this.status != null) {
            statusStr = this.status.toString();
        }
        xmlStringBuffer.append("    <qualityCheck qualityType=\"" + qualityTypeStr + "\"" + " system=\"" + this.system + "\"" + " statusType=\"" + statusTypeStr + "\" >\n");
        xmlStringBuffer.append("      <identifier>" + this.identifier + "</identifier>\n");
        xmlStringBuffer.append("      <name>" + this.name + "</name>\n");
        xmlStringBuffer.append("      <description>" + this.description + "</description>\n");
        xmlStringBuffer.append("      <expected>" + this.expected + "</expected>\n");
        xmlStringBuffer.append("      <found>" + this.found + "</found>\n");
        xmlStringBuffer.append("      <status>" + statusStr + "</status>\n");
        xmlStringBuffer.append("      <explanation>" + this.explanation + "</explanation>\n");
        xmlStringBuffer.append("      <suggestion>" + this.suggestion + "</suggestion>\n");
        xmlStringBuffer.append("      <reference>" + this.reference + "</reference>\n");
        xmlStringBuffer.append("    </qualityCheck>\n");
        xmlString = xmlStringBuffer.toString();
        return xmlString;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEmlPath() {
        return this.emlPath;
    }

    public String getExpected() {
        return this.expected;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String getFound() {
        return this.found;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public Enum<QualityType> getQualityType() {
        return this.qualityType;
    }

    public String getReference() {
        return this.reference;
    }

    public Enum<Status> getStatus() {
        return this.status;
    }

    public Enum<StatusType> getStatusType() {
        return this.statusType;
    }

    public String getSystem() {
        return this.system;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public boolean hasErrorStatus() {
        return this.status == Status.error;
    }

    public boolean isIncluded() {
        boolean isIncluded = QualityReport.isIncludeSystem(this.system);
        return isIncluded;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEmlPath(String emlPath) {
        this.emlPath = emlPath;
    }

    public void setExpected(String expected) {
        this.expected = expected;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public void setFailedStatus() {
        if (this.statusType == null) {
            this.statusType = defaultStatusType;
        }
        if (this.statusType.equals((Object)StatusType.error)) {
            this.status = Status.error;
        } else if (this.statusType.equals((Object)StatusType.info)) {
            this.status = Status.info;
        } else if (this.statusType.equals((Object)StatusType.warn)) {
            this.status = Status.warn;
        }
    }

    public void setFound(String found) {
        this.found = found;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setQualityType(Enum<QualityType> qualityType) {
        this.qualityType = qualityType;
    }

    public void setQualityType(String qualityType) {
        if (qualityType != null) {
            if (qualityType.equals("congruency")) {
                this.qualityType = QualityType.congruency;
            } else if (qualityType.equals("data")) {
                this.qualityType = QualityType.data;
            } else if (qualityType.equals("metadata")) {
                this.qualityType = QualityType.metadata;
            }
        }
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public void setStatus(Enum<Status> status) {
        this.status = status;
    }

    public void setStatus(String status) {
        if (status != null) {
            if (status.equals("valid")) {
                this.status = Status.valid;
            } else if (status.equals("info")) {
                this.status = Status.info;
            } else if (status.equals("warn")) {
                this.status = Status.warn;
            } else if (status.equals("error")) {
                this.status = Status.error;
            } else if (status.equals("notChecked")) {
                this.status = Status.notChecked;
            }
        }
    }

    public void setStatusType(Enum<StatusType> statusType) {
        this.statusType = statusType;
    }

    public void setStatusType(String statusType) {
        if (statusType != null) {
            if (statusType.equals("info")) {
                this.statusType = StatusType.info;
            } else if (statusType.equals("warn")) {
                this.statusType = StatusType.warn;
            } else if (statusType.equals("error")) {
                this.statusType = StatusType.error;
            }
        }
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public static enum Status {
        valid,
        info,
        warn,
        error,
        notChecked;

    }

    public static enum StatusType {
        info,
        warn,
        error;

    }

    public static enum QualityType {
        congruency,
        data,
        metadata;

    }
}

