/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.concurrentmap;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MapLoader;
import com.hazelcast.core.MapLoaderLifecycleSupport;
import com.hazelcast.core.MapStore;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class MapStoreWrapper
implements MapStore {
    private final MapLoader mapLoader;
    private final MapStore mapStore;
    private final Object initLock = new Object();
    private final boolean shouldInitialize;
    private final Object impl;
    private final HazelcastInstance hazelcastInstance;
    private final Properties properties;
    private final String mapName;
    private volatile boolean initialized = false;
    private final AtomicBoolean enabled = new AtomicBoolean(false);

    public MapStoreWrapper(Object impl, HazelcastInstance hazelcastInstance, Properties properties, String mapName, boolean enabled) {
        this.impl = impl;
        this.hazelcastInstance = hazelcastInstance;
        this.properties = properties;
        this.mapName = mapName;
        MapLoader loader = null;
        MapStore store = null;
        if (impl instanceof MapStore) {
            store = (MapStore)impl;
        }
        if (impl instanceof MapLoader) {
            loader = (MapLoader)impl;
        }
        this.mapLoader = loader;
        this.mapStore = store;
        this.shouldInitialize = impl instanceof MapLoaderLifecycleSupport;
        this.enabled.set(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkInit() {
        if (this.shouldInitialize && !this.initialized) {
            Object object = this.initLock;
            synchronized (object) {
                if (!this.initialized) {
                    ((MapLoaderLifecycleSupport)this.impl).init(this.hazelcastInstance, this.properties, this.mapName);
                    this.initialized = true;
                }
            }
        }
    }

    public void setEnabled(boolean enable) {
        this.enabled.set(enable);
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.shouldInitialize && this.initialized) {
            Object object = this.initLock;
            synchronized (object) {
                if (this.initialized) {
                    ((MapLoaderLifecycleSupport)this.impl).destroy();
                    this.initialized = false;
                }
            }
        }
    }

    public boolean isMapStore() {
        return this.mapStore != null;
    }

    public boolean isMapLoader() {
        return this.mapLoader != null;
    }

    public void delete(Object key) {
        if (this.enabled.get()) {
            this.checkInit();
            this.mapStore.delete(key);
        }
    }

    public void store(Object key, Object value) {
        if (this.enabled.get()) {
            this.checkInit();
            this.mapStore.store(key, value);
        }
    }

    public void storeAll(Map map) {
        if (this.enabled.get()) {
            this.checkInit();
            this.mapStore.storeAll(map);
        }
    }

    public void deleteAll(Collection keys) {
        if (this.enabled.get()) {
            this.checkInit();
            this.mapStore.deleteAll(keys);
        }
    }

    public Set loadAllKeys() {
        if (this.enabled.get()) {
            this.checkInit();
            return this.mapLoader.loadAllKeys();
        }
        return null;
    }

    public Object load(Object key) {
        if (this.enabled.get()) {
            this.checkInit();
            return this.mapLoader.load(key);
        }
        return null;
    }

    public Map loadAll(Collection keys) {
        if (this.enabled.get()) {
            this.checkInit();
            return this.mapLoader.loadAll(keys);
        }
        return null;
    }

    public String toString() {
        return "MapStoreWrapper{mapName='" + this.mapName + '\'' + ", mapStore=" + this.mapStore + ", mapLoader=" + this.mapLoader + '}';
    }
}

