/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Vector;
import org.ecoinformatics.datamanager.database.DataNotMatchingMetadataException;
import org.ecoinformatics.datamanager.database.TextDataReader;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.quality.QualityCheck;
import org.ecoinformatics.datamanager.quality.QualityReport;

public class DelimitedReader
extends TextDataReader {
    private String data;
    private InputStreamReader dataReader;
    private Vector[] lines;
    private Vector linesVector;
    private int numHeaderLines;
    private int numRecords;
    private boolean stripHeader = false;
    private int numCols;
    private String fieldDelimiter;
    private String lineEnding;
    private boolean collapseDelimiters = false;
    private int numFooterLines = 0;
    private Vector footerBuffer = new Vector();
    private boolean initializedFooterBuffer = false;
    private int headLineNumberCount = 0;
    private String quoteCharacter = null;
    private String literalCharacter = null;
    private boolean includeLiteralCharacter = false;
    private Entity entity;
    private int rowCounter = 0;
    private int tooFewFieldsCounter = 0;
    private int tooManyFieldsCounter = 0;
    private final int FIELD_CHECK_MAX = 5;
    private int examineRecordDelimiterCounter = 0;
    private final int EXAMINE_RECORD_DELIMITER_MAX = 1;
    private boolean hasRecordDelimiter = false;

    public DelimitedReader(String data, int numCols, String delimiter, int numHeaderLines, String lineEnding, int numRecords) throws Exception {
        this.numHeaderLines = numHeaderLines;
        this.data = data;
        this.numCols = numCols;
        this.numRecords = numRecords;
        this.fieldDelimiter = DelimitedReader.unescapeDelimiter(delimiter);
        this.lineEnding = DelimitedReader.unescapeDelimiter(lineEnding);
        this.linesVector = new Vector();
        int begin = 0;
        int end = 0;
        while (end < data.length()) {
            String line;
            end = data.indexOf(this.lineEnding, begin);
            if (end == -1) {
                end = data.length();
            }
            if (!(line = data.substring(begin, end)).trim().equals("")) {
                Vector<String> v = this.splitDelimitedRowStringIntoVector(line);
                this.linesVector.add(v);
            }
            begin = end + this.lineEnding.length();
        }
        int records = this.linesVector.size();
        if (records != this.numRecords) {
            this.numRecords = records;
        }
        this.lines = new Vector[records];
        for (int k = 0; k < records; ++k) {
            this.lines[k] = (Vector)this.linesVector.get(k);
        }
    }

    public DelimitedReader(InputStream dataStream, int numCols, String fieldDelimiter, int numHeaderLines, String lineEnding, int numRecords, boolean stripHeader) {
        this.dataReader = new InputStreamReader(dataStream);
        this.numHeaderLines = numHeaderLines;
        this.numCols = numCols;
        this.numRecords = numRecords;
        this.fieldDelimiter = DelimitedReader.unescapeDelimiter(fieldDelimiter);
        this.lineEnding = DelimitedReader.unescapeDelimiter(lineEnding);
        this.stripHeader = stripHeader;
    }

    public static String unescapeDelimiter(String delimiter) {
        String newDelimiter = delimiter;
        if (delimiter == null) {
            newDelimiter = "\n";
        } else if (delimiter.equals("\\t")) {
            newDelimiter = "\t";
        } else if (delimiter.equals("\\n")) {
            newDelimiter = "\n";
        } else if (delimiter.equals("\\r")) {
            newDelimiter = "\r";
        } else if (delimiter.equals("\\r\\n")) {
            newDelimiter = "\r\n";
        } else if (delimiter.startsWith("#")) {
            if (delimiter.equalsIgnoreCase("#x0D#x0A")) {
                newDelimiter = "\r\n";
            } else if (delimiter.equalsIgnoreCase("#x0A#x0D")) {
                newDelimiter = "\n\r";
            } else if (delimiter.equalsIgnoreCase("#x0A#x0A")) {
                newDelimiter = "\n\n";
            } else if (delimiter.equalsIgnoreCase("#x0D#x0D")) {
                newDelimiter = "\r\r";
            } else {
                String digits = delimiter.substring(1, delimiter.length());
                int radix = 10;
                if (digits.startsWith("x")) {
                    radix = 16;
                    digits = digits.substring(1, digits.length());
                }
                newDelimiter = DelimitedReader.transformDigitsToCharString(radix, digits);
            }
        } else if (delimiter.startsWith("0x") || delimiter.startsWith("0X")) {
            if (delimiter.equalsIgnoreCase("0x0D0x0A")) {
                newDelimiter = "\r\n";
            } else if (delimiter.equalsIgnoreCase("0x0A0x0D")) {
                newDelimiter = "\n\r";
            } else if (delimiter.equalsIgnoreCase("0x0A0x0A")) {
                newDelimiter = "\n\n";
            } else if (delimiter.equalsIgnoreCase("0x0D0x0D")) {
                newDelimiter = "\r\r";
            } else {
                int radix = 16;
                String digits = delimiter.substring(2, delimiter.length());
                newDelimiter = DelimitedReader.transformDigitsToCharString(radix, digits);
            }
        }
        return newDelimiter;
    }

    private static String transformDigitsToCharString(int radix, String digits) {
        if (digits == null) {
            return null;
        }
        try {
            Integer integer = Integer.valueOf(digits, radix);
            int anInt = integer;
            char aChar = (char)anInt;
            String newDelimiter = Character.toString(aChar);
            return newDelimiter;
        }
        catch (NumberFormatException e) {
            String message = "An error occurred while attempting to unescape a delimiter value. Error transforming string '" + digits + "' to an integer value.";
            NumberFormatException newException = new NumberFormatException(message);
            throw newException;
        }
    }

    public void setInputStream(InputStream dataStream) {
        this.dataReader = new InputStreamReader(dataStream);
    }

    public void setCollapseDelimiters(boolean collapseDelimiters) {
        this.collapseDelimiters = collapseDelimiters;
    }

    public void setNumFooterLines(int numFooterLines) {
        this.numFooterLines = numFooterLines;
    }

    public void setQuoteCharacter(String quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
    }

    public void setLiteralCharacter(String literalCharacter) {
        this.literalCharacter = literalCharacter;
    }

    @Override
    public Vector<String> getOneRowDataVector() throws Exception {
        ++this.rowCounter;
        if (!this.initializedFooterBuffer) {
            for (int i = 0; i < this.numFooterLines; ++i) {
                String rowData = this.readOneRowDataString();
                this.footerBuffer.add(rowData);
            }
            if (this.numFooterLines == 0) {
                String rowData = this.readOneRowDataString();
                this.footerBuffer.add(rowData);
            }
            this.initializedFooterBuffer = true;
        }
        String nextRowData = this.readOneRowDataString();
        String oneRowDataString = null;
        Vector<String> oneRowDataVector = new Vector<String>();
        if (nextRowData != null) {
            oneRowDataString = (String)this.footerBuffer.remove(0);
            this.reIndexFooterBufferVector();
            this.footerBuffer.add(nextRowData);
        } else if (this.numFooterLines == 0 && !this.footerBuffer.isEmpty()) {
            oneRowDataString = (String)this.footerBuffer.remove(0);
        }
        if (oneRowDataString != null) {
            if (this.examineRecordDelimiterCounter < 1) {
                String examineRecordDelimiter = "examineRecordDelimiter";
                QualityCheck examineRecordDelimiterTemplate = QualityReport.getQualityCheckTemplate(examineRecordDelimiter);
                QualityCheck examineRecordDelimiterQualityCheck = new QualityCheck(examineRecordDelimiter, examineRecordDelimiterTemplate);
                if (QualityCheck.shouldRunQualityCheck(this.entity, examineRecordDelimiterQualityCheck)) {
                    String found = null;
                    String metadataRecordDelimiter = this.entity.getMetadataRecordDelimiter();
                    ArrayList<String> otherDelimiters = this.otherRecordDelimiters(oneRowDataString, metadataRecordDelimiter);
                    boolean hasSuggestedDelimiter = this.entity.isSuggestedRecordDelimiter(metadataRecordDelimiter);
                    if (otherDelimiters.size() > 0) {
                        found = "Other potential record delimiters were found in the first row: ";
                        found = found + otherDelimiters.toString();
                        examineRecordDelimiterQualityCheck.setFailedStatus();
                    } else {
                        found = "No other potential record delimiters were detected.";
                        if (hasSuggestedDelimiter) {
                            found = found + " A valid record delimiter was previously detected";
                            examineRecordDelimiterQualityCheck.setStatus(QualityCheck.Status.valid);
                            examineRecordDelimiterQualityCheck.setExplanation("");
                            examineRecordDelimiterQualityCheck.setSuggestion("");
                        } else {
                            examineRecordDelimiterQualityCheck.setFailedStatus();
                        }
                    }
                    examineRecordDelimiterQualityCheck.setFound(found);
                    this.entity.addQualityCheck(examineRecordDelimiterQualityCheck);
                }
                ++this.examineRecordDelimiterCounter;
            }
            oneRowDataVector = this.splitDelimitedRowStringIntoVector(oneRowDataString);
        }
        return oneRowDataVector;
    }

    private ArrayList<String> otherRecordDelimiters(String row, String metadataDelimiter) {
        boolean foundTwoCharacterDelimiter = false;
        ArrayList<String> otherDelimiters = new ArrayList<String>();
        if (row != null) {
            if (row.contains("\r\n")) {
                foundTwoCharacterDelimiter = true;
                if (metadataDelimiter == null || !metadataDelimiter.equals("\\r\\n") && !metadataDelimiter.equalsIgnoreCase("#x0D#x0A")) {
                    otherDelimiters.add("\\r\\n");
                }
            }
            if (row.contains("\n") && (metadataDelimiter == null || !metadataDelimiter.equals("\\n") && !metadataDelimiter.equalsIgnoreCase("#x0A") && !foundTwoCharacterDelimiter)) {
                otherDelimiters.add("\\n");
            }
            if (row.contains("\r") && (metadataDelimiter == null || !metadataDelimiter.equals("\\r") && !metadataDelimiter.equalsIgnoreCase("#x0D") && !foundTwoCharacterDelimiter)) {
                otherDelimiters.add("\\r");
            }
        }
        return otherDelimiters;
    }

    private String readOneRowDataString() {
        StringBuffer rowBuffer = new StringBuffer();
        String rowDataString = null;
        if (this.dataReader != null) {
            try {
                int singleCharacter = this.dataReader.read();
                while (singleCharacter != -1) {
                    char aCharacter = (char)singleCharacter;
                    rowBuffer.append(aCharacter);
                    if (rowBuffer.indexOf(this.lineEnding) != -1) {
                        if (!this.stripHeader || this.numHeaderLines <= 0 || this.headLineNumberCount >= this.numHeaderLines) {
                            rowDataString = rowBuffer.toString();
                            this.hasRecordDelimiter = true;
                            break;
                        }
                        rowBuffer = null;
                        rowBuffer = new StringBuffer();
                        ++this.headLineNumberCount;
                    }
                    singleCharacter = this.dataReader.read();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                rowBuffer = new StringBuffer();
            }
        }
        if (rowBuffer != null && rowBuffer.length() > 0) {
            rowDataString = rowBuffer.toString();
        }
        return rowDataString;
    }

    private void reIndexFooterBufferVector() {
        for (int i = 0; i < this.numFooterLines - 2; ++i) {
            Vector element = (Vector)this.footerBuffer.elementAt(i + 1);
            this.footerBuffer.add(i, element);
        }
    }

    private Vector<String> splitDelimitedRowStringIntoVector(String data) throws Exception {
        Vector<String> rowVector = new Vector<String>();
        if (data == null) {
            return rowVector;
        }
        String[] stringArray = null;
        if (this.quoteCharacter == null && this.literalCharacter == null) {
            String delimiterRegex = this.collapseDelimiters ? this.fieldDelimiter + "+" : this.fieldDelimiter;
            stringArray = data.split(delimiterRegex);
        } else {
            stringArray = this.processQuoteCharacterOneRowData(data);
        }
        if (stringArray != null) {
            QualityCheck tooManyTemplate;
            String tooManyIdentifier;
            QualityCheck tooManyCheck;
            int columnCounter = stringArray.length;
            String tooFewIdentifier = "tooFewFields";
            QualityCheck tooFewTemplate = QualityReport.getQualityCheckTemplate(tooFewIdentifier);
            QualityCheck tooFewCheck = new QualityCheck(tooFewIdentifier, tooFewTemplate);
            if (QualityCheck.shouldRunQualityCheck(this.entity, tooFewCheck)) {
                boolean foundTooFew;
                boolean bl = foundTooFew = columnCounter < this.numCols;
                if (foundTooFew) {
                    String expected = this.numCols + " " + this.fieldWord(this.numCols);
                    tooFewCheck.setExpected(expected);
                    String found = columnCounter + " " + this.fieldWord(columnCounter);
                    tooFewCheck.setFound(found);
                    String explanation = "In row " + this.rowCounter + ", fewer fields were found in the row than were expected: ";
                    tooFewCheck.setFailedStatus();
                    explanation = explanation + "<![CDATA[" + data.trim() + "]]>";
                    tooFewCheck.setExplanation(explanation);
                    ++this.tooFewFieldsCounter;
                    if (this.tooFewFieldsCounter <= 5) {
                        this.entity.addQualityCheck(tooFewCheck);
                    }
                }
            }
            if (QualityCheck.shouldRunQualityCheck(this.entity, tooManyCheck = new QualityCheck(tooManyIdentifier = "tooManyFields", tooManyTemplate = QualityReport.getQualityCheckTemplate(tooManyIdentifier)))) {
                boolean foundTooMany;
                boolean bl = foundTooMany = columnCounter > this.numCols;
                if (foundTooMany) {
                    String expected = this.numCols + " " + this.fieldWord(this.numCols);
                    tooManyCheck.setExpected(expected);
                    String found = columnCounter + " " + this.fieldWord(columnCounter);
                    tooManyCheck.setFound(found);
                    String explanation = null;
                    String truncatedData = data.trim();
                    if (truncatedData.length() > 200) {
                        truncatedData = truncatedData.substring(0, 200) + "... (truncated)";
                    }
                    explanation = "In row " + this.rowCounter + ", more fields were found in the row than were expected: ";
                    tooManyCheck.setFailedStatus();
                    explanation = explanation + "<![CDATA[" + truncatedData + "]]>";
                    tooManyCheck.setExplanation(explanation);
                    ++this.tooManyFieldsCounter;
                    if (this.tooManyFieldsCounter <= 5) {
                        this.entity.addQualityCheck(tooManyCheck);
                    }
                }
            }
            if (columnCounter > this.numCols) {
                throw new DataNotMatchingMetadataException("Metadata specifies that data has " + this.numCols + " columns, but the actual data has " + columnCounter + " columns. Please check that the metadata is correct.");
            }
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j] != null) {
                    rowVector.addElement(stringArray[j].trim());
                    continue;
                }
                rowVector.addElement("");
            }
            int rowVectorSize = rowVector.size();
            if (rowVectorSize < this.numCols) {
                for (int j = 0; j < this.numCols - rowVectorSize; ++j) {
                    rowVector.addElement("");
                }
            }
        }
        return rowVector;
    }

    private String fieldWord(int numFields) {
        return numFields == 1 ? "field" : "fields";
    }

    private String[] processQuoteCharacterOneRowData(String oneRowData) throws Exception {
        String[] elements = null;
        Vector<String> elementsVector = new Vector<String>();
        if (oneRowData == null) {
            return elements;
        }
        this.quoteCharacter = this.transformQuoteCharacter(this.quoteCharacter);
        char quote = '#';
        boolean quoted = false;
        if (this.quoteCharacter != null) {
            quoted = true;
            quote = this.quoteCharacter.charAt(0);
        }
        char literal = '/';
        boolean literaled = false;
        if (this.literalCharacter != null) {
            literaled = true;
            literal = this.literalCharacter.charAt(0);
        }
        if (literaled && this.literalCharacter.length() != 1) {
            throw new Exception("Literal Character length should be 1 character in EML");
        }
        char currentChar = '2';
        StringBuffer fieldData = new StringBuffer();
        int length = oneRowData.length();
        int priviousDelimiterIndex = -2;
        int currentDelimiterIndex = -2;
        int delimiterLength = this.fieldDelimiter.length();
        boolean startQuote = false;
        boolean delimiterAtEnd = false;
        StringBuffer delimiterStorage = new StringBuffer(this.fieldDelimiter.length());
        for (int i = 0; i < length; ++i) {
            char charBeforeDelimiter;
            currentChar = oneRowData.charAt(i);
            fieldData.append(currentChar);
            if (i < delimiterLength) {
                delimiterStorage.append(currentChar);
            } else {
                delimiterStorage = DelimitedReader.shiftBuffer(delimiterStorage, currentChar);
            }
            if (quoted && currentChar == quote) {
                char previousChar = '1';
                boolean escapingQuote = false;
                if (literaled && i - 1 >= 0 && (previousChar = (char)oneRowData.charAt(i - 1)) == literal) {
                    int fieldLength;
                    escapingQuote = true;
                    if (!this.includeLiteralCharacter && (fieldLength = fieldData.length()) - 1 - 1 >= 0) {
                        fieldData.deleteCharAt(fieldLength - 1 - 1);
                    }
                }
                if (!escapingQuote) {
                    startQuote = !startQuote;
                }
            }
            if (delimiterStorage.indexOf(this.fieldDelimiter) == -1 || startQuote) continue;
            int indexOfCharBeforeDelimiter = i - delimiterLength;
            boolean escapeDelimiter = false;
            if (literaled && indexOfCharBeforeDelimiter >= 0 && (charBeforeDelimiter = oneRowData.charAt(indexOfCharBeforeDelimiter)) == literal) {
                int fieldLength;
                if (!this.includeLiteralCharacter && (fieldLength = fieldData.length()) - delimiterLength - 1 >= 0) {
                    fieldData.deleteCharAt(fieldLength - delimiterLength - 1);
                }
                escapeDelimiter = true;
                continue;
            }
            if (i == length - 1 && !startQuote && !escapeDelimiter) {
                delimiterAtEnd = true;
            }
            if (this.collapseDelimiters && (currentDelimiterIndex = i) - (priviousDelimiterIndex = currentDelimiterIndex) == delimiterLength) {
                fieldData = new StringBuffer();
                continue;
            }
            String value = "";
            int delimiterIndex = fieldData.lastIndexOf(this.fieldDelimiter);
            value = delimiterIndex == 0 ? "" : fieldData.substring(0, delimiterIndex);
            elementsVector.add(value);
            fieldData = new StringBuffer();
        }
        if (startQuote) {
            throw new Exception("There is a un-closed quote in data file");
        }
        String lastFieldValue = null;
        lastFieldValue = delimiterAtEnd ? "" : fieldData.toString();
        elementsVector.add(lastFieldValue);
        int size = elementsVector.size();
        elements = new String[size];
        for (int i = 0; i < size; ++i) {
            elements[i] = (String)elementsVector.elementAt(i);
        }
        if (quoted) {
            elements = this.stripQuotes(elements, quote);
        }
        return elements;
    }

    private String[] stripQuotes(String[] elements, char quote) {
        for (int i = 0; i < elements.length; ++i) {
            String newElement;
            int len;
            String element = elements[i];
            if (element != null) {
                element = element.trim();
            }
            if ((len = element.length()) <= 1 || element.charAt(0) != quote || element.charAt(len - 1) != quote) continue;
            elements[i] = newElement = element.substring(1, len - 1);
        }
        return elements;
    }

    private static StringBuffer shiftBuffer(StringBuffer buffer, char newChar) {
        StringBuffer newBuffer = new StringBuffer();
        if (buffer == null) {
            return newBuffer;
        }
        int size = buffer.length();
        for (int i = 0; i < size; ++i) {
            char oldChar = buffer.charAt(i);
            if (i <= 0) continue;
            newBuffer.append(oldChar);
        }
        newBuffer.append(newChar);
        return newBuffer;
    }

    private String transformQuoteCharacter(String quote) throws Exception {
        String newQuote = quote;
        if (newQuote == null) {
            return newQuote;
        }
        if (newQuote.startsWith("#") && newQuote.length() > 1) {
            String digits = newQuote.substring(1, newQuote.length());
            int radix = 10;
            if (digits.startsWith("x")) {
                radix = 16;
                digits = digits.substring(1, digits.length());
            }
            newQuote = DelimitedReader.transformDigitsToCharString(radix, digits);
        } else if ((newQuote.startsWith("0x") || newQuote.startsWith("0X")) && newQuote.length() > 2) {
            int radix = 16;
            String digits = newQuote.substring(2, newQuote.length());
            newQuote = DelimitedReader.transformDigitsToCharString(radix, digits);
        }
        if (newQuote.length() > 1) {
            throw new Exception("Quote string length should be 1 character in EML");
        }
        return newQuote;
    }

    public Vector[] getTokenizedData(boolean stripHeaderLines) {
        if (stripHeaderLines) {
            Vector[] strip = null;
            if (this.numRecords > this.numHeaderLines) {
                strip = new Vector[this.numRecords - this.numHeaderLines];
                for (int i = this.numHeaderLines; i < this.lines.length; ++i) {
                    strip[i - this.numHeaderLines] = this.lines[i];
                }
            }
            return strip;
        }
        return this.lines;
    }

    public int getTooFewFieldsCounter() {
        return this.tooFewFieldsCounter;
    }

    public int getTooManyFieldsCounter() {
        return this.tooManyFieldsCounter;
    }

    public boolean hasRecordDelimiter() {
        return this.hasRecordDelimiter;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.lines.length; ++i) {
            for (int j = 0; j < this.lines[i].size(); ++j) {
                sb.append((String)this.lines[i].elementAt(j));
                if (j == this.lines[i].size() - 1) continue;
                sb.append(" || ");
            }
            sb.append(this.lineEnding);
        }
        return sb.toString();
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }
}

