/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.config.MapConfig;
import com.hazelcast.impl.management.ConsoleRequest;
import com.hazelcast.impl.management.GetMapConfigCallable;
import com.hazelcast.impl.management.ManagementCenterService;
import com.hazelcast.impl.management.UpdateMapConfigCallable;
import com.hazelcast.nio.Address;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MapConfigRequest
implements ConsoleRequest {
    private String map;
    private MapConfig config;
    private boolean update;
    private Address target;

    public MapConfigRequest() {
    }

    public MapConfigRequest(String map, MapConfig config) {
        this.map = map;
        this.config = config;
        this.update = true;
    }

    public MapConfigRequest(String map, Address target) {
        this.map = map;
        this.target = target;
        this.update = false;
    }

    public Address getTarget() {
        return this.target;
    }

    public void setTarget(Address target) {
        this.target = target;
    }

    public int getType() {
        return 6;
    }

    public void writeResponse(ManagementCenterService mcs, DataOutput dos) throws Exception {
        dos.writeBoolean(this.update);
        if (this.update) {
            mcs.callOnAllMembers(new UpdateMapConfigCallable(this.map, this.config));
            dos.writeUTF("success");
        } else {
            MapConfig cfg = (MapConfig)mcs.call(this.target, new GetMapConfigCallable(this.map));
            if (cfg != null) {
                dos.writeBoolean(true);
                cfg.writeData(dos);
            } else {
                dos.writeBoolean(false);
            }
        }
    }

    public Object readResponse(DataInput in) throws IOException {
        this.update = in.readBoolean();
        if (!this.update) {
            if (in.readBoolean()) {
                MapConfig cfg = new MapConfig();
                cfg.readData(in);
                return cfg;
            }
            return null;
        }
        return in.readUTF();
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.map);
        out.writeBoolean(this.update);
        if (this.update) {
            this.config.writeData(out);
        } else {
            this.target.writeData(out);
        }
    }

    public void readData(DataInput in) throws IOException {
        this.map = in.readUTF();
        this.update = in.readBoolean();
        if (this.update) {
            this.config = new MapConfig();
            this.config.readData(in);
        } else {
            this.target = new Address();
            this.target.readData(in);
        }
    }
}

