/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ThreadWatcher;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class InOutSelector
implements Runnable {
    protected final ILogger logger;
    protected final Selector selector;
    protected final Queue<Runnable> selectorQueue = new ConcurrentLinkedQueue<Runnable>();
    protected final ConnectionManager connectionManager;
    private final int waitTime;
    protected boolean live = true;
    protected final ThreadWatcher threadWatcher = new ThreadWatcher();
    static final long TEN_SECOND_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private long lastPublish = 0L;

    public InOutSelector(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.logger = connectionManager.ioService.getLogger(this.getClass().getName());
        this.waitTime = 1;
        Selector selectorTemp = null;
        try {
            selectorTemp = Selector.open();
        }
        catch (IOException e) {
            this.handleSelectorException(e);
        }
        this.selector = selectorTemp;
        this.live = true;
    }

    public void shutdown() {
        this.selectorQueue.clear();
        try {
            final CountDownLatch l = new CountDownLatch(1);
            this.addTask(new Runnable(){

                public void run() {
                    InOutSelector.this.live = false;
                    InOutSelector.this.threadLocalShutdown();
                    l.countDown();
                }
            });
            l.await(5L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void threadLocalShutdown() {
    }

    public void addTask(Runnable runnable) {
        this.selectorQueue.offer(runnable);
    }

    private void processSelectionQueue() {
        while (this.live) {
            Runnable runnable = this.selectorQueue.poll();
            if (runnable == null) {
                return;
            }
            runnable.run();
        }
    }

    public void publishUtilization() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        try {
            this.connectionManager.ioService.onIOThreadStart();
            block24: while (true) {
                if (this.live == false) return;
                this.threadWatcher.incrementRunCount();
                currentMillis = Clock.currentTimeMillis();
                if (currentMillis - this.lastPublish > InOutSelector.TEN_SECOND_MILLIS) {
                    this.publishUtilization();
                    this.lastPublish = currentMillis;
                }
                this.processSelectionQueue();
                if (!this.live) {
                    return;
                }
                startWait = System.nanoTime();
                selectedKeyCount = this.selector.select(this.waitTime);
                now = System.nanoTime();
                this.threadWatcher.addWait(now - startWait, now);
                if (Thread.interrupted()) {
                    this.connectionManager.ioService.handleInterruptedException(Thread.currentThread(), new RuntimeException());
                    return;
                }
                if (selectedKeyCount == 0) continue;
                setSelectedKeys = this.selector.selectedKeys();
                it = setSelectedKeys.iterator();
                while (true) {
                    if (it.hasNext()) ** break;
                    continue block24;
                    sk = it.next();
                    try {
                        it.remove();
                        if (sk.isValid() && sk.isReadable()) {
                            connection = (Connection)sk.attachment();
                            connection.getReadHandler().handle();
                        }
                        if (!sk.isValid() || !sk.isWritable()) continue;
                        sk.interestOps(sk.interestOps() & -5);
                        connection = (Connection)sk.attachment();
                        connection.getWriteHandler().handle();
                    }
                    catch (Throwable e) {
                        this.handleSelectorException(e);
                    }
                }
                break;
            }
        }
        catch (OutOfMemoryError e) {
            this.connectionManager.ioService.onOutOfMemory(e);
            return;
        }
        catch (Throwable e) {
            this.logger.log(Level.WARNING, "unhandled exception in " + Thread.currentThread().getName(), e);
            return;
        }
        finally {
            try {
                this.logger.log(Level.FINEST, "closing selector " + Thread.currentThread().getName());
                this.selector.close();
            }
            catch (Exception ignored) {}
        }
    }

    protected void handleSelectorException(Throwable e) {
        String msg = "Selector exception at  " + Thread.currentThread().getName() + ", cause= " + e.toString();
        this.logger.log(Level.WARNING, msg, e);
        if (e instanceof OutOfMemoryError) {
            this.connectionManager.ioService.onOutOfMemory((OutOfMemoryError)e);
        }
    }
}

