/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.jena.atlas.iterator.AccString;
import org.apache.jena.atlas.iterator.Accumulate;
import org.apache.jena.atlas.iterator.Action;
import org.apache.jena.atlas.iterator.ActionCount;
import org.apache.jena.atlas.iterator.Filter;
import org.apache.jena.atlas.iterator.FilterDistinctAdjacent;
import org.apache.jena.atlas.iterator.FilterOutNulls;
import org.apache.jena.atlas.iterator.FilterUnique;
import org.apache.jena.atlas.iterator.IteratorCons;
import org.apache.jena.atlas.iterator.NullIterator;
import org.apache.jena.atlas.iterator.SingletonIterator;
import org.apache.jena.atlas.iterator.Transform;
import org.apache.jena.atlas.lib.ActionKeyValue;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sink;

public class Iter<T>
implements Iterable<T>,
Iterator<T> {
    private Iterator<T> iterator;

    public static <T> Iterator<T> singleton(T item) {
        return new SingletonIterator<T>(item);
    }

    public static <T> Iterator<T> nullIterator() {
        return new NullIterator();
    }

    public static <T> Set<T> toSet(Iterable<? extends T> stream) {
        return Iter.toSet(stream.iterator());
    }

    public static <T> Set<T> toSet(Iterator<? extends T> stream) {
        Accumulate action = new Accumulate<T, Set<T>>(){
            private Set<T> acc = null;

            @Override
            public void accumulate(T item) {
                this.acc.add(item);
            }

            @Override
            public Set<T> get() {
                return this.acc;
            }

            @Override
            public void start() {
                this.acc = new HashSet();
            }

            @Override
            public void finish() {
            }
        };
        return (Set)Iter.reduce(stream, action);
    }

    public static <T> List<T> toList(Iterable<? extends T> stream) {
        return Iter.toList(stream.iterator());
    }

    public static <T> List<T> toList(Iterator<? extends T> stream) {
        Accumulate action = new Accumulate<T, List<T>>(){
            private List<T> acc = null;

            @Override
            public void accumulate(T item) {
                this.acc.add(item);
            }

            @Override
            public List<T> get() {
                return this.acc;
            }

            @Override
            public void start() {
                this.acc = new ArrayList();
            }

            @Override
            public void finish() {
            }
        };
        return (List)Iter.reduce(stream, action);
    }

    public static <T> Iterator<T> iterator(Iterator<? extends T> iterator) {
        return Iter.toList(iterator).iterator();
    }

    public static <T, R> R foldLeft(Iterable<? extends T> stream, Folder<T, R> function, R value) {
        return Iter.foldLeft(stream.iterator(), function, value);
    }

    public static <T, R> R foldLeft(Iterator<? extends T> stream, Folder<T, R> function, R value) {
        while (stream.hasNext()) {
            T item = stream.next();
            value = function.eval(value, item);
        }
        return value;
    }

    public static <T, R> R foldRight(Iterable<? extends T> stream, Folder<T, R> function, R value) {
        return Iter.foldRight(stream.iterator(), function, value);
    }

    public static <T, R> R foldRight(Iterator<? extends T> stream, Folder<T, R> function, R value) {
        if (!stream.hasNext()) {
            return value;
        }
        T item = stream.next();
        return function.eval(Iter.foldRight(stream, function, value), item);
    }

    public static <T, R> R reduce(Iterable<? extends T> stream, Accumulate<T, R> aggregator) {
        return Iter.reduce(stream.iterator(), aggregator);
    }

    public static <T, R> R reduce(Iterator<? extends T> stream, Accumulate<T, R> aggregator) {
        aggregator.start();
        while (stream.hasNext()) {
            T item = stream.next();
            aggregator.accumulate(item);
        }
        aggregator.finish();
        return aggregator.get();
    }

    public static <T> void apply(Iterable<? extends T> stream, Action<T> action) {
        Iter.apply(stream.iterator(), action);
    }

    public static <T> void apply(Iterator<? extends T> stream, Action<T> action) {
        while (stream.hasNext()) {
            T item = stream.next();
            action.apply(item);
        }
    }

    public static <K, V> void apply(Map<K, V> map, ActionKeyValue<K, V> action) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            action.apply(entry.getKey(), entry.getValue());
        }
    }

    public static <T> Iterator<T> filter(Iterable<? extends T> stream, Filter<T> filter) {
        return Iter.filter(stream.iterator(), filter);
    }

    public static <T> Iterator<T> filter(final Iterator<? extends T> stream, final Filter<T> filter) {
        Iterator iter = new Iterator<T>(){
            boolean finished = false;
            boolean slotOccupied = false;
            T slot;

            @Override
            public boolean hasNext() {
                if (this.finished) {
                    return false;
                }
                while (!this.slotOccupied) {
                    if (!stream.hasNext()) {
                        this.finished = true;
                        break;
                    }
                    Object nextItem = stream.next();
                    if (!filter.accept(nextItem)) continue;
                    this.slot = nextItem;
                    this.slotOccupied = true;
                    break;
                }
                return this.slotOccupied;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    this.slotOccupied = false;
                    return this.slot;
                }
                throw new NoSuchElementException("filter.next");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("filter.remove");
            }
        };
        return iter;
    }

    public static <T> Iterator<T> notFilter(Iterable<? extends T> stream, Filter<T> filter) {
        return Iter.notFilter(stream.iterator(), filter);
    }

    public static <T> Iterator<T> notFilter(Iterator<? extends T> stream, Filter<T> filter) {
        Filter<T> flippedFilter = InvertedFilter.invert(filter);
        return Iter.filter(stream, flippedFilter);
    }

    public static <T> boolean every(Iterable<? extends T> stream, Filter<T> filter) {
        for (T item : stream) {
            if (filter.accept(item)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean every(Iterator<? extends T> stream, Filter<T> filter) {
        while (stream.hasNext()) {
            T item = stream.next();
            if (filter.accept(item)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean some(Iterable<? extends T> stream, Filter<T> filter) {
        for (T item : stream) {
            if (!filter.accept(item)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean some(Iterator<? extends T> stream, Filter<T> filter) {
        while (stream.hasNext()) {
            T item = stream.next();
            if (!filter.accept(item)) continue;
            return true;
        }
        return false;
    }

    public static <T, R> Iterator<R> map(Iterable<? extends T> stream, Transform<T, R> converter) {
        return Iter.map(stream.iterator(), converter);
    }

    public static <T, R> Iterator<R> map(final Iterator<? extends T> stream, final Transform<T, R> converter) {
        Iterator iter = new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return stream.hasNext();
            }

            @Override
            public R next() {
                return converter.convert(stream.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("map.remove");
            }
        };
        return iter;
    }

    public static <T, R> List<R> map(List<? extends T> list, Transform<T, R> converter) {
        return Iter.toList(Iter.map(list.iterator(), converter));
    }

    public static <T, R> Iterator<R> mapMany(final Iterator<? extends T> stream, final Transform<? super T, Iterator<R>> converter) {
        Iterator iter = new Iterator<R>(){
            private Iterator<? extends R> it = null;

            @Override
            public boolean hasNext() {
                if (this.it != null && this.it.hasNext()) {
                    return true;
                }
                this.it = null;
                while (stream.hasNext()) {
                    this.it = (Iterator)converter.convert(stream.next());
                    if (!this.it.hasNext()) continue;
                    return true;
                }
                this.it = null;
                return false;
            }

            @Override
            public R next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("mapMany.remove");
            }
        };
        return iter;
    }

    public static <T, R> Iterator<R> mapMany(Iterable<? extends T> stream, Transform<T, Iterator<R>> converter) {
        return Iter.mapMany(stream.iterator(), converter);
    }

    public static <T, R> List<R> mapMany(List<? extends T> list, Transform<T, Iterator<R>> converter) {
        return Iter.toList(Iter.mapMany(list.iterator(), converter));
    }

    public static <T> Iterator<T> operate(Iterable<? extends T> stream, Action<T> converter) {
        return Iter.operate(stream.iterator(), converter);
    }

    public static <T> Iterator<T> operate(final Iterator<? extends T> stream, final Action<T> action) {
        Iterator iter = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return stream.hasNext();
            }

            @Override
            public T next() {
                Object t = stream.next();
                action.apply(t);
                return t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("operate.remove");
            }
        };
        return iter;
    }

    public static <T> Iterator<T> printWrapper(Iterator<? extends T> stream) {
        return Iter.printWrapper(System.out, stream);
    }

    public static <T> Iterator<T> printWrapper(final PrintStream out, Iterator<? extends T> stream) {
        Action action = new Action<T>(){

            @Override
            public void apply(T item) {
                out.println(item);
            }
        };
        return Iter.operate(stream, action);
    }

    public static <T> Iterator<T> append(Iterable<T> iter1, Iterable<T> iter2) {
        return IteratorCons.create(Iter.iterator(iter1), Iter.iterator(iter2));
    }

    public static <T> Iterator<T> append(Iterator<? extends T> iter1, Iterator<? extends T> iter2) {
        return IteratorCons.create(iter1, iter2);
    }

    private static <T> Iterator<T> iterator(Iterable<T> iter) {
        return iter == null ? null : iter.iterator();
    }

    public static <T> Iterator<T> distinct(Iterable<T> iter) {
        return Iter.distinct(iter.iterator());
    }

    public static <T> Iterator<T> distinct(Iterator<T> iter) {
        return Iter.filter(iter, new FilterUnique());
    }

    public static <T> Iterator<T> distinctAdjacent(Iterable<T> iter) {
        return Iter.distinctAdjacent(iter.iterator());
    }

    public static <T> Iterator<T> distinctAdjacent(Iterator<T> iter) {
        return Iter.filter(iter, new FilterDistinctAdjacent());
    }

    public static <T> Iterator<T> removeNulls(Iterable<T> iter) {
        return Iter.filter(iter, new FilterOutNulls());
    }

    public static <T> Iterator<T> removeNulls(Iterator<T> iter) {
        return Iter.filter(iter, new FilterOutNulls());
    }

    public static <T> List<T> take(Iterator<T> iter, int N) {
        iter = new IteratorN<T>(iter, N);
        ArrayList<T> x = new ArrayList<T>(N);
        while (iter.hasNext()) {
            x.add(iter.next());
        }
        return x;
    }

    public static <T> Iterator<T> convert(Iterator<?> iterator) {
        return iterator;
    }

    public static <T> long count(Iterable<T> iterable) {
        return Iter.count(iterable.iterator());
    }

    public static <T> long count(Iterator<T> iterator) {
        long x = 0L;
        while (iterator.hasNext()) {
            iterator.next();
            ++x;
        }
        return x;
    }

    public static <T> void consume(Iterable<T> iterator) {
        Iter.count(iterator);
    }

    public static <T> void consume(Iterator<T> iterator) {
        Iter.count(iterator);
    }

    public static <T> String asString(Iterable<T> stream) {
        return Iter.asString(stream, new AccString());
    }

    public static <T> String asString(Iterator<T> stream) {
        return Iter.asString(stream, new AccString());
    }

    public static <T> String asString(Iter<T> stream) {
        return Iter.asString(stream, new AccString());
    }

    public static <T> String asString(Iterable<T> stream, String sep) {
        return Iter.asString(stream, new AccString(sep));
    }

    public static <T> String asString(Iterator<T> stream, String sep) {
        return Iter.asString(stream, new AccString(sep));
    }

    public static <T> String asString(Iter<T> stream, String sep) {
        return Iter.asString(stream.iterator(), new AccString(sep));
    }

    public static <T> String asString(Iterable<T> stream, AccString<T> formatter) {
        return (String)Iter.reduce(stream, formatter);
    }

    public static <T> String asString(Iterator<T> stream, AccString<T> formatter) {
        return (String)Iter.reduce(stream, formatter);
    }

    public static <T> String asString(Iter<T> stream, AccString<T> formatter) {
        return (String)Iter.reduce(stream.iterator(), formatter);
    }

    public static <T> void close(Iterator<T> iter) {
        if (iter instanceof Closeable) {
            ((Closeable)((Object)iter)).close();
        }
    }

    public static <T> Iterator<T> debug(Iterator<T> stream) {
        return Iter.debug(System.out, stream);
    }

    public static <T> Iterator<T> debug(final PrintStream out, Iterator<T> stream) {
        Transform x = new Transform<T, T>(){

            @Override
            public T convert(T item) {
                out.println(item);
                return item;
            }
        };
        return Iter.map(stream, x);
    }

    public static <T> void print(Iterator<T> stream) {
        Iter.print(System.out, stream);
    }

    public static <T> void print(final PrintStream out, Iterator<T> stream) {
        Action x = new Action<T>(){

            @Override
            public void apply(T item) {
                out.println(item);
            }
        };
        Iter.apply(stream, x);
    }

    public static <T> void print(PrintStream out, Iterable<T> iterable) {
        Iter.print(out, iterable.iterator());
    }

    public static <T> void print(Iterable<T> iterable) {
        Iter.print(iterable.iterator());
    }

    public static <T> void sendToSink(Iterator<T> iter, Sink<T> sink) {
        while (iter.hasNext()) {
            T thing = iter.next();
            sink.send(thing);
        }
        sink.close();
    }

    public static <T> void sendToSink(Iterable<T> stream, Sink<T> sink) {
        Iter.sendToSink(stream.iterator(), sink);
    }

    public static <T> Iter<T> iter(Iter<T> iter) {
        return iter;
    }

    public static <T> Iter<T> iterSingleton(T x) {
        return Iter.iter(SingletonIterator.create(x));
    }

    public static <T> Iter<T> iter(Collection<T> collection) {
        return Iter.iter(collection.iterator());
    }

    public static <T> Iter<T> iter(Iterator<T> iterator) {
        if (iterator instanceof Iter) {
            return (Iter)iterator;
        }
        return new Iter<T>(iterator);
    }

    public static <T> Iter<T> iter(Iterable<T> iterable) {
        if (iterable instanceof Iter) {
            return (Iter)iterable;
        }
        return new Iter<T>(iterable.iterator());
    }

    public static <T> Iter<T> singletonIter(T item) {
        return new Iter<T>(new SingletonIterator<T>(item));
    }

    public static <T> Iter<T> nullIter() {
        return new Iter(new NullIterator());
    }

    public static <T> Iterator<T> materialize(Iterator<T> iter) {
        return Iter.toList(iter).iterator();
    }

    public static <T> Iter<T> concat(Iter<T> iter1, Iter<T> iter2) {
        if (iter1 == null) {
            return iter2;
        }
        if (iter2 == null) {
            return iter1;
        }
        return iter1.append(iter2);
    }

    public static <T> Iterator<T> concat(Iterator<T> iter1, Iterator<T> iter2) {
        if (iter1 == null) {
            return iter2;
        }
        if (iter2 == null) {
            return iter1;
        }
        return Iter.iter(iter1).append(Iter.iter(iter2));
    }

    public static <T> T first(Iterator<T> iter, Filter<T> filter) {
        int idx = 0;
        while (iter.hasNext()) {
            T t = iter.next();
            if (filter.accept(t)) {
                return t;
            }
            ++idx;
        }
        return null;
    }

    public static <T> T first(Collection<T> collection, Filter<T> filter) {
        return Iter.first(collection.iterator(), filter);
    }

    public static <T> int firstIndex(Iterator<T> iter, Filter<T> filter) {
        int idx = 0;
        while (iter.hasNext()) {
            T t = iter.next();
            if (filter.accept(t)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static <T> int firstIndex(Collection<T> collection, Filter<T> filter) {
        return Iter.firstIndex(collection.iterator(), filter);
    }

    public static <T> T last(Iterator<T> iter, Filter<T> filter) {
        T thing = null;
        int idx = 0;
        while (iter.hasNext()) {
            T t = iter.next();
            if (filter.accept(t)) {
                thing = t;
            }
            ++idx;
        }
        return thing;
    }

    public static <T> T last(Collection<T> collection, Filter<T> filter) {
        return Iter.last(collection.iterator(), filter);
    }

    public static <T> int lastIndex(Iterator<T> iter, Filter<T> filter) {
        int location = -1;
        int idx = 0;
        while (iter.hasNext()) {
            T t = iter.next();
            if (filter.accept(t)) {
                location = idx;
            }
            ++idx;
        }
        return location;
    }

    public static <T> int lastIndex(Collection<T> collection, Filter<T> filter) {
        return Iter.lastIndex(collection.iterator(), filter);
    }

    private Iter(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    public Set<T> toSet() {
        return Iter.toSet(this.iterator);
    }

    public List<T> toList() {
        return Iter.toList(this.iterator);
    }

    public void sendToSink(Sink<T> sink) {
        Iter.sendToSink(this.iterator, sink);
    }

    public T first(Filter<T> filter) {
        return Iter.first(this.iterator, filter);
    }

    public int firstIndex(Filter<T> filter) {
        return Iter.firstIndex(this.iterator, filter);
    }

    public T last(Filter<T> filter) {
        return Iter.last(this.iterator, filter);
    }

    public int lastIndex(Filter<T> filter) {
        return Iter.lastIndex(this.iterator, filter);
    }

    public Iter<T> filter(Filter<T> filter) {
        return Iter.iter(Iter.filter(this.iterator, filter));
    }

    public boolean every(Filter<T> filter) {
        return Iter.every(this.iterator, filter);
    }

    public boolean some(Filter<T> filter) {
        return Iter.some(this.iterator, filter);
    }

    public Iter<T> removeNulls() {
        return this.filter(new FilterOutNulls());
    }

    public <R> Iter<R> map(Transform<T, R> converter) {
        return Iter.iter(Iter.map(this.iterator, converter));
    }

    public Iter<T> operate(Action<T> action) {
        return Iter.iter(Iter.operate(this.iterator, action));
    }

    public <R> R reduce(Accumulate<T, R> aggregator) {
        return Iter.reduce(this.iterator, aggregator);
    }

    public void apply(Action<T> action) {
        Iter.apply(this.iterator, action);
    }

    public Iter<T> append(Iterator<T> iter) {
        return new Iter<T>(IteratorCons.create(this.iterator, iter));
    }

    public Iter<T> take(int N) {
        return Iter.iter(Iter.take(this.iterator, N));
    }

    public long count() {
        ActionCount action = new ActionCount();
        this.apply(action);
        return action.getCount();
    }

    public String asString() {
        return Iter.asString(this.iterator);
    }

    public String asString(String sep) {
        return Iter.asString(this.iterator, sep);
    }

    public Iter<T> distinct() {
        return new Iter<T>(Iter.distinct(this.iterator()));
    }

    public Iter<T> distinctAdjacent() {
        return new Iter<T>(Iter.distinctAdjacent(this.iterator()));
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    static class IteratorN<T>
    implements Iterator<T> {
        private final Iterator<T> iter;
        private final int N;
        private int count;

        IteratorN(Iterator<T> iter, int N) {
            this.iter = iter;
            this.N = N;
            this.count = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.count >= this.N) {
                return false;
            }
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            if (this.count >= this.N) {
                throw new NoSuchElementException();
            }
            T x = this.iter.next();
            ++this.count;
            return x;
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    private static class InvertedFilter<T>
    implements Filter<T> {
        private Filter<T> baseFilter;

        public static <T> Filter<T> invert(Filter<T> filter) {
            return new InvertedFilter<T>(filter);
        }

        private InvertedFilter(Filter<T> baseFilter) {
            this.baseFilter = baseFilter;
        }

        @Override
        public boolean accept(T item) {
            return !this.baseFilter.accept(item);
        }
    }

    public static interface Folder<X, Y> {
        public Y eval(Y var1, X var2);
    }
}

