/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryCancelledException;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterNullIterator;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.lib.Lib2;
import com.hp.hpl.jena.tdb.lib.NodeLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.solver.Abortable;
import com.hp.hpl.jena.tdb.solver.BindingNodeId;
import com.hp.hpl.jena.tdb.solver.BindingTDB;
import com.hp.hpl.jena.tdb.solver.QueryIterTDB;
import com.hp.hpl.jena.tdb.solver.StageMatchTuple;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.sys.TDBInternal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.iterator.Action;
import org.apache.jena.atlas.iterator.Filter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorWrapper;
import org.apache.jena.atlas.iterator.Transform;
import org.apache.jena.atlas.lib.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolverLib {
    private static Logger log = LoggerFactory.getLogger(SolverLib.class);
    public static final ConvertNodeIDToNode converter = new ConvertNodeIDToNode(){

        @Override
        public Iterator<Binding> convert(NodeTable nodeTable, Iterator<BindingNodeId> iterBindingIds) {
            return Iter.map(iterBindingIds, (Transform)SolverLib.convToBinding(nodeTable));
        }
    };
    private static Action<Tuple<NodeId>> quadsToAnyTriples = new Action<Tuple<NodeId>>(){

        public void apply(Tuple<NodeId> item) {
            ((NodeId[])item.tuple())[0] = NodeId.NodeIdAny;
        }
    };

    public static QueryIterator execute(GraphTDB graph, BasicPattern pattern, QueryIterator input, Filter<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        NodeTupleTable ntt = graph.getNodeTupleTable();
        return SolverLib.execute(ntt, graph.getGraphName(), pattern, input, filter, execCxt);
    }

    public static QueryIterator execute(DatasetGraphTDB ds, Node graphNode, BasicPattern pattern, QueryIterator input, Filter<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        NodeTupleTable ntt = ds.chooseNodeTupleTable(graphNode);
        return SolverLib.execute(ntt, graphNode, pattern, input, filter, execCxt);
    }

    public static Iterator<BindingNodeId> convertToIds(Iterator<Binding> iterBindings, NodeTable nodeTable) {
        return Iter.map(iterBindings, SolverLib.convFromBinding(nodeTable));
    }

    public static Iterator<Binding> convertToNodes(Iterator<BindingNodeId> iterBindingIds, NodeTable nodeTable) {
        return Iter.map(iterBindingIds, SolverLib.convToBinding(nodeTable));
    }

    private static QueryIterator execute(NodeTupleTable nodeTupleTable, Node graphNode, BasicPattern pattern, QueryIterator input, Filter<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        List triples = pattern.getList();
        boolean anyGraph = graphNode == null ? false : Node.ANY.equals((Object)graphNode);
        int tupleLen = nodeTupleTable.getTupleTable().getTupleLen();
        if (graphNode == null) {
            if (3 != tupleLen) {
                throw new TDBException("SolverLib: Null graph node but tuples are of length " + tupleLen);
            }
        } else if (4 != tupleLen) {
            throw new TDBException("SolverLib: Graph node specified but tuples are of length " + tupleLen);
        }
        NodeTable nodeTable = nodeTupleTable.getNodeTable();
        Iterator<BindingNodeId> chain = Iter.map((Iterator)input, SolverLib.convFromBinding(nodeTable));
        ArrayList<Abortable> killList = new ArrayList<Abortable>();
        for (Triple triple : triples) {
            Tuple tuple = null;
            tuple = graphNode == null ? Tuple.create((Object[])new Node[]{triple.getSubject(), triple.getPredicate(), triple.getObject()}) : Tuple.create((Object[])new Node[]{graphNode, triple.getSubject(), triple.getPredicate(), triple.getObject()});
            chain = SolverLib.solve(nodeTupleTable, (Tuple<Node>)tuple, anyGraph, chain, filter, execCxt);
            chain = SolverLib.makeAbortable(chain, killList);
        }
        Iterator<Binding> iterBinding = converter.convert(nodeTable, chain);
        return new QueryIterTDB(iterBinding, killList, input, execCxt);
    }

    static <T> Iterator<T> makeAbortable(Iterator<T> iter, List<Abortable> killList) {
        if (killList == null) {
            return iter;
        }
        IterAbortable<T> k = new IterAbortable<T>(iter);
        killList.add(k);
        return k;
    }

    private static Iterator<BindingNodeId> solve(NodeTupleTable nodeTupleTable, Tuple<Node> tuple, boolean anyGraph, Iterator<BindingNodeId> chain, Filter<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        return new StageMatchTuple(nodeTupleTable, chain, tuple, anyGraph, filter, execCxt);
    }

    private static Transform<BindingNodeId, Binding> convToBinding(final NodeTable nodeTable) {
        return new Transform<BindingNodeId, Binding>(){

            public Binding convert(BindingNodeId bindingNodeIds) {
                return SolverLib.convToBinding(nodeTable, bindingNodeIds);
            }
        };
    }

    public static Binding convToBinding(NodeTable nodeTable, BindingNodeId bindingNodeIds) {
        return new BindingTDB(bindingNodeIds, nodeTable);
    }

    public static Transform<Binding, BindingNodeId> convFromBinding(final NodeTable nodeTable) {
        return new Transform<Binding, BindingNodeId>(){

            public BindingNodeId convert(Binding binding) {
                if (binding instanceof BindingTDB) {
                    return ((BindingTDB)binding).getBindingId();
                }
                BindingNodeId b = new BindingNodeId(binding);
                Iterator vars = binding.vars();
                while (vars.hasNext()) {
                    Var v = (Var)vars.next();
                    Node n = binding.get(v);
                    if (n == null) continue;
                    NodeId id = nodeTable.getNodeIdForNode(n);
                    b.put(v, id);
                }
                return b;
            }
        };
    }

    public static QueryIterator testForGraphName(DatasetGraphTDB ds, Node graphNode, QueryIterator input, Filter<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        boolean exists;
        NodeId nid = TDBInternal.getNodeId(ds, graphNode);
        boolean bl = exists = !NodeId.isDoesNotExist(nid);
        if (exists) {
            NodeTupleTable ntt = ds.getQuadTable().getNodeTupleTable();
            Iterator iter1 = ntt.find(nid, NodeId.NodeIdAny, NodeId.NodeIdAny, NodeId.NodeIdAny);
            if (filter != null) {
                iter1 = Iter.filter(iter1, filter);
            }
            exists = iter1.hasNext();
        }
        if (exists) {
            return input;
        }
        input.close();
        return QueryIterNullIterator.create((ExecutionContext)execCxt);
    }

    public static QueryIterator graphNames(DatasetGraphTDB ds, Node graphNode, QueryIterator input, Filter<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        ArrayList<Abortable> killList = new ArrayList<Abortable>();
        Iterator iter1 = ds.getQuadTable().getNodeTupleTable().find(NodeId.NodeIdAny, NodeId.NodeIdAny, NodeId.NodeIdAny, NodeId.NodeIdAny);
        if (filter != null) {
            iter1 = Iter.filter(iter1, filter);
        }
        Iterator iter2 = Tuple.project((int)0, iter1);
        iter2 = SolverLib.makeAbortable(iter2, killList);
        Iterator<NodeId> iter3 = Iter.distinct(iter2);
        iter3 = SolverLib.makeAbortable(iter3, killList);
        Iterator<Node> iter4 = NodeLib.nodes(ds.getQuadTable().getNodeTupleTable().getNodeTable(), iter3);
        final Var var = Var.alloc((Node)graphNode);
        Transform<Node, Binding> bindGraphName = new Transform<Node, Binding>(){

            public Binding convert(Node node) {
                return BindingFactory.binding((Var)var, (Node)node);
            }
        };
        Iterator iterBinding = Iter.map(iter4, (Transform)bindGraphName);
        return new QueryIterTDB(iterBinding, killList, input, execCxt);
    }

    public static String strPattern(BasicPattern pattern) {
        List triples = pattern.getList();
        String x = Iter.asString((Iterable)triples, (String)"\n  ");
        return Lib2.printAbbrev(x);
    }

    public static Set<NodeId> convertToNodeIds(Collection<Node> nodes, DatasetGraphTDB dataset) {
        HashSet<NodeId> graphIds = new HashSet<NodeId>();
        NodeTable nt = dataset.getQuadTable().getNodeTupleTable().getNodeTable();
        for (Node n : nodes) {
            graphIds.add(nt.getNodeIdForNode(n));
        }
        return graphIds;
    }

    public static Iterator<Tuple<NodeId>> unionGraph(NodeTupleTable ntt) {
        Iterator iter = ntt.find(new NodeId[]{null, null, null, null});
        iter = Iter.operate(iter, quadsToAnyTriples);
        iter = Iter.distinctAdjacent((Iterator)iter);
        return iter;
    }

    static class IterAbortable<T>
    extends IteratorWrapper<T>
    implements Abortable {
        volatile boolean abortFlag = false;

        public IterAbortable(Iterator<T> iterator) {
            super(iterator);
        }

        @Override
        public void abort() {
            this.abortFlag = true;
        }

        public boolean hasNext() {
            if (this.abortFlag) {
                throw new QueryCancelledException();
            }
            return this.iterator.hasNext();
        }

        public T next() {
            if (this.abortFlag) {
                throw new QueryCancelledException();
            }
            return (T)this.iterator.next();
        }
    }

    public static interface ConvertNodeIDToNode {
        public Iterator<Binding> convert(NodeTable var1, Iterator<BindingNodeId> var2);
    }
}

