/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.concurrentmap;

import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiData
implements DataSerializable {
    List<Data> lsData = null;

    public MultiData() {
    }

    public MultiData(Data d1, Data d2) {
        this.lsData = new ArrayList<Data>(2);
        this.lsData.add(d1);
        this.lsData.add(d2);
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        int size = this.lsData.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            Data d = this.lsData.get(i);
            d.writeData(out);
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        int size = in.readInt();
        this.lsData = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data data = new Data();
            data.readData(in);
            this.lsData.add(data);
        }
    }

    public int size() {
        return this.lsData == null ? 0 : this.lsData.size();
    }

    public List<Data> getAllData() {
        return this.lsData;
    }

    public Data getData(int index) {
        return this.lsData == null ? null : this.lsData.get(index);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MultiData");
        sb.append("{size=").append(this.size());
        sb.append('}');
        return sb.toString();
    }
}

