/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.Master;
import com.hazelcast.nio.Address;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Bind
extends Master {
    private Address targetAddress;
    private boolean replyBack = false;

    public Bind() {
    }

    public Bind(Address localAddress) {
        super(localAddress);
        this.targetAddress = null;
    }

    public Bind(Address localAddress, Address targetAddress, boolean replyBack) {
        super(localAddress);
        this.targetAddress = targetAddress;
        this.replyBack = replyBack;
    }

    public void process() {
        this.getNode().connectionManager.bind(this.getConnection(), this.address, this.targetAddress, this.replyBack);
    }

    public void readData(DataInput in) throws IOException {
        super.readData(in);
        boolean hasTarget = in.readBoolean();
        if (hasTarget) {
            this.targetAddress = new Address();
            this.targetAddress.readData(in);
        }
        this.replyBack = in.readBoolean();
    }

    public void writeData(DataOutput out) throws IOException {
        super.writeData(out);
        boolean hasTarget = this.targetAddress != null;
        out.writeBoolean(hasTarget);
        if (hasTarget) {
            this.targetAddress.writeData(out);
        }
        out.writeBoolean(this.replyBack);
    }

    public String toString() {
        return "Bind " + this.address;
    }
}

