/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.AlgebraQuad;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpPropFunc;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import java.util.Deque;

public class TransformQuadGraph
extends TransformCopy {
    private Deque<AlgebraQuad.QuadSlot> tracker;
    private OpVisitor beforeVisitor;
    private OpVisitor afterVisitor;

    public TransformQuadGraph(Deque<AlgebraQuad.QuadSlot> tracker, OpVisitor before, OpVisitor after) {
        this.tracker = tracker;
        this.beforeVisitor = before;
        this.afterVisitor = after;
    }

    private Node getNode() {
        return this.tracker.peek().rewriteGraphName;
    }

    @Override
    public Op transform(OpGraph opGraph, Op op) {
        boolean noPattern = false;
        AlgebraQuad.QuadSlot qSlot = this.tracker.peek();
        Node actualName = qSlot.actualGraphName;
        Node rewriteName = qSlot.rewriteGraphName;
        if (OpBGP.isBGP(op)) {
            if (((OpBGP)op).getPattern().isEmpty()) {
                noPattern = true;
            }
        } else if (op instanceof OpTable && ((OpTable)op).isJoinIdentity()) {
            noPattern = true;
        }
        if (noPattern) {
            return new OpDatasetNames(opGraph.getNode());
        }
        if (actualName != rewriteName) {
            op = OpAssign.assign(op, Var.alloc(actualName), new ExprVar(rewriteName));
        }
        return op;
    }

    @Override
    public Op transform(OpPropFunc opPropFunc, Op subOp) {
        if (opPropFunc.getSubOp() != subOp) {
            opPropFunc = new OpPropFunc(opPropFunc.getProperty(), opPropFunc.getSubjectArgs(), opPropFunc.getObjectArgs(), subOp);
        }
        return new OpGraph(this.getNode(), opPropFunc);
    }

    @Override
    public Op transform(OpPath opPath) {
        return new OpGraph(this.getNode(), opPath);
    }

    @Override
    public Op transform(OpBGP opBGP) {
        return new OpQuadPattern(this.getNode(), opBGP.getPattern());
    }

    @Override
    public Op transform(OpExt opExt) {
        return opExt.apply(this, this.beforeVisitor, this.afterVisitor);
    }
}

