/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.CipherHelper;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.SocketChannelWrapper;
import com.hazelcast.nio.SocketReader;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;

class SocketPacketReader
implements SocketReader {
    Packet packet = null;
    final PacketReader packetReader;
    final Connection connection;
    final IOService ioService;
    final SocketChannelWrapper socketChannel;
    final ILogger logger;

    public SocketPacketReader(SocketChannelWrapper socketChannel, Connection connection) {
        this.connection = connection;
        this.ioService = connection.getConnectionManager().ioService;
        this.socketChannel = socketChannel;
        this.logger = this.ioService.getLogger(SocketPacketReader.class.getName());
        boolean symmetricEncryptionEnabled = CipherHelper.isSymmetricEncryptionEnabled(this.ioService);
        boolean asymmetricEncryptionEnabled = CipherHelper.isAsymmetricEncryptionEnabled(this.ioService);
        if (asymmetricEncryptionEnabled || symmetricEncryptionEnabled) {
            if (asymmetricEncryptionEnabled && symmetricEncryptionEnabled) {
                this.packetReader = new ComplexCipherPacketReader();
                this.logger.log(Level.INFO, "Reader started with ComplexEncryption");
            } else if (symmetricEncryptionEnabled) {
                this.packetReader = new SymmetricCipherPacketReader();
                this.logger.log(Level.INFO, "Reader started with SymmetricEncryption");
            } else {
                this.packetReader = new AsymmetricCipherPacketReader();
                this.logger.log(Level.INFO, "Reader started with AsymmetricEncryption");
            }
        } else {
            this.packetReader = new DefaultPacketReader();
        }
    }

    public void read(ByteBuffer inBuffer) throws Exception {
        this.packetReader.readPacket(inBuffer);
    }

    public void enqueueFullPacket(Packet p) {
        p.flipBuffers();
        p.read();
        p.setFromConnection(this.connection);
        if (p.client) {
            this.connection.setType(Connection.Type.CLIENT);
            this.ioService.handleClientPacket(p);
        } else {
            this.connection.setType(Connection.Type.MEMBER);
            this.ioService.handleMemberPacket(p);
        }
    }

    public Packet obtainReadable() {
        return this.connection.obtainPacket();
    }

    class SymmetricCipherPacketReader
    implements PacketReader {
        int size = -1;
        final Cipher cipher;
        ByteBuffer cipherBuffer = ByteBuffer.allocate(65536);

        SymmetricCipherPacketReader() {
            this.cipher = this.init();
        }

        Cipher init() {
            Cipher c = null;
            try {
                c = CipherHelper.createSymmetricReaderCipher(SocketPacketReader.this.connection.getConnectionManager().ioService);
            }
            catch (Exception e) {
                SocketPacketReader.this.logger.log(Level.SEVERE, "Symmetric Cipher for ReadHandler cannot be initialized.", e);
            }
            return c;
        }

        public void readPacket(ByteBuffer inBuffer) throws Exception {
            while (inBuffer.hasRemaining()) {
                try {
                    int remaining;
                    if (this.size == -1) {
                        if (inBuffer.remaining() < 4) {
                            return;
                        }
                        this.size = inBuffer.getInt();
                    }
                    if ((remaining = inBuffer.remaining()) < this.size) {
                        this.cipher.update(inBuffer, this.cipherBuffer);
                        this.size -= remaining;
                    } else if (remaining == this.size) {
                        this.cipher.doFinal(inBuffer, this.cipherBuffer);
                        this.size = -1;
                    } else {
                        int oldLimit = inBuffer.limit();
                        int newLimit = inBuffer.position() + this.size;
                        inBuffer.limit(newLimit);
                        this.cipher.doFinal(inBuffer, this.cipherBuffer);
                        inBuffer.limit(oldLimit);
                        this.size = -1;
                    }
                }
                catch (ShortBufferException e) {
                    SocketPacketReader.this.logger.log(Level.WARNING, e.getMessage(), e);
                }
                this.cipherBuffer.flip();
                while (this.cipherBuffer.hasRemaining()) {
                    boolean complete;
                    if (SocketPacketReader.this.packet == null) {
                        SocketPacketReader.this.packet = SocketPacketReader.this.obtainReadable();
                    }
                    if (!(complete = SocketPacketReader.this.packet.read(this.cipherBuffer))) continue;
                    SocketPacketReader.this.enqueueFullPacket(SocketPacketReader.this.packet);
                    SocketPacketReader.this.packet = null;
                }
                this.cipherBuffer.clear();
            }
        }
    }

    class AsymmetricCipherPacketReader
    implements PacketReader {
        Cipher cipher = null;
        ByteBuffer cipherBuffer = ByteBuffer.allocate(128);
        ByteBuffer bbAlias = null;
        boolean aliasSizeSet = false;

        AsymmetricCipherPacketReader() {
        }

        public void readPacket(ByteBuffer inBuffer) throws Exception {
            if (this.cipher == null) {
                if (!this.aliasSizeSet) {
                    if (inBuffer.remaining() < 4) {
                        return;
                    }
                    int aliasSize = inBuffer.getInt();
                    this.bbAlias = ByteBuffer.allocate(aliasSize);
                }
                IOUtil.copyToHeapBuffer(inBuffer, this.bbAlias);
                if (!this.bbAlias.hasRemaining()) {
                    this.bbAlias.flip();
                    String remoteAlias = new String(this.bbAlias.array(), 0, this.bbAlias.limit());
                    this.cipher = CipherHelper.createAsymmetricReaderCipher(SocketPacketReader.this.connection.getConnectionManager().ioService, remoteAlias);
                }
            }
            while (inBuffer.remaining() >= 128) {
                if (this.cipherBuffer.position() > 0) {
                    throw new RuntimeException();
                }
                int oldLimit = inBuffer.limit();
                inBuffer.limit(inBuffer.position() + 128);
                int cipherReadSize = this.cipher.doFinal(inBuffer, this.cipherBuffer);
                inBuffer.limit(oldLimit);
                this.cipherBuffer.flip();
                while (this.cipherBuffer.hasRemaining()) {
                    boolean complete;
                    if (SocketPacketReader.this.packet == null) {
                        SocketPacketReader.this.packet = SocketPacketReader.this.obtainReadable();
                    }
                    if (!(complete = SocketPacketReader.this.packet.read(this.cipherBuffer))) continue;
                    SocketPacketReader.this.enqueueFullPacket(SocketPacketReader.this.packet);
                    SocketPacketReader.this.packet = null;
                }
                this.cipherBuffer.clear();
            }
        }
    }

    class ComplexCipherPacketReader
    implements PacketReader {
        ComplexCipherPacketReader() {
        }

        public void readPacket(ByteBuffer inBuffer) throws Exception {
        }
    }

    class DefaultPacketReader
    implements PacketReader {
        DefaultPacketReader() {
        }

        public void readPacket(ByteBuffer inBuffer) {
            while (inBuffer.hasRemaining()) {
                boolean complete;
                if (SocketPacketReader.this.packet == null) {
                    SocketPacketReader.this.packet = SocketPacketReader.this.obtainReadable();
                }
                if (!(complete = SocketPacketReader.this.packet.read(inBuffer))) continue;
                SocketPacketReader.this.enqueueFullPacket(SocketPacketReader.this.packet);
                SocketPacketReader.this.packet = null;
            }
        }
    }

    static interface PacketReader {
        public void readPacket(ByteBuffer var1) throws Exception;
    }
}

